/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.manipulation;

import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;

public class JavaElementPropertyTester
extends PropertyTester {
    public static final String NAME = "name";
    public static final String IS_IN_JAVA_PROJECT = "isInJavaProject";
    public static final String IS_IN_JAVA_PROJECT_WITH_NATURE = "isInJavaProjectWithNature";
    public static final String IS_ON_CLASSPATH = "isOnClasspath";
    public static final String HAS_TYPE_ON_CLASSPATH = "hasTypeOnClasspath";
    public static final String IN_SOURCE_FOLDER = "inSourceFolder";
    public static final String IN_ARCHIVE = "inArchive";
    public static final String IN_EXTERNAL_ARCHIVE = "inExternalArchive";
    public static final String PROJECT_OPTION = "projectOption";

    public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
        IJavaScriptProject javaProject;
        if (!(receiver instanceof IJavaScriptElement)) {
            return false;
        }
        IJavaScriptElement res = (IJavaScriptElement)receiver;
        if (method.equals(NAME)) {
            return Pattern.matches(this.toString(expectedValue), res.getElementName());
        }
        if (method.equals(IS_IN_JAVA_PROJECT)) {
            IJavaScriptProject javaProject2 = res.getJavaScriptProject();
            return javaProject2 != null && javaProject2.exists() && javaProject2.getProject().isOpen();
        }
        if (method.equals(IS_IN_JAVA_PROJECT_WITH_NATURE)) {
            IJavaScriptProject javaProject3 = res.getJavaScriptProject();
            if (javaProject3 != null && javaProject3.exists() && javaProject3.getProject().isOpen() && expectedValue != null) {
                try {
                    return javaProject3.getProject().hasNature(this.toString(expectedValue));
                }
                catch (CoreException e) {
                    return false;
                }
            }
            return false;
        }
        if (method.equals(IS_ON_CLASSPATH)) {
            IJavaScriptProject javaProject4 = res.getJavaScriptProject();
            if (javaProject4 != null && javaProject4.exists()) {
                return javaProject4.isOnIncludepath(res);
            }
            return false;
        }
        if (method.equals(IN_SOURCE_FOLDER)) {
            IJavaScriptElement root = res.getAncestor(3);
            if (root != null) {
                try {
                    return ((IPackageFragmentRoot)root).getKind() == 1;
                }
                catch (JavaScriptModelException e) {
                    // empty catch block
                }
            }
            return false;
        }
        if (method.equals(IN_ARCHIVE)) {
            IJavaScriptElement root = res.getAncestor(3);
            if (root != null) {
                return ((IPackageFragmentRoot)root).isArchive();
            }
            return false;
        }
        if (method.equals(IN_EXTERNAL_ARCHIVE)) {
            IJavaScriptElement root = res.getAncestor(3);
            if (root != null) {
                return ((IPackageFragmentRoot)root).isExternal();
            }
            return false;
        }
        if (method.equals(PROJECT_OPTION)) {
            IJavaScriptProject project = res.getJavaScriptProject();
            if (project != null) {
                if (args.length == 2) {
                    String current = project.getOption(this.toString(args[0]), true);
                    return current != null && current.equals(args[1]);
                }
                if (args.length == 1) {
                    return project.getOption(this.toString(args[0]), false) != null;
                }
            }
            return false;
        }
        if (method.equals(HAS_TYPE_ON_CLASSPATH) && (javaProject = res.getJavaScriptProject()) != null && javaProject.exists()) {
            try {
                return javaProject.findType(this.toString(expectedValue)) != null;
            }
            catch (JavaScriptModelException e) {
                return false;
            }
        }
        return false;
    }

    private String toString(Object expectedValue) {
        return expectedValue == null ? "" : expectedValue.toString();
    }
}

