/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.quickaccess.CamelUtil;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public abstract class QuickAccessElement {
    static final String separator = " - ";
    private static final int[][] EMPTY_INDICES = new int[0][0];
    private QuickAccessProvider provider;
    private static final String WS_START = "^\\s+";
    private static final String WS_END = "\\s+$";
    private static final String ANY_WS = "\\s+";
    private static final String EMPTY_STR = "";
    private static final String PAR_START = "\\(";
    private static final String PAR_END = "\\)";
    private static final String ONE_CHAR = ".?";
    private String wsFilter;
    private Pattern wsPattern;
    private String wcFilter;
    private Pattern wcPattern;
    int i = 0;

    public QuickAccessElement(QuickAccessProvider provider) {
        this.provider = provider;
    }

    public abstract String getLabel();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract String getId();

    public abstract void execute();

    public String getSortLabel() {
        return this.getLabel();
    }

    public QuickAccessProvider getProvider() {
        return this.provider;
    }

    private Pattern getWhitespacesPattern(String filter) {
        if (this.wsPattern == null || !filter.equals(this.wsFilter)) {
            this.wsFilter = filter;
            String sFilter = filter.replaceFirst(WS_START, EMPTY_STR).replaceFirst(WS_END, EMPTY_STR).replaceAll(PAR_START, ONE_CHAR).replaceAll(PAR_END, ONE_CHAR);
            sFilter = String.format(".*(%s).*", sFilter.replaceAll(ANY_WS, ").*("));
            this.wsPattern = this.safeCompile(sFilter);
        }
        return this.wsPattern;
    }

    private Pattern getWildcardsPattern(String filter) {
        if (this.wcPattern == null || !filter.equals(this.wcFilter)) {
            this.wcFilter = filter;
            String sFilter = filter.replaceFirst(WS_START, EMPTY_STR).replaceFirst(WS_END, EMPTY_STR).replaceAll(PAR_START, ONE_CHAR).replaceAll(PAR_END, ONE_CHAR);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < sFilter.length()) {
                char c = sFilter.charAt(i);
                if (c == '*' || c == '?') {
                    sb.append(").").append(c).append("(");
                } else {
                    sb.append(c);
                }
                ++i;
            }
            sFilter = String.format(".*(%s).*", sb.toString());
            this.wcPattern = this.safeCompile(sFilter);
        }
        return this.wcPattern;
    }

    private Pattern safeCompile(String pattern) {
        try {
            return Pattern.compile(pattern, 2);
        }
        catch (Exception e) {
            return Pattern.compile("\\a");
        }
    }

    public QuickAccessEntry match(String filter, QuickAccessProvider providerForMatching) {
        String sortLabel = this.getLabel();
        int index = sortLabel.toLowerCase().indexOf(filter);
        if (index != -1) {
            int quality = sortLabel.toLowerCase().equals(filter) ? 0 : (sortLabel.toLowerCase().startsWith(filter) ? 5 : 10);
            return new QuickAccessEntry(this, providerForMatching, new int[][]{{index, index + filter.length() - 1}}, EMPTY_INDICES, quality);
        }
        Pattern p = filter.contains("*") || filter.contains("?") ? this.getWildcardsPattern(filter) : this.getWhitespacesPattern(filter);
        Matcher m = p.matcher(sortLabel);
        if (m.matches()) {
            int groupCount = m.groupCount();
            int[][] indices = new int[groupCount][];
            int i = 0;
            while (i < groupCount) {
                int nGrp = i + 1;
                indices[i] = new int[]{m.start(nGrp), m.end(nGrp) - 1};
                ++i;
            }
            int quality = 5;
            return new QuickAccessEntry(this, providerForMatching, indices, EMPTY_INDICES, quality);
        }
        String combinedLabel = String.valueOf(providerForMatching.getName()) + " " + this.getLabel();
        index = combinedLabel.toLowerCase().indexOf(filter);
        if (index != -1) {
            int lengthOfElementMatch = index + filter.length() - providerForMatching.getName().length() - 1;
            if (lengthOfElementMatch > 0) {
                int[][] nArrayArray = new int[1][];
                int[] nArray = new int[2];
                nArray[1] = lengthOfElementMatch - 1;
                nArrayArray[0] = nArray;
                return new QuickAccessEntry(this, providerForMatching, nArrayArray, new int[][]{{index, index + filter.length() - 1}}, 10);
            }
            return new QuickAccessEntry(this, providerForMatching, EMPTY_INDICES, new int[][]{{index, index + filter.length() - 1}}, 10);
        }
        String camelCase = CamelUtil.getCamelCase(sortLabel);
        index = camelCase.indexOf(filter);
        if (index != -1) {
            int[][] indices = CamelUtil.getCamelCaseIndices(sortLabel, index, filter.length());
            return new QuickAccessEntry(this, providerForMatching, indices, EMPTY_INDICES, 10);
        }
        String combinedCamelCase = CamelUtil.getCamelCase(combinedLabel);
        index = combinedCamelCase.indexOf(filter);
        if (index != -1) {
            String providerCamelCase = CamelUtil.getCamelCase(providerForMatching.getName());
            int lengthOfElementMatch = index + filter.length() - providerCamelCase.length();
            if (lengthOfElementMatch > 0) {
                return new QuickAccessEntry(this, providerForMatching, CamelUtil.getCamelCaseIndices(sortLabel, 0, lengthOfElementMatch), CamelUtil.getCamelCaseIndices(providerForMatching.getName(), index, filter.length() - lengthOfElementMatch), 10);
            }
            return new QuickAccessEntry(this, providerForMatching, EMPTY_INDICES, CamelUtil.getCamelCaseIndices(providerForMatching.getName(), index, filter.length()), 10);
        }
        return null;
    }
}

