/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RebaseTargetSelectionDialog
extends AbstractBranchSelectionDialog {
    private boolean interactive = false;
    private boolean preserveMerges = false;

    public RebaseTargetSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, RebaseTargetSelectionDialog.getMergeTarget(repo), 0x86 | RebaseTargetSelectionDialog.getSelectSetting(repo));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.RebaseTargetSelectionDialog_RebaseButton);
    }

    @Override
    protected String getMessageText() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.RebaseTargetSelectionDialog_DialogMessageWithBranch, branch);
        }
        return UIText.RebaseTargetSelectionDialog_DialogMessage;
    }

    @Override
    protected String getTitle() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.RebaseTargetSelectionDialog_DialogTitleWithBranch, branch);
        }
        return UIText.RebaseTargetSelectionDialog_DialogTitle;
    }

    @Override
    protected String getWindowTitle() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.RebaseTargetSelectionDialog_RebaseTitleWithBranch, branch);
        }
        return UIText.RebaseTargetSelectionDialog_RebaseTitle;
    }

    @Override
    protected void refNameSelected(String refName) {
        boolean currentSelected;
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        try {
            currentSelected = refName != null && refName.equals(this.repo.getFullBranch());
        }
        catch (IOException iOException) {
            currentSelected = false;
        }
        this.getButton(0).setEnabled(!currentSelected && (branchSelected || tagSelected));
    }

    @Override
    protected void createCustomArea(Composite parent) {
        final Button interactiveButton = new Button(parent, 32);
        interactiveButton.setText(UIText.RebaseTargetSelectionDialog_InteractiveButton);
        interactiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseTargetSelectionDialog.this.interactive = interactiveButton.getSelection();
            }
        });
        final Button preserveMergesButton = new Button(parent, 32);
        preserveMergesButton.setText(UIText.RebaseTargetSelectionDialog_PreserveMergesButton);
        preserveMergesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebaseTargetSelectionDialog.this.preserveMerges = preserveMergesButton.getSelection();
            }
        });
        String branchName = this.getCurrentBranch();
        if (branchName == null) {
            return;
        }
        StoredConfig cfg = this.repo.getConfig();
        BranchConfig.BranchRebaseMode rebase = (BranchConfig.BranchRebaseMode)cfg.getEnum((Enum[])BranchConfig.BranchRebaseMode.values(), "branch", branchName, "rebase", (Enum)BranchConfig.BranchRebaseMode.NONE);
        switch (rebase) {
            case PRESERVE: {
                preserveMergesButton.setSelection(true);
                this.preserveMerges = true;
                break;
            }
            case INTERACTIVE: {
                interactiveButton.setSelection(true);
                this.interactive = true;
                break;
            }
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isPreserveMerges() {
        return this.preserveMerges;
    }
}

