/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation;

import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.validation.AnnotationMsg;

public class MarkupValidator
extends AbstractValidator
implements IValidator {
    public static final int ELEMENT_ERROR_LIMIT = 25;
    public static final int PARTIAL = 1;
    public static final int TOTAL = 0;
    private String DQUOTE = "\"";
    private String SQUOTE = "'";
    private IDocument fDocument;
    private IContentType fRootContentType = null;
    private IReporter fReporter = null;
    private static final String ANNOTATIONMSG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.validation.AnnotationMsg");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ANNOTATIONMSG = clazz.getName();
    }

    public void getAnnotationMsg(IReporter reporter, int problemId, LocalizedMessage message, Object attributeValueText, int len) {
        AnnotationMsg annotation = new AnnotationMsg(problemId, attributeValueText, len);
        message.setAttribute(ANNOTATIONMSG, (Object)annotation);
        reporter.addMessage((IValidator)this, (IMessage)message);
    }

    private void addAttributeError(String messageText, String attributeValueText, int start, int length, int problemId, IStructuredDocumentRegion sdRegion, IReporter reporter, int messageSeverity) {
        if (sdRegion.isDeleted()) {
            return;
        }
        int lineNo = this.getLineNumber(start);
        LocalizedMessage message = new LocalizedMessage(messageSeverity, messageText);
        message.setOffset(start);
        message.setLength(length);
        message.setLineNo(lineNo);
        this.getAnnotationMsg(reporter, problemId, message, attributeValueText, length);
    }

    private void checkAttributesInEndTag(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        int errorCount = 0;
        int start = structuredDocumentRegion.getEndOffset();
        int end = structuredDocumentRegion.getEndOffset();
        int i = 0;
        while (i < textRegions.size() && errorCount < 25 && !structuredDocumentRegion.isDeleted()) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || textRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS" || textRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                if (start > structuredDocumentRegion.getStartOffset(textRegion)) {
                    start = structuredDocumentRegion.getStartOffset(textRegion);
                }
                end = structuredDocumentRegion.getEndOffset(textRegion);
                ++errorCount;
            }
            ++i;
        }
        if (errorCount > 0) {
            String messageText = XMLCoreMessages.End_tag_has_attributes;
            LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("endTagWithAttributes"), messageText);
            message.setOffset(start);
            message.setLength(end - start);
            message.setLineNo(this.getLineNumber(start));
            this.getAnnotationMsg(reporter, 3, message, null, end - start);
        }
    }

    private void checkClosingBracket(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        boolean closed = false;
        int i = 0;
        while (i < regions.size() && !structuredDocumentRegion.isDeleted()) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_CLOSE" || r.getType() == "XML_EMPTY_TAG_CLOSE") {
                closed = true;
            }
            ++i;
        }
        if (!closed) {
            String messageText = XMLCoreMessages.ReconcileStepForMarkup_6;
            int start = structuredDocumentRegion.getStartOffset();
            int length = structuredDocumentRegion.getText().trim().length();
            int lineNo = this.getLineNumber(start);
            LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("missingClosingBracket"), messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(lineNo);
            this.getAnnotationMsg(reporter, 14, message, null, length);
        }
    }

    private void checkEmptyTag(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        if (regions.size() == 2 && regions.get(0).getType() == "XML_TAG_OPEN" && regions.get(1).getType() == "XML_TAG_CLOSE") {
            String messageText = XMLCoreMessages.ReconcileStepForMarkup_3;
            int start = structuredDocumentRegion.getStartOffset();
            int length = structuredDocumentRegion.getLength();
            int lineNo = this.getLineNumber(start);
            LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("missingTagName"), messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(lineNo);
            this.getAnnotationMsg(reporter, 1, message, null, length);
        }
    }

    private int getLineNumber(int start) {
        int lineNo = -1;
        try {
            lineNo = this.getDocument().getLineOfOffset(start) + 1;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return lineNo;
    }

    private void checkForAttributeValue(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        int attrState = 0;
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        int errorCount = 0;
        int i = 0;
        while (i < textRegions.size() && errorCount < 25) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || this.isTagCloseTextRegion(textRegion)) {
                ITextRegion previousRegion;
                int lineNo;
                int start;
                String messageText;
                Object[] args;
                if (attrState == 2 && i >= 2) {
                    ITextRegion nameRegion = textRegions.get(i - 2);
                    if (!(nameRegion instanceof ITextRegionContainer)) {
                        args = new Object[]{structuredDocumentRegion.getText(nameRegion)};
                        messageText = NLS.bind((String)XMLCoreMessages.Attribute__is_missing_a_value, (Object[])args);
                        start = structuredDocumentRegion.getStartOffset(nameRegion);
                        int end = structuredDocumentRegion.getEndOffset();
                        lineNo = this.getLineNumber(start);
                        int textLength = structuredDocumentRegion.getText(nameRegion).trim().length();
                        LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("attributeHasNoValue"), messageText);
                        message.setOffset(start);
                        message.setLength(textLength);
                        message.setLineNo(lineNo);
                        ITextRegion equalsRegion = textRegions.get(i - 2 + 1);
                        int insertOffset = structuredDocumentRegion.getTextEndOffset(equalsRegion) - end;
                        Object[] additionalFixInfo = new Object[]{structuredDocumentRegion.getText(nameRegion), new Integer(insertOffset)};
                        this.getAnnotationMsg(reporter, 4, message, additionalFixInfo, textLength);
                        ++errorCount;
                    }
                } else if (attrState == 1 && i >= 1 && !((previousRegion = textRegions.get(i - 1)) instanceof ITextRegionContainer)) {
                    args = new Object[]{structuredDocumentRegion.getText(previousRegion)};
                    messageText = NLS.bind((String)XMLCoreMessages.Attribute__has_no_value, (Object[])args);
                    start = structuredDocumentRegion.getStartOffset(previousRegion);
                    int textLength = structuredDocumentRegion.getText(previousRegion).trim().length();
                    lineNo = this.getLineNumber(start);
                    LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("attributeHasNoValue"), messageText);
                    message.setOffset(start);
                    message.setLength(textLength);
                    message.setLineNo(lineNo);
                    this.getAnnotationMsg(reporter, 5, message, structuredDocumentRegion.getText(previousRegion), textLength);
                    ++errorCount;
                }
                attrState = 1;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS") {
                attrState = 2;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrState = 0;
            }
            ++i;
        }
    }

    private void checkForSpaceBeforeName(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        IStructuredDocumentRegion prev;
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        String sdRegionText = structuredDocumentRegion.getFullText();
        if (sdRegionText.startsWith(" ") && (prev = structuredDocumentRegion.getPrevious()) != null && prev.getRegions().size() == 1 && this.isStartTag(prev)) {
            String messageText = XMLCoreMessages.ReconcileStepForMarkup_2;
            int start = structuredDocumentRegion.getStartOffset();
            int length = sdRegionText.trim().equals("") ? sdRegionText.length() : sdRegionText.indexOf(sdRegionText.trim());
            LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("whitespaceBeforeTagName"), messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(this.getLineNumber(start));
            this.getAnnotationMsg(reporter, 6, message, null, length);
        }
    }

    private void checkNoNamespaceInPI(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        int errorCount = 0;
        int i = 0;
        while (i < regions.size() && errorCount < 25 && !structuredDocumentRegion.isDeleted()) {
            String piText;
            int index;
            r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME" && (index = (piText = structuredDocumentRegion.getText(r)).indexOf(":")) != -1) {
                String messageText = XMLCoreMessages.ReconcileStepForMarkup_4;
                int start = structuredDocumentRegion.getStartOffset(r) + index;
                int length = piText.trim().length() - index;
                LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("namespaceInPITarget"), messageText);
                message.setOffset(start);
                message.setLength(length);
                message.setLineNo(this.getLineNumber(start));
                this.getAnnotationMsg(reporter, 8, message, null, length);
                ++errorCount;
            }
            ++i;
        }
    }

    private void checkQuotesForAttributeValues(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        String attrValueText = "";
        int errorCount = 0;
        int i = 0;
        while (i < regions.size() && errorCount < 25) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrValueText = structuredDocumentRegion.getText(r);
                StringTokenizer st = new StringTokenizer(attrValueText, "\"'", true);
                int size = st.countTokens();
                String one = "";
                String two = "";
                if (size > 0) {
                    one = st.nextToken();
                }
                if (size > 1) {
                    two = st.nextToken();
                }
                if (size <= 2) {
                    String message;
                    if (size == 1) {
                        if (one.equals(this.DQUOTE) || one.equals(this.SQUOTE)) {
                            message = XMLCoreMessages.ReconcileStepForMarkup_0;
                            this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, reporter, this.getPluginPreference().getInt("missingClosingQuote"));
                            ++errorCount;
                        } else {
                            message = XMLCoreMessages.ReconcileStepForMarkup_1;
                            this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 13, structuredDocumentRegion, reporter, this.getPluginPreference().getInt("missingClosingQuote"));
                            ++errorCount;
                        }
                    } else if (size == 2 && (one.equals(this.SQUOTE) && !two.equals(this.SQUOTE) || one.equals(this.DQUOTE) && !two.equals(this.DQUOTE))) {
                        message = XMLCoreMessages.ReconcileStepForMarkup_0;
                        this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, reporter, this.getPluginPreference().getInt("missingClosingQuote"));
                        ++errorCount;
                    }
                }
            }
            ++i;
        }
    }

    private void checkStartEndTagPairs(IStructuredDocumentRegion sdRegion, IReporter reporter) {
        if (sdRegion.isDeleted()) {
            return;
        }
        IDOMNode xmlNode = this.getXMLNode(sdRegion);
        if (xmlNode == null) {
            return;
        }
        boolean selfClosed = false;
        String tagName = null;
        if (xmlNode.isContainer()) {
            IStructuredDocumentRegion endRegion = xmlNode.getEndStructuredDocumentRegion();
            if (endRegion == null) {
                IStructuredDocumentRegion startRegion = xmlNode.getStartStructuredDocumentRegion();
                if (startRegion != null && !startRegion.isDeleted() && "XML_TAG_OPEN".equals(startRegion.getFirstRegion().getType())) {
                    ITextRegionList regions = startRegion.getRegions();
                    ITextRegion r = null;
                    int start = sdRegion.getStart();
                    int length = sdRegion.getTextLength();
                    int i = 0;
                    while (i < regions.size()) {
                        r = regions.get(i);
                        if (r.getType() == "XML_TAG_NAME") {
                            tagName = sdRegion.getText(r);
                            start = sdRegion.getStartOffset(r);
                            length = r.getTextLength();
                        } else if (r.getType() == "XML_EMPTY_TAG_CLOSE") {
                            selfClosed = true;
                        }
                        ++i;
                    }
                    if (!selfClosed && tagName != null) {
                        Object[] args = new Object[]{tagName};
                        String messageText = NLS.bind((String)XMLCoreMessages.Missing_end_tag_, (Object[])args);
                        int lineNumber = this.getLineNumber(start);
                        LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("missingEndTag"), messageText);
                        message.setOffset(start);
                        message.setLength(length);
                        message.setLineNo(lineNumber);
                        Object[] additionalFixInfo = this.getStartEndFixInfo(xmlNode, tagName, r);
                        this.getAnnotationMsg(reporter, 2, message, additionalFixInfo, length);
                    }
                }
            } else {
                IStructuredDocumentRegion startRegion = xmlNode.getStartStructuredDocumentRegion();
                if (startRegion == null || startRegion.isDeleted()) {
                    ITextRegionList regions = endRegion.getRegions();
                    ITextRegion r = null;
                    int start = sdRegion.getStart();
                    int length = sdRegion.getTextLength();
                    int i = 0;
                    while (i < regions.size()) {
                        r = regions.get(i);
                        if (r.getType() == "XML_TAG_NAME") {
                            tagName = sdRegion.getText(r);
                            start = sdRegion.getStartOffset(r);
                            length = r.getTextLength();
                        }
                        ++i;
                    }
                    if (tagName != null) {
                        Object[] args = new Object[]{tagName};
                        String messageText = NLS.bind((String)XMLCoreMessages.Missing_start_tag_, (Object[])args);
                        int lineNumber = this.getLineNumber(start);
                        LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("missingStartTag"), messageText);
                        message.setOffset(start);
                        message.setLength(length);
                        message.setLineNo(lineNumber);
                        Object[] additionalFixInfo = this.getStartEndFixInfo(xmlNode, tagName, r);
                        this.getAnnotationMsg(reporter, 15, message, additionalFixInfo, length);
                    }
                }
            }
        } else {
            IStructuredDocumentRegion endRegion;
            IStructuredDocumentRegion startRegion = xmlNode.getStartStructuredDocumentRegion();
            if (startRegion == null && !(endRegion = xmlNode.getEndStructuredDocumentRegion()).isDeleted()) {
                ITextRegionList regions = endRegion.getRegions();
                ITextRegion r = null;
                int i = 0;
                while (i < regions.size()) {
                    r = regions.get(i);
                    if (r.getType() == "XML_TAG_NAME") {
                        tagName = sdRegion.getText(r);
                    }
                    ++i;
                }
                if (!selfClosed && tagName != null) {
                    String messageText = XMLCoreMessages.Indicate_no_grammar_specified_severities_error;
                    int start = sdRegion.getStart();
                    int lineNumber = this.getLineNumber(start);
                    LocalizedMessage message = new LocalizedMessage(1, messageText);
                    message.setOffset(start);
                    message.setLength(sdRegion.getTextLength());
                    message.setLineNo(lineNumber);
                    reporter.addMessage((IValidator)this, (IMessage)message);
                }
            }
        }
    }

    private Object[] getStartEndFixInfo(IDOMNode xmlNode, String tagName, ITextRegion r) {
        String tagClose = "/>";
        int tagCloseOffset = xmlNode.getFirstStructuredDocumentRegion().getEndOffset();
        if (r != null && r.getType() == "XML_TAG_CLOSE") {
            tagClose = "/";
            --tagCloseOffset;
        }
        IDOMNode firstChild = (IDOMNode)xmlNode.getFirstChild();
        while (firstChild != null && firstChild.getNodeType() == 3) {
            firstChild = (IDOMNode)firstChild.getNextSibling();
        }
        int endOffset = xmlNode.getEndOffset();
        int firstChildStartOffset = firstChild == null ? endOffset : firstChild.getStartOffset();
        Object[] additionalFixInfo = new Object[]{tagName, tagClose, new Integer(tagCloseOffset), new Integer(xmlNode.getFirstStructuredDocumentRegion().getEndOffset()), new Integer(firstChildStartOffset), new Integer(endOffset)};
        return additionalFixInfo;
    }

    private void checkStartingSpaceForPI(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        IStructuredDocumentRegion prev = structuredDocumentRegion.getPrevious();
        if (prev != null && prev.getStartOffset() == 0 && prev.getType() == "XML_CONTENT") {
            String messageText = XMLCoreMessages.ReconcileStepForMarkup_5;
            int start = prev.getStartOffset();
            int length = prev.getLength();
            LocalizedMessage message = new LocalizedMessage(this.getPluginPreference().getInt("whitespaceAtStart"), messageText);
            message.setOffset(start);
            message.setLength(length);
            message.setLineNo(this.getLineNumber(start));
            this.getAnnotationMsg(reporter, 7, message, null, length);
        }
    }

    public int getScope() {
        return 1;
    }

    /*
     * Exception decompiling
     */
    private IDOMNode getXMLNode(IStructuredDocumentRegion sdRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 68->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isEndTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_END_TAG_OPEN";
    }

    private boolean isPI(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_PI_OPEN";
    }

    private boolean isStartTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_TAG_OPEN";
    }

    private boolean isTagCloseTextRegion(ITextRegion textRegion) {
        return textRegion.getType() == "XML_TAG_CLOSE" || textRegion.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    private boolean isXMLContent(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_CONTENT";
    }

    private IDocument getDocument() {
        return this.fDocument;
    }

    public void connect(IDocument document) {
        this.fDocument = document;
    }

    public void disconnect(IDocument document) {
        this.fDocument = null;
    }

    public void validate(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
        if (structuredDocumentRegion == null) {
            return;
        }
        if (this.isStartTag(structuredDocumentRegion)) {
            this.checkForAttributeValue(structuredDocumentRegion, reporter);
            this.checkStartEndTagPairs(structuredDocumentRegion, reporter);
            this.checkEmptyTag(structuredDocumentRegion, reporter);
            this.checkQuotesForAttributeValues(structuredDocumentRegion, reporter);
            this.checkClosingBracket(structuredDocumentRegion, reporter);
        } else if (this.isEndTag(structuredDocumentRegion)) {
            this.checkStartEndTagPairs(structuredDocumentRegion, reporter);
            this.checkAttributesInEndTag(structuredDocumentRegion, reporter);
            this.checkClosingBracket(structuredDocumentRegion, reporter);
        } else if (this.isPI(structuredDocumentRegion)) {
            this.checkStartingSpaceForPI(structuredDocumentRegion, reporter);
            this.checkNoNamespaceInPI(structuredDocumentRegion, reporter);
        } else if (this.isXMLContent(structuredDocumentRegion)) {
            this.checkForSpaceBeforeName(structuredDocumentRegion, reporter);
        } else if (this.isXMLDoctypeDeclaration(structuredDocumentRegion)) {
            this.checkDocumentTypeReferences(structuredDocumentRegion, reporter);
        }
    }

    private void checkDocumentTypeReferences(IStructuredDocumentRegion structuredDocumentRegion, IReporter reporter) {
    }

    private boolean isXMLDoctypeDeclaration(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_DECLARATION_OPEN" && structuredDocumentRegion.getType().equals("XML_DOCTYPE_DECLARATION");
    }

    public void cleanup(IReporter reporter) {
        this.fDocument = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                Path path = new Path(uris[i]);
                if (path.segmentCount() > 1) {
                    currentFile = wsRoot.getFile((IPath)path);
                    if (this.shouldValidate((IResource)currentFile, true)) {
                        this.validateV1File(currentFile, reporter);
                    }
                } else if (uris.length == 1) {
                    this.validateV1Project(helper, reporter);
                }
                ++i;
            }
        } else {
            this.validateV1Project(helper, reporter);
        }
    }

    private boolean shouldValidate(IResourceProxy proxy) {
        String name;
        if (proxy.getType() == 1 && (name = proxy.getName()).toLowerCase(Locale.US).endsWith(".xml")) {
            return true;
        }
        return this.shouldValidate(proxy.requestResource(), false);
    }

    private boolean shouldValidate(IResource file, boolean checkExtension) {
        String extension;
        if (file == null || !file.exists() || file.getType() != 1) {
            return false;
        }
        if (checkExtension && (extension = file.getFileExtension()) != null && "xml".endsWith(extension.toLowerCase(Locale.US))) {
            return true;
        }
        IContentDescription contentDescription = null;
        try {
            contentDescription = ((IFile)file).getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                return contentDescription != null && contentType.isKindOf(this.getXMLContentType());
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }

    private void validateV1Project(IValidationContext helper, final IReporter reporter) {
        if (helper instanceof IWorkbenchContext) {
            IProject project = ((IWorkbenchContext)helper).getProject();
            IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (MarkupValidator.this.shouldValidate(proxy)) {
                        MarkupValidator.this.validateV1File((IFile)proxy.requestResource(), reporter);
                    }
                    return true;
                }
            };
            try {
                project.accept(visitor, 2);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void validateV1File(IFile currentFile, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 145->149)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IContentType getXMLContentType() {
        if (this.fRootContentType == null) {
            this.fRootContentType = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
        }
        return this.fRootContentType;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        this.fReporter = result.getReporter(monitor);
        this.validateV1File((IFile)resource, this.fReporter);
        return result;
    }

    public IReporter validate(IResource resource, int kind, ValidationState state) {
        this.validate(resource, kind, state, (IProgressMonitor)new NullProgressMonitor());
        return this.fReporter;
    }

    private Preferences getPluginPreference() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    public void validate(IRegion dirtyRegion, IValidationContext helper, IReporter reporter) {
        if (this.getDocument() == null) {
            return;
        }
        if (!(this.getDocument() instanceof IStructuredDocument)) {
            return;
        }
        reporter.removeAllMessages((IValidator)this);
        IStructuredDocumentRegion[] regions = ((IStructuredDocument)this.fDocument).getStructuredDocumentRegions(dirtyRegion.getOffset(), dirtyRegion.getLength());
        int i = 0;
        while (i < regions.length) {
            this.validate(regions[i], reporter);
            ++i;
        }
    }
}

