/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.osgi.util.NLS;

public class PullOperation
implements IEGitOperation {
    private final Repository[] repositories;
    private Map<Repository, PullReferenceConfig> configs;
    private final Map<Repository, Object> results = new LinkedHashMap<Repository, Object>();
    private final int timeout;
    private CredentialsProvider credentialsProvider;

    public PullOperation(Set<Repository> repositories, int timeout) {
        this.timeout = timeout;
        this.repositories = repositories.toArray(new Repository[repositories.size()]);
        this.configs = Collections.emptyMap();
    }

    public PullOperation(@NonNull Map<Repository, PullReferenceConfig> repositories, int timeout) {
        this(repositories.keySet(), timeout);
        this.configs = repositories;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        if (!this.results.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), CoreText.OperationAlreadyExecuted));
        }
        SubMonitor totalProgress = SubMonitor.convert((IProgressMonitor)m, (String)NLS.bind((String)CoreText.PullOperation_TaskName, (Object)this.repositories.length), (int)1);
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            /*
             * Exception decompiling
             */
            public void run(IProgressMonitor mymonitor) throws CoreException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        ResourcesPlugin.getWorkspace().run(action, this.getSchedulingRule(), 1, (IProgressMonitor)totalProgress);
    }

    static String getPullTaskName(Repository repo, PullReferenceConfig rc) {
        String remoteUri;
        String branchName;
        StoredConfig config = repo.getConfig();
        if (rc != null) {
            String remoteUri2 = config.getString("remote", rc.remote, "url");
            return "Pulling " + rc.remote + " from " + remoteUri2;
        }
        try {
            String fullBranch = repo.getFullBranch();
            branchName = fullBranch != null ? fullBranch.substring("refs/heads/".length()) : "";
        }
        catch (IOException iOException) {
            return "Pulling from " + repo.toString();
        }
        String remote = config.getString("branch", branchName, "remote");
        if (remote == null) {
            remote = "origin";
        }
        if ((remoteUri = config.getString("remote", remote, "url")) != null) {
            return "Pulling " + remote + " from " + remoteUri;
        }
        return "Pulling from " + repo.getDirectory();
    }

    boolean refreshNeeded(PullResult pullResult) {
        if (pullResult == null) {
            return true;
        }
        MergeResult mergeResult = pullResult.getMergeResult();
        if (mergeResult == null) {
            return true;
        }
        return mergeResult.getMergeStatus() != MergeResult.MergeStatus.ALREADY_UP_TO_DATE;
    }

    public Map<Repository, Object> getResults() {
        return this.results;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(Arrays.asList(this.repositories));
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    static /* synthetic */ Repository[] access$0(PullOperation pullOperation) {
        return pullOperation.repositories;
    }

    static /* synthetic */ int access$1(PullOperation pullOperation) {
        return pullOperation.timeout;
    }

    static /* synthetic */ CredentialsProvider access$2(PullOperation pullOperation) {
        return pullOperation.credentialsProvider;
    }

    static /* synthetic */ Map access$3(PullOperation pullOperation) {
        return pullOperation.configs;
    }

    static /* synthetic */ Map access$4(PullOperation pullOperation) {
        return pullOperation.results;
    }

    public static class PullReferenceConfig {
        private String remote;
        private String reference;
        private BranchConfig.BranchRebaseMode upstreamConfig;

        public PullReferenceConfig(@Nullable String remote, @Nullable String reference, @Nullable BranchConfig.BranchRebaseMode upstreamConfig) {
            this.remote = remote;
            this.reference = reference;
            this.upstreamConfig = upstreamConfig;
        }

        @Nullable
        public String getRemote() {
            return this.remote;
        }

        @Nullable
        public String getReference() {
            return this.reference;
        }

        @Nullable
        public BranchConfig.BranchRebaseMode getUpstreamConfig() {
            return this.upstreamConfig;
        }
    }
}

