/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize.dto;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.RevUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitSynchronizeData {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();
    public static final Pattern BRANCH_NAME_PATTERN = Pattern.compile("^refs/heads/.*?");
    private final boolean includeLocal;
    private final Repository repo;
    private final String dstRemote;
    private final String dstMerge;
    private RevCommit srcRevCommit;
    private RevCommit dstRevCommit;
    private RevCommit ancestorRevCommit;
    private final Set<IProject> projects;
    private final String repoParentPath;
    private final String srcRev;
    private final String dstRev;
    private TreeFilter pathFilter;
    private Set<IResource> includedResources;

    public GitSynchronizeData(Repository repository, String srcRev, String dstRev, boolean includeLocal) throws IOException {
        this(repository, srcRev, dstRev, includeLocal, null);
    }

    public GitSynchronizeData(Repository repository, String srcRev, String dstRev, boolean includeLocal, Set<IResource> includedResources) throws IOException {
        Assert.isNotNull((Object)repository);
        Assert.isNotNull((Object)srcRev);
        Assert.isNotNull((Object)dstRev);
        this.repo = repository;
        this.srcRev = srcRev;
        this.dstRev = dstRev;
        this.includeLocal = includeLocal;
        RemoteAndMerge dstRemoteAndMerge = this.extractRemoteAndMergeForDst(dstRev);
        this.dstRemote = dstRemoteAndMerge.remote;
        this.dstMerge = dstRemoteAndMerge.merge;
        this.repoParentPath = this.repo.getDirectory().getParentFile().getAbsolutePath();
        this.projects = new HashSet<IProject>();
        Collection<Object> includedResourceIterable = includedResources == null ? Arrays.asList(ROOT.getProjects()) : includedResources;
        for (IResource res : includedResourceIterable) {
            IProject project = res.getProject();
            RepositoryMapping mapping = RepositoryMapping.getMapping(project);
            if (mapping == null || mapping.getRepository() != this.repo) continue;
            this.projects.add(project);
        }
        if (includedResources != null) {
            this.setIncludedResources(includedResources);
        }
        this.updateRevs();
    }

    public void updateRevs() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ObjectWalk ow = new ObjectWalk(this.repo);){
            ow.setRetainBody(true);
            this.srcRevCommit = this.getCommit(this.srcRev, ow);
            this.dstRevCommit = this.getCommit(this.dstRev, ow);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.ancestorRevCommit = this.dstRevCommit != null && this.srcRevCommit != null ? RevUtils.getCommonAncestor(this.repo, (AnyObjectId)this.srcRevCommit, (AnyObjectId)this.dstRevCommit) : null;
    }

    public Repository getRepository() {
        return this.repo;
    }

    @Deprecated
    public String getSrcRemoteName() {
        return null;
    }

    public String getDstMerge() {
        return this.dstMerge;
    }

    @Deprecated
    public String getSrcMerge() {
        return null;
    }

    public String getDstRemoteName() {
        return this.dstRemote;
    }

    public RevCommit getSrcRevCommit() {
        return this.srcRevCommit;
    }

    public RevCommit getDstRevCommit() {
        return this.dstRevCommit;
    }

    public Set<IProject> getProjects() {
        return Collections.unmodifiableSet(this.projects);
    }

    public boolean contains(File file) {
        return file.getAbsoluteFile().toString().startsWith(this.repoParentPath);
    }

    public boolean shouldIncludeLocal() {
        return this.includeLocal;
    }

    public RevCommit getCommonAncestorRev() {
        return this.ancestorRevCommit;
    }

    public void setIncludedResources(Set<IResource> includedResources) {
        this.includedResources = includedResources;
        HashSet<String> paths = new HashSet<String>();
        RepositoryMapping rm = RepositoryMapping.findRepositoryMapping(this.repo);
        if (rm != null) {
            for (IResource resource : includedResources) {
                String repoRelativePath = rm.getRepoRelativePath(resource);
                if (repoRelativePath == null || repoRelativePath.length() <= 0) continue;
                paths.add(repoRelativePath);
            }
        }
        if (!paths.isEmpty()) {
            this.pathFilter = PathFilterGroup.createFromStrings(paths);
        }
    }

    public Set<IResource> getIncludedResources() {
        return this.includedResources;
    }

    public void dispose() {
        if (this.projects != null) {
            this.projects.clear();
        }
        if (this.includedResources != null) {
            this.includedResources.clear();
        }
    }

    public TreeFilter getPathFilter() {
        return this.pathFilter;
    }

    public String getSrcRev() {
        return this.srcRev;
    }

    public String getDstRev() {
        return this.dstRev;
    }

    private RemoteAndMerge extractRemoteAndMergeForDst(String rev) {
        try {
            List remoteConfigs = RemoteConfig.getAllRemoteConfigs((Config)this.repo.getConfig());
            for (RemoteConfig remoteConfig : remoteConfigs) {
                List fetchRefSpecs = remoteConfig.getFetchRefSpecs();
                for (RefSpec fetchRefSpec : fetchRefSpecs) {
                    if (!fetchRefSpec.matchDestination(rev)) continue;
                    RefSpec expanded = fetchRefSpec.expandFromDestination(rev);
                    return new RemoteAndMerge(remoteConfig.getName(), expanded.getSource());
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return new RemoteAndMerge(null, null);
    }

    private RevCommit getCommit(String rev, ObjectWalk ow) throws IOException {
        if (rev.length() > 0) {
            ObjectId id = this.repo.resolve(rev);
            return id != null ? ow.parseCommit((AnyObjectId)id) : null;
        }
        return null;
    }

    private static class RemoteAndMerge {
        final String remote;
        final String merge;

        public RemoteAndMerge(String remote, String merge) {
            this.remote = remote;
            this.merge = merge;
        }
    }
}

