/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.browser.BrowserViewer;

public class TextAction
extends Action {
    protected BrowserViewer browser;
    protected byte type;
    public static final byte CUT = 0;
    public static final byte COPY = 1;
    public static final byte PASTE = 2;

    protected TextAction(BrowserViewer browser, byte type) {
        super(String.valueOf(type) + "!");
        this.browser = browser;
        this.type = type;
    }

    public void copy() {
        Point selection = this.browser.combo.getSelection();
        int length = selection.y - selection.x;
        if (length > 0) {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.browser.clipboard.setContents((Object[])new String[]{this.browser.combo.getText().substring(selection.x, selection.y)}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError sWTError) {
                // empty catch block
            }
        }
    }

    public void cut() {
        Point selection = this.browser.combo.getSelection();
        if (selection.y > selection.x) {
            this.copy();
            this.delete();
        }
    }

    public void delete() {
        Point selection = this.browser.combo.getSelection();
        String text = this.browser.combo.getText();
        if (selection.x != selection.y) {
            text = String.valueOf(text.substring(0, selection.x)) + text.substring(selection.y);
            this.browser.combo.setText(text);
            this.browser.combo.setSelection(new Point(selection.x, selection.x));
        }
    }

    public void paste() {
        TextTransfer transfer = TextTransfer.getInstance();
        Point selection = this.browser.combo.getSelection();
        String text = this.browser.combo.getText();
        String newText = (String)this.browser.clipboard.getContents((Transfer)transfer);
        if (newText != null && newText.length() > 0) {
            text = String.valueOf(text.substring(0, selection.x)) + newText + text.substring(selection.y);
            this.browser.combo.setText(text);
            int x = selection.x + newText.length();
            this.browser.combo.setSelection(new Point(x, x));
        }
    }

    public void run() {
        if (this.browser == null || this.browser.combo == null) {
            return;
        }
        if (this.type == 0) {
            this.cut();
        } else if (this.type == 1) {
            this.copy();
        } else if (this.type == 2) {
            this.paste();
        }
    }
}

