#!/bin/bash

getEmbeddedJDKPath() {
    DONE=false
    until $DONE; do
    read line || DONE=true
    
    # reading each line
    if [[ $line == TIZEN_SDK_INSTALLED_PATH* ]]; then 
        sdkPath="$(cut -d'=' -f2 <<<$line)";
    fi
    if [[ $line == TIZEN_SDK_DATA_PATH* ]]; then 
        sdkDataPath="$(cut -d'=' -f2 <<<$line)"
    fi
    if [[ $line == JDK_PATH* ]]; then 
        sdkInfoJDKPath="$(cut -d'=' -f2 <<<$line)"
    fi
    
    done < "$1"
}

createlogFile(){
    date_time=$(date +"%Y%m%d%H%M%S")
    fileName="ideLaunch_$date_time.txt"
    if [ ! -d "${sdkDataPath}/ide/logs" ]; then
        mkdir -p "${sdkDataPath}/ide/logs"
    fi
    logFilePath="$sdkDataPath/ide/logs/$fileName"
    touch "$logFilePath"
    logFile="$logFilePath"
}

setJavaExecPath(){
    # extract the sdkPath, sdkDataPath, sdkInfoJDKPath
    getEmbeddedJDKPath $sdkInfoPath
    logMessage=""
    # update JAVA_EXEC if JDK_PATH specified(and exists) in sdk.info 
    if [ -d "$sdkInfoJDKPath" ]; then
        # jdk directory exixts
        JDK_PATH="$sdkInfoJDKPath"
        logMessage="${logMessage}Using Sdk.info java at ${JDK_PATH}"$'\n'
    elif [[ "$sdkInfoJDKPath" != "" ]]; then 
        logMessage="${logMessage}Jdk specified in sdk.info:${sdkInfoJDKPath} does not exist."$'\n'
    fi


    if [ ! -d "$JDK_PATH" ]; then 
        JAVA_EXEC="java"
        logMessage="${logMessage}Using System java"$'\n'
    else
        UNAME=$(uname)
        case "$UNAME" in
        Linux)
                JAVA_EXEC="$JDK_PATH/bin/java"
            ;;
        Darwin)
                JAVA_EXEC="$JDK_PATH/Contents/Home/bin/java"
            ;;
        esac
    fi

    if [[ ${logMessage} != ""  ]]; then 
        # make the log file
        createlogFile
        echo "${logMessage}">>${logFile}
    fi
}

updateIniFile(){
    case "$UNAME" in
        Linux)
            sed -i "/-vm$/{N;P;s|.*\n||;s|.*|$JAVA_EXEC|;}" $iniPath
            ;;
        Darwin)
            sed -i "" "/-vm$/{N;P;s|.*\n||;s|.*|$JAVA_EXEC|;}" $iniPath
            ;;
    esac
}


start_path=`pwd`

simplename="${0##*/}"
if [ "${simplename}" = "$0" ]
then
  realpath="${PWD}/$0"
else
  realpath=$(cd "${0%/*}" && echo "$PWD")
fi

# set IDE path
IDE_PATH=${realpath}

## set no_proxy environment
if [ "x${no_proxy}" = "x" ]
then
    export no_proxy="127.0.0.1"
else
    export no_proxy="${no_proxy},127.0.0.1"
fi

## Execute IDE
eclipse_options="-Dorg.eclipse.swt.browser.DefaultType=MOZILLA"

eclipse_options="${eclipse_options} $@"

cd "${IDE_PATH}"

if [ -e "${IDE_PATH}/init" ]
then
    eclipse_options="-clean ${eclipse_options}"
fi

if [ -e /etc/os-release ]
then
    id=`cat /etc/os-release | grep "^ID=" | sed "s/^ID=//g"`
    version=`cat /etc/os-release | grep "^VERSION_ID=" | sed "s/^VERSION_ID=//g" | sed "s/\"//g"`
elif [ -e /etc/issue ]
then
    id=`cat /etc/issue | awk '{print $1}' | tr [A-Z] [a-z]`
    ubuntu_version=`cat /etc/issue | awk '{print $2}'`
    version=`expr substr $ubuntu_version 1 5`
fi

#set JAVA_EXEC : relative path to embedded jdk
#read the contents of sdk.info to get the jdk path
UNAME=$(uname)
case "$UNAME" in
    Linux)
        JDK_PATH="${IDE_PATH}/../jdk"
        sdkInfoPath="${IDE_PATH}/../sdk.info"
        iniPath="${IDE_PATH}/eclipse.ini"
        ;;
    Darwin)
        JDK_PATH="${IDE_PATH}/../../../jdk"
        sdkInfoPath="${IDE_PATH}/../../../sdk.info"
        iniPath="${IDE_PATH}/../Eclipse/eclipse.ini"
        ;;
esac

setJavaExecPath
if [ "${JAVA_EXEC}" != "" ]; then
    #edit the ini script to include the -vm args
    updateIniFile "$iniPath"
fi

if [ "${id}" = "ubuntu" ]
then
    case "${version}" in
        11.04|11.10|12.04|12.10|13.04|13.10|14.04|16.04)
            UBUNTU_MENUPROXY=0 LIBOVERLAY_SCROLLBAR=0 "${IDE_PATH}/eclipse" ${eclipse_options} 
            ;;
        *)
            "${IDE_PATH}/eclipse" ${eclipse_options} 
    esac
else
    "${IDE_PATH}/eclipse" ${eclipse_options} 
fi

cd "${start_path}"