#!/bin/bash -x
## User Define for desktop menu
desktopfile="${HOME}/.local/share/applications/tizen-studio-ide.desktop"
iconfile=icon.xpm
ide_path=ide
exefile="TizenStudio.sh"
comment="Tizen Studio"
name="Tizen Studio"

## Do not modify the followings (Make desktop menu)
TIZEN_SDK_INSTALL_PATH="${INSTALLED_PATH}"
exepath="$TIZEN_SDK_INSTALL_PATH/${ide_path}/$exefile"
ide_resources_path="${TIZEN_SDK_INSTALL_PATH}/${ide_path}/resources"
ide_fonts_path="${ide_resources_path}/fonts"
categoryfile="${MENU_DIRECTORY_PATH}"

chmod 755 "${exepath}"

## Register start menu
if [ -e "${MAKESHORTCUT_PATH}" ]
then
    "${MAKESHORTCUT_PATH}" -f "${desktopfile}" -e "${exepath}" -i "${TIZEN_SDK_INSTALL_PATH}/${ide_path}/${iconfile}" -n "${name}" -c "${comment}"
	echo "StartupWMClass=Tizen Studio">> "${desktopfile}"
fi

touch "${TIZEN_SDK_INSTALL_PATH}/${ide_path}/init"


#Set sdk version
modify_ide_version()
{
    echo "Modify ide version..."
    tizen_sdk_version=`cat "${INSTALLED_PATH}/sdk.version" | grep 'TIZEN_SDK_VERSION' | sed -e "s;.*TIZEN_SDK_VERSION=\(.*\);\1;g"`
    product_version="${tizen_sdk_version}"

    ide_path="${INSTALLED_PATH}/ide"
    config_file_path="${ide_path}/configuration/config.ini"
    branding_plugin=`ls "${ide_path}/plugins" | grep --color=none org.tizen.product.plugin_`
    about_mapping_path="${ide_path}/plugins/${branding_plugin}/about.mappings"
    about_version_parameter="1"

    echo "Set product's version (${product_version})"

    if [ -e "${config_file_path}" ]
    then
        sed -e "s;\(^eclipse.buildId=\).*;\1${product_version};g" < "${config_file_path}" > "${config_file_path}.mod"
        mv "${config_file_path}.mod" "${config_file_path}"
    fi

    if [ -e "${about_mapping_path}" ]
    then
        sed -e "s;\(^${about_version_parameter}=\).*;\1${product_version};g" < "${about_mapping_path}" > "${about_mapping_path}.mod"
        mv "${about_mapping_path}.mod" "${about_mapping_path}"
    fi
}
modify_ide_version

exit 0
