/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;

public class EditorAreaDropAdapter
extends DropTargetAdapter {
    private IWorkbenchWindow window;

    public EditorAreaDropAdapter(IWorkbenchWindow window) {
        this.window = window;
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
        event.feedback = 0;
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
        event.feedback = 0;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        event.detail = 1;
        event.feedback = 0;
    }

    public void drop(DropTargetEvent event) {
        Display d = this.window.getShell().getDisplay();
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null) {
            d.asyncExec(() -> this.asyncDrop(event, page));
        }
    }

    private void asyncDrop(DropTargetEvent event, IWorkbenchPage page) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (!EditorInputTransfer.getInstance().isSupportedType(event.currentDataType)) break block7;
                        Assert.isTrue((boolean)(event.data instanceof EditorInputTransfer.EditorInputData[]));
                        EditorInputTransfer.EditorInputData[] editorInputDataArray = (EditorInputTransfer.EditorInputData[])event.data;
                        int n = editorInputDataArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            EditorInputTransfer.EditorInputData editorInputData = editorInputDataArray[n2];
                            IEditorInput editorInput = editorInputData.input;
                            String editorId = editorInputData.editorId;
                            this.openNonExternalEditor(page, editorInput, editorId);
                            ++n2;
                        }
                        break block8;
                    }
                    if (!MarkerTransfer.getInstance().isSupportedType(event.currentDataType)) break block9;
                    Assert.isTrue((boolean)(event.data instanceof IMarker[]));
                    IMarker[] iMarkerArray = (IMarker[])event.data;
                    int n = iMarkerArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IMarker marker = iMarkerArray[n3];
                        this.openNonExternalEditor(page, marker);
                        ++n3;
                    }
                    break block8;
                }
                if (!ResourceTransfer.getInstance().isSupportedType(event.currentDataType)) break block10;
                Assert.isTrue((boolean)(event.data instanceof IResource[]));
                IResource[] iResourceArray = (IResource[])event.data;
                int n = iResourceArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IFile file;
                    IResource resource = iResourceArray[n4];
                    if (resource instanceof IFile && !(file = (IFile)resource).isPhantom()) {
                        this.openNonExternalEditor(page, file);
                    }
                    ++n4;
                }
                break block8;
            }
            if (!FileTransfer.getInstance().isSupportedType(event.currentDataType)) break block8;
            Assert.isTrue((boolean)(event.data instanceof String[]));
            String[] stringArray = (String[])event.data;
            int n = stringArray.length;
            int n5 = 0;
            while (n5 < n) {
                String path = stringArray[n5];
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(path));
                try {
                    IDE.openEditorOnFileStore(page, fileStore);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
                ++n5;
            }
        }
    }

    private IEditorPart openNonExternalEditor(IWorkbenchPage page, IFile file) {
        IEditorPart result;
        try {
            IEditorDescriptor defaultEditorDesc = IDE.getDefaultEditor(file);
            if (defaultEditorDesc != null && !defaultEditorDesc.isOpenExternal()) {
                result = IDE.openEditor(page, file, true);
            } else {
                IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor editorDesc = null;
                if (editorReg.isSystemInPlaceEditorAvailable(file.getName())) {
                    editorDesc = editorReg.findEditor("org.eclipse.ui.systemInPlaceEditor");
                }
                if (editorDesc == null) {
                    editorDesc = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor");
                }
                if (editorDesc == null) {
                    throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
                }
                result = page.openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId(), true);
            }
        }
        catch (PartInitException e) {
            result = null;
        }
        return result;
    }

    private IEditorPart openNonExternalEditor(IWorkbenchPage page, IMarker marker) {
        IEditorPart result;
        block7: {
            if (marker.getResource() instanceof IFile) break block7;
            return null;
        }
        try {
            IFile file = (IFile)marker.getResource();
            IEditorDescriptor editorDesc = null;
            try {
                String editorID = (String)marker.getAttribute("org.eclipse.ui.editorID");
                if (editorID != null) {
                    IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
                    editorDesc = editorReg.findEditor(editorID);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if ((result = editorDesc != null && !editorDesc.isOpenExternal() ? page.openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId(), true) : this.openNonExternalEditor(page, file)) != null) {
                IDE.gotoMarker(result, marker);
            }
        }
        catch (PartInitException e) {
            result = null;
        }
        return result;
    }

    private IEditorPart openNonExternalEditor(IWorkbenchPage page, IEditorInput editorInput, String editorId) {
        IEditorPart result;
        try {
            IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor editorDesc = editorReg.findEditor(editorId);
            result = editorDesc != null && !editorDesc.isOpenExternal() ? page.openEditor(editorInput, editorId) : null;
        }
        catch (PartInitException e) {
            result = null;
        }
        return result;
    }
}

