/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerPriorityField
extends MarkerField {
    static final String HIGH_PRIORITY_IMAGE_PATH = "$nl$/icons/full/tobj16/hprio_tsk.png";
    static final String LOW_PRIORITY_IMAGE_PATH = "$nl$/icons/full/obj16/lprio_tsk.png";
    private static String[] priorities = new String[]{MarkerMessages.priority_low, MarkerMessages.priority_normal, MarkerMessages.priority_high};

    @Override
    public int compare(MarkerItem item1, MarkerItem item2) {
        return item2.getAttributeValue("priority", 1) - item1.getAttributeValue("priority", 1);
    }

    @Override
    public String getColumnHeaderText() {
        return "";
    }

    @Override
    public String getColumnTooltipText() {
        return this.getName();
    }

    @Override
    public int getDefaultColumnWidth(Control control) {
        return this.getHighPriorityImage().getBounds().width;
    }

    @Override
    public EditingSupport getEditingSupport(ColumnViewer viewer) {
        return new PriorityEditingSupport(viewer);
    }

    private Image getHighPriorityImage() {
        return MarkerSupportInternalUtilities.createImage(HIGH_PRIORITY_IMAGE_PATH, this.getImageManager());
    }

    @Override
    public String getValue(MarkerItem item) {
        return "";
    }

    @Override
    public void update(ViewerCell cell) {
        super.update(cell);
        try {
            switch (((MarkerItem)cell.getElement()).getAttributeValue("priority", 1)) {
                case 2: {
                    cell.setImage(this.getHighPriorityImage());
                    break;
                }
                case 1: {
                    cell.setImage(null);
                    break;
                }
                case 0: {
                    cell.setImage(MarkerSupportInternalUtilities.createImage(LOW_PRIORITY_IMAGE_PATH, this.getImageManager()));
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    private class PriorityEditingSupport
    extends EditingSupport {
        private ComboBoxCellEditor editor;

        public PriorityEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new ComboBoxCellEditor((Composite)viewer.getControl(), priorities, 8);
        }

        protected boolean canEdit(Object element) {
            if (element instanceof MarkerEntry) {
                return ((MarkerEntry)element).getAttributeValue("userEditable", false);
            }
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            return ((MarkerEntry)element).getAttributeValue("priority", 1);
        }

        protected void setValue(Object element, Object value) {
            MarkerEntry entry = (MarkerEntry)element;
            Integer integerValue = (Integer)value;
            try {
                entry.getMarker().setAttribute("priority", integerValue.intValue());
            }
            catch (CoreException e) {
                Policy.handle(e);
            }
        }
    }
}

