/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ResourceTransfer
extends ByteArrayTransfer {
    private static final int MAX_RESOURCES_TO_TRANSFER = 1000000;
    private static final ResourceTransfer instance = new ResourceTransfer();
    private static final String TYPE_NAME = "resource-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = ResourceTransfer.registerType((String)TYPE_NAME);
    private IWorkspace workspace = ResourcesPlugin.getWorkspace();

    private ResourceTransfer() {
    }

    public static ResourceTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IResource[])) {
            return;
        }
        IResource[] resources = (IResource[])data;
        int resourceCount = resources.length;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(resourceCount);
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                this.writeResource(dataOut, resource);
                ++n2;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        int count;
        DataInputStream in;
        block6: {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes == null) {
                return null;
            }
            in = new DataInputStream(new ByteArrayInputStream(bytes));
            count = in.readInt();
            if (count <= 1000000) break block6;
            String message = "Transfer aborted, too many resources: " + count + ".";
            if (Util.isLinux()) {
                message = String.valueOf(message) + "\nIf you are running in x11vnc environment please consider to switch to vncserver + vncviewer or to run x11vnc without clipboard support (use '-noclipboard' and '-nosetclipboard' arguments).";
            }
            IDEWorkbenchPlugin.log(message, new IllegalArgumentException("Maximum limit of resources to transfer is: 1000000"));
            return null;
        }
        try {
            IResource[] results = new IResource[count];
            int i = 0;
            while (i < count) {
                results[i] = this.readResource(in);
                ++i;
            }
            return results;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IResource readResource(DataInputStream dataIn) throws IOException {
        int type = dataIn.readInt();
        String path = dataIn.readUTF();
        switch (type) {
            case 2: {
                return this.workspace.getRoot().getFolder((IPath)new Path(path));
            }
            case 1: {
                return this.workspace.getRoot().getFile((IPath)new Path(path));
            }
            case 4: {
                return this.workspace.getRoot().getProject(path);
            }
        }
        throw new IllegalArgumentException("Unknown resource type in ResourceTransfer.readResource");
    }

    private void writeResource(DataOutputStream dataOut, IResource resource) throws IOException {
        dataOut.writeInt(resource.getType());
        dataOut.writeUTF(resource.getFullPath().toString());
    }
}

