/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints;

import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.CircularProgress;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.FlatButton;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.FlatRadioButton;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TraceControlModel;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TraceVarDetailsDialog;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TracepointImageRegistry;
import org.eclipse.cdt.dsf.gdb.internal.ui.tracepoints.TracepointsMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class TraceControlView
extends ViewPart
implements IViewPart {
    private static final int ACTION_BUTTON_INDENTATION = 10;
    private static final String EMPTY_STRING = "";
    protected static final int UI_REFRESH_DELAY = 1000;
    protected TraceControlModel fTraceControlModel;
    protected RefreshViewAction fRefreshViewAction;
    protected boolean fAutoRefreshEnabled;
    protected DisconnectedTracingAction fDisconnectedTracingAction;
    protected OpenTraceVarDetailsAction fOpenTraceVarDetails;
    protected ExitVisualizationModeDetailsAction fExitVisualizationAction;
    protected AutoRefreshAction fAutoRefreshAction;
    protected boolean fTraceVisualization;
    protected Job refreshUIJob;
    protected Font cachedBold;
    protected long fLastRefreshTime;
    protected IGDBTraceControl.ITraceStatusDMData2 fLastTraceData;
    protected Composite fTopComposite;
    protected Composite fStatusComposite;
    protected Label fStatusLabel;
    protected Label fSecondaryStatusLabel;
    protected Composite fSecondaryStatusComposite;
    protected FlatButton fActionButton;
    protected Composite fBufferComposite;
    protected Label fBufferCollectedFramesLabel;
    protected FlatRadioButton fSetCircularBufferButton;
    protected CircularProgress fBufferProgress;
    protected Composite fFrameComposite;
    protected Label fFrameLabel;
    protected Label fFrameNumberLabel;
    protected Slider fFrameSlider;
    protected Composite fNotesComposite;
    protected Label fNotesContentLabel;
    protected Text fNotesContentText;
    protected Button fSetNotesButton;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.fTraceControlModel = new TraceControlModel(this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
    }

    public void createPartControl(Composite parent) {
        this.createActions();
        this.fTopComposite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        this.fTopComposite.setLayout((Layout)topLayout);
        this.fTopComposite.setBackground(parent.getDisplay().getSystemColor(1));
        this.createStatusLine(this.fTopComposite);
        this.setSecondaryStatusLineVisible(false, null);
        this.createBufferLine(this.fTopComposite);
        this.setBufferLineVisible(false, null, false);
        this.createFrameLine(this.fTopComposite);
        this.setFrameLineVisible(false, null);
        this.fTraceControlModel.init();
    }

    protected void createStatusLine(Composite parent) {
        this.fStatusComposite = new Composite(parent, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        gd.minimumHeight = 22;
        this.fStatusComposite.setLayoutData((Object)gd);
        GridLayout l = new GridLayout(2, false);
        l.marginBottom = 0;
        this.fStatusComposite.setLayout((Layout)l);
        this.fStatusComposite.setBackgroundMode(2);
        this.fStatusLabel = new Label(this.fStatusComposite, 0);
        if (this.cachedBold == null) {
            FontData fontData = this.fStatusLabel.getFont().getFontData()[0];
            fontData.setStyle(1);
            this.cachedBold = new Font((Device)this.fStatusLabel.getDisplay(), fontData);
        }
        this.fStatusLabel.setFont(this.cachedBold);
        GridData d = new GridData(16384, 0x1000000, false, false);
        this.fStatusLabel.setLayoutData((Object)d);
        this.fStatusLabel.setText(TracepointsMessages.TraceControlView_trace_status_no_debug_session);
        this.fStatusLabel.setBackground(parent.getBackground());
        this.fActionButton = new FlatButton(this.fStatusComposite, 0);
        this.fActionButton.setText(EMPTY_STRING);
        GridData acGd = new GridData(16384, 0x1000000, false, false);
        acGd.horizontalIndent = 10;
        this.fActionButton.setLayoutData(acGd);
        this.fActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)TraceControlView.this.getSite().getService(IHandlerService.class);
                if (handlerService == null) {
                    GdbUIPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", "Missing command handler service"));
                    return;
                }
                try {
                    String text = ((FlatButton)((Object)e.getSource())).getText();
                    if (TracepointsMessages.TraceControlView_action_start.equals(text) || TracepointsMessages.TraceControlView_action_restart.equals(text)) {
                        handlerService.executeCommand("org.eclipse.cdt.debug.ui.command.startTracing", null);
                    } else if (TracepointsMessages.TraceControlView_action_stop.equals(text)) {
                        handlerService.executeCommand("org.eclipse.cdt.debug.ui.command.stopTracing", null);
                    } else if (TracepointsMessages.TraceControlView_action_finish_visualization.equals(text)) {
                        TraceControlView.this.fTraceControlModel.exitVisualizationMode();
                    }
                }
                catch (Exception ex) {
                    GdbUIPlugin.log(ex);
                }
            }
        });
        this.fSecondaryStatusLabel = new Label(this.fStatusComposite, 64);
        GridData sslGd = new GridData(4, 128, true, false);
        sslGd.horizontalSpan = 2;
        this.fSecondaryStatusLabel.setLayoutData((Object)sslGd);
        this.fSecondaryStatusLabel.setBackground(parent.getBackground());
        Label separator = new Label(this.fStatusComposite, 258);
        GridData sGd = new GridData(4, 1024, true, false);
        sGd.horizontalSpan = 2;
        separator.setLayoutData((Object)sGd);
    }

    protected void setActionLinkVisible(boolean visible, String text) {
        this.fActionButton.setVisible(visible);
        this.fActionButton.setText(visible ? text : EMPTY_STRING);
        this.fActionButton.redraw();
    }

    private void setSecondaryStatusLineVisible(boolean visible, IGDBTraceControl.ITraceStatusDMData2 tData) {
        this.fSecondaryStatusLabel.setVisible(visible);
        boolean bl = ((GridData)this.fSecondaryStatusLabel.getLayoutData()).exclude = !visible;
        if (visible && tData != null) {
            IGDBTraceControl.STOP_REASON_ENUM stopReason = tData.getStopReason();
            if (stopReason != null) {
                this.fSecondaryStatusLabel.setText(this.getStopMessage(tData));
            } else if (tData.isTracingActive() && tData.getStartTime() != null) {
                String user = EMPTY_STRING;
                String lastRefreshed = EMPTY_STRING;
                if (!this.fAutoRefreshEnabled) {
                    lastRefreshed = TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_trace_status_secondary_refresh_time, (Object)this.formatTimeInterval(this.fLastRefreshTime, System.currentTimeMillis(), true));
                }
                if (tData.getUserName() != null && tData.getUserName().length() > 0) {
                    user = TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_trace_status_secondary_user, (Object)tData.getUserName());
                }
                this.fSecondaryStatusLabel.setText(TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_trace_status_secondary_running, (Object[])new Object[]{this.formatTime(tData.getStartTime()), user, lastRefreshed}));
            } else {
                this.fSecondaryStatusLabel.setText(EMPTY_STRING);
            }
        } else {
            this.fSecondaryStatusLabel.setText(EMPTY_STRING);
        }
    }

    protected void createNotesLine(Composite parent) {
        this.fNotesComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fNotesComposite.setLayout((Layout)layout);
        this.fNotesComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fNotesComposite.setBackgroundMode(2);
        Label separator = new Label(this.fNotesComposite, 514);
        GridData slGd = new GridData(131072, 4, false, true);
        slGd.verticalSpan = 4;
        separator.setLayoutData((Object)slGd);
        separator.setBackground(this.fNotesComposite.getBackground());
        Label fNotesLabel = new Label(this.fNotesComposite, 0);
        fNotesLabel.setBackground(parent.getBackground());
        fNotesLabel.setText(TracepointsMessages.TraceControlView_trace_notes_label);
        if (this.cachedBold != null) {
            fNotesLabel.setFont(this.cachedBold);
        }
        this.fSetNotesButton = new Button(this.fNotesComposite, 2);
        this.fSetNotesButton.setImage(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Edit_enabled).createImage());
        this.fSetNotesButton.setSelection(false);
        this.fSetNotesButton.setToolTipText(TracepointsMessages.TraceControlView_trace_notes_edit_tooltip);
        this.fSetNotesButton.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
        this.fSetNotesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceControlView.this.handleEditNotesButtonPressed();
            }
        });
        this.fNotesContentLabel = new Label(this.fNotesComposite, 64);
        this.fNotesContentLabel.setBackground(parent.getBackground());
        this.fNotesContentLabel.setText(TracepointsMessages.TraceControlView_trace_notes_not_set);
        GridData nclGd = new GridData(4, 128, true, false);
        nclGd.horizontalSpan = 2;
        this.fNotesContentLabel.setLayoutData((Object)nclGd);
        this.fNotesContentText = new Text(this.fNotesComposite, 2048);
        this.fNotesContentText.setVisible(false);
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = 2;
        gd.exclude = true;
        this.fNotesContentText.setLayoutData((Object)gd);
        this.fNotesContentText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TraceControlView.this.fSetNotesButton.setSelection(false);
                TraceControlView.this.handleEditNotesButtonPressed();
            }
        });
        this.fNotesContentText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    TraceControlView.this.fSetNotesButton.setSelection(false);
                    TraceControlView.this.handleEditNotesButtonPressed(true);
                }
            }
        });
    }

    protected void handleEditNotesButtonPressed() {
        this.handleEditNotesButtonPressed(false);
    }

    protected void handleEditNotesButtonPressed(boolean cancelEditing) {
        boolean isEditMode = this.fSetNotesButton.getSelection();
        this.fNotesContentLabel.setVisible(!isEditMode);
        ((GridData)this.fNotesContentLabel.getLayoutData()).exclude = isEditMode;
        this.fNotesContentText.setVisible(isEditMode);
        ((GridData)this.fNotesContentText.getLayoutData()).exclude = !isEditMode;
        this.fNotesContentText.setFocus();
        if (isEditMode) {
            String txt = this.fNotesContentLabel.getText();
            txt = TracepointsMessages.TraceControlView_trace_notes_not_set.equals(txt) ? EMPTY_STRING : txt;
            this.fNotesContentText.setText(txt);
            this.fSetNotesButton.setToolTipText(TracepointsMessages.TraceControlView_trace_notes_save_tooltip);
        } else {
            this.fSetNotesButton.setToolTipText(TracepointsMessages.TraceControlView_trace_notes_edit_tooltip);
            if (!cancelEditing) {
                this.fNotesContentLabel.setText(this.fNotesContentText.getText());
                this.fNotesContentLabel.getSize();
                this.fTraceControlModel.setTraceNotes(this.fNotesContentText.getText());
            }
        }
        this.fNotesComposite.layout();
        this.fNotesComposite.redraw();
        this.fTraceControlModel.updateContent();
    }

    protected void setNotesLineVisible(boolean visible, IGDBTraceControl.ITraceStatusDMData2 tData, boolean readonly) {
        this.fNotesComposite.setVisible(visible);
        boolean bl = ((GridData)this.fNotesComposite.getLayoutData()).exclude = !visible;
        if (visible) {
            if (tData.getNotes() != null && tData.getNotes().length() > 0) {
                this.fNotesContentLabel.setText(this.removeQuotes(tData.getNotes()));
            } else {
                this.fNotesContentLabel.setText(TracepointsMessages.TraceControlView_trace_notes_not_set);
            }
            if (tData != null && tData.getStartTime() != null) {
                this.fSetNotesButton.setEnabled(!readonly);
            }
        }
    }

    protected void createFrameLine(Composite parent) {
        this.fFrameComposite = new Composite(parent, 0);
        GridData fcGd = new GridData(4, 128, true, false);
        fcGd.horizontalSpan = 2;
        this.fFrameComposite.setLayoutData((Object)fcGd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        this.fFrameComposite.setLayout((Layout)layout);
        Label separator = new Label(this.fFrameComposite, 258);
        GridData sepGd = new GridData(4, 0x1000000, true, false);
        sepGd.horizontalSpan = 2;
        sepGd.verticalIndent = 2;
        separator.setLayoutData((Object)sepGd);
        this.fFrameSlider = new Slider(this.fFrameComposite, 2304);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 2;
        this.fFrameSlider.setLayoutData((Object)gd2);
        this.fFrameSlider.setValues(0, 0, 100, 1, 1, 10);
        this.fFrameSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)TraceControlView.this.getSite().getService(IHandlerService.class);
                if (e.detail == 0x1000002) {
                    try {
                        handlerService.executeCommand("org.eclipse.cdt.dsf.gdb.ui.command.selectNextTraceRecord", null);
                    }
                    catch (Exception exception) {}
                } else if (e.detail == 0x1000001) {
                    try {
                        handlerService.executeCommand("org.eclipse.cdt.dsf.gdb.ui.command.selectPreviousTraceRecord", null);
                    }
                    catch (Exception exception) {}
                } else if (e.detail == 1) {
                    TraceControlView.this.fFrameNumberLabel.setText(TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_frame_dragging, (Object)TraceControlView.this.fFrameSlider.getSelection()));
                } else {
                    TraceControlView.this.fTraceControlModel.setCurrentTraceRecord(Integer.toString(TraceControlView.this.fFrameSlider.getSelection()));
                }
            }
        });
        this.fFrameLabel = new Label(this.fFrameComposite, 0);
        this.fFrameLabel.setText(TracepointsMessages.TraceControlView_frame_label);
        this.fFrameLabel.setLayoutData((Object)new GridData());
        this.fFrameNumberLabel = new Label(this.fFrameComposite, 0);
        this.fFrameNumberLabel.setText(TracepointsMessages.TraceControlView_frame_not_looking);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.fFrameNumberLabel.setLayoutData((Object)gd);
    }

    protected void setFrameLineVisible(boolean visible, IGDBTraceControl.ITraceStatusDMData2 traceData) {
        this.fFrameComposite.setVisible(visible);
        boolean bl = ((GridData)this.fFrameComposite.getLayoutData()).exclude = !visible;
        if (visible) {
            this.fFrameSlider.setMinimum(0);
            if (traceData.getNumberOfCollectedFrame() == 0) {
                this.fFrameSlider.setMaximum(1);
            } else {
                this.fFrameSlider.setMaximum(traceData.getNumberOfCollectedFrame());
            }
            int inc = traceData.getNumberOfCollectedFrame() / 20;
            this.fFrameSlider.setPageIncrement(inc <= 1 ? 2 : inc);
            String fl = EMPTY_STRING;
            if (traceData.getCurrentTraceFrameId() != null) {
                fl = String.valueOf(fl) + TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_frame_looking, (Object[])new Object[]{traceData.getCurrentTraceFrameId(), (int)traceData.getTracepointNumberForCurrentTraceFrame()});
                int recId = 0;
                try {
                    recId = Integer.parseInt(traceData.getCurrentTraceFrameId());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.fFrameSlider.setSelection(recId);
            } else {
                fl = String.valueOf(fl) + TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_frame_not_looking, (Object)traceData.getNumberOfCollectedFrame());
                this.fFrameSlider.setSelection(0);
            }
            this.fFrameNumberLabel.setText(fl);
        }
        if (traceData != null && traceData != null) {
            this.fFrameSlider.setEnabled(traceData.getNumberOfCollectedFrame() != 0);
        }
    }

    protected void createBufferLine(Composite parent) {
        this.fBufferComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        this.fBufferComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 128, true, false);
        this.fBufferComposite.setLayoutData((Object)gd);
        this.fBufferComposite.setBackgroundMode(2);
        Label fBufferLabel = new Label(this.fBufferComposite, 0);
        fBufferLabel.setText(TracepointsMessages.TraceControlView_buffer_label);
        if (this.cachedBold != null) {
            fBufferLabel.setFont(this.cachedBold);
        }
        GridData gdBL = new GridData(4, 0x1000000, true, false);
        fBufferLabel.setLayoutData((Object)gdBL);
        fBufferLabel.setBackground(this.fBufferComposite.getBackground());
        this.fBufferProgress = new CircularProgress(this.fBufferComposite, 0);
        GridData bpGd = new GridData(0x1000000, 128, false, false);
        bpGd.verticalSpan = 2;
        this.fBufferProgress.setLayoutData(bpGd);
        this.fSetCircularBufferButton = new FlatRadioButton(this.fBufferComposite, 0);
        this.fSetCircularBufferButton.setText(TracepointsMessages.TraceControlView_buffer_circular_button_label);
        this.fSetCircularBufferButton.setSelection(false);
        this.fSetCircularBufferButton.setEnabled(true);
        this.fSetCircularBufferButton.setToolTipText(TracepointsMessages.TraceControlView_buffer_circular_off_tooltip);
        GridData cbbGd = new GridData(131072, 0x1000000, false, false);
        cbbGd.horizontalIndent = 20;
        this.fSetCircularBufferButton.setLayoutData(cbbGd);
        this.fSetCircularBufferButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TraceControlView.this.fTraceControlModel.setCircularBuffer(TraceControlView.this.fSetCircularBufferButton.getSelection());
                TraceControlView.this.fTraceControlModel.updateContent();
            }
        });
        this.fBufferCollectedFramesLabel = new Label(this.fBufferComposite, 64);
        this.fBufferCollectedFramesLabel.setText(TracepointsMessages.TraceControlView_buffer_label);
        GridData gd3 = new GridData(4, 1024, true, false);
        this.fBufferCollectedFramesLabel.setLayoutData((Object)gd3);
    }

    protected void setBufferLineVisible(boolean visible, IGDBTraceControl.ITraceStatusDMData2 tData, boolean readonly) {
        this.fBufferComposite.setVisible(visible);
        boolean bl = ((GridData)this.fBufferComposite.getLayoutData()).exclude = !visible;
        if (visible && tData != null) {
            if (tData.getStopReason() != null && tData.getStopReason() == IGDBTraceControl.STOP_REASON_ENUM.OVERFLOW) {
                this.fBufferProgress.setProgress(100);
            } else if (tData.getStopReason() != null && tData.isCircularBuffer() && tData.getNumberOfCreatedFrames() > tData.getNumberOfCollectedFrame()) {
                this.fBufferProgress.setProgress(100);
            } else if (tData.isCircularBuffer() && tData.isTracingActive() && tData.getNumberOfCreatedFrames() > tData.getNumberOfCollectedFrame()) {
                int p = tData.getNumberOfCreatedFrames() % tData.getNumberOfCollectedFrame() * 100 / tData.getNumberOfCollectedFrame();
                this.fBufferProgress.setProgress(100 + p);
            } else {
                this.fBufferProgress.setProgress((tData.getTotalBufferSize() - tData.getFreeBufferSize()) * 100 / tData.getTotalBufferSize());
            }
            this.fSetCircularBufferButton.setSelection(tData.isCircularBuffer());
            this.fSetCircularBufferButton.setEnabled(!readonly);
            this.fSetCircularBufferButton.setToolTipText(this.fSetCircularBufferButton.getSelection() ? TracepointsMessages.TraceControlView_buffer_circular_on_tooltip : TracepointsMessages.TraceControlView_buffer_circular_off_tooltip);
            this.fSetCircularBufferButton.redraw();
            this.fSetCircularBufferButton.update();
            this.fBufferCollectedFramesLabel.setText(TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_buffer_frames_collected, (Object)tData.getNumberOfCollectedFrame(), (Object)((tData.getTotalBufferSize() - tData.getFreeBufferSize()) / 1000)));
            this.fBufferProgress.redraw();
            this.fBufferProgress.update();
        }
    }

    protected void createActions() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getActivePage().showActionSet("org.eclipse.cdt.debug.ui.tracepointActionSet");
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        this.fRefreshViewAction = new RefreshViewAction();
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshViewAction);
        manager.add((IAction)this.fRefreshViewAction);
        this.fRefreshViewAction.setEnabled(false);
        this.fAutoRefreshAction = new AutoRefreshAction();
        manager.add((IAction)this.fAutoRefreshAction);
        this.fAutoRefreshAction.setChecked(true);
        this.fAutoRefreshAction.setEnabled(true);
        this.fAutoRefreshEnabled = true;
        this.fLastRefreshTime = System.currentTimeMillis();
        this.fDisconnectedTracingAction = new DisconnectedTracingAction();
        manager.add((IAction)this.fDisconnectedTracingAction);
        this.fDisconnectedTracingAction.setEnabled(false);
        this.fOpenTraceVarDetails = new OpenTraceVarDetailsAction();
        manager.add((IAction)this.fOpenTraceVarDetails);
        this.fExitVisualizationAction = new ExitVisualizationModeDetailsAction();
        manager.add((IAction)this.fExitVisualizationAction);
        bars.updateActionBars();
        this.updateActionEnablement(null);
    }

    public void dispose() {
        this.fTraceControlModel.dispose();
        this.fStatusLabel = null;
        if (this.refreshUIJob != null) {
            this.refreshUIJob.cancel();
        }
        if (this.cachedBold != null) {
            this.cachedBold.dispose();
            this.cachedBold = null;
        }
        super.dispose();
    }

    protected void updateUI(String statusMessage) {
        try {
            this.fLastTraceData = null;
            this.setSecondaryStatusLineVisible(false, null);
            this.setFrameLineVisible(false, null);
            this.setBufferLineVisible(false, null, false);
            this.fStatusLabel.setText(statusMessage);
            this.setActionLinkVisible(false, EMPTY_STRING);
            this.updateActionEnablement(null);
            this.updateLayout();
            this.fDisconnectedTracingAction.setEnabled(false);
        }
        catch (SWTException sWTException) {
            // empty catch block
        }
    }

    protected void updateUI(IGDBTraceControl.ITraceStatusDMData2 traceData) {
        this.fLastTraceData = traceData;
        if (traceData == null) {
            this.updateUI(TracepointsMessages.TraceControlView_trace_status_inactive);
        } else if (!traceData.isTracingSupported()) {
            this.updateUI(TracepointsMessages.TraceControlView_trace_status_not_supported);
        } else if (traceData.isTracingFromFile()) {
            this.fDisconnectedTracingAction.setEnabled(false);
            String s = TracepointsMessages.TraceControlView_trace_status_offline;
            this.fStatusLabel.setText(s);
            this.setActionLinkVisible(false, EMPTY_STRING);
            if (this.getTimeMilliseconds(traceData.getStartTime()) != 0L && this.getTimeMilliseconds(traceData.getStopTime()) != 0L) {
                this.setSecondaryStatusLineVisible(true, traceData);
            } else {
                this.setSecondaryStatusLineVisible(false, traceData);
            }
            this.setBufferLineVisible(true, traceData, true);
            this.setFrameLineVisible(true, traceData);
            this.updateActionEnablement(traceData);
            this.updateLayout();
        } else if (!traceData.isTracingActive() && traceData.getStopReason() == null) {
            this.fDisconnectedTracingAction.setEnabled(true);
            this.fStatusLabel.setText(TracepointsMessages.TraceControlView_trace_status_not_started);
            this.setActionLinkVisible(true, TracepointsMessages.TraceControlView_action_start);
            this.setSecondaryStatusLineVisible(false, null);
            this.setBufferLineVisible(true, traceData, false);
            this.setFrameLineVisible(false, null);
            this.updateActionEnablement(traceData);
            this.updateLayout();
        } else {
            this.fDisconnectedTracingAction.setEnabled(true);
            IGDBTraceControl.STOP_REASON_ENUM fStopReason = traceData.getStopReason();
            if (fStopReason != null) {
                this.setSecondaryStatusLineVisible(true, traceData);
                this.setFrameLineVisible(true, traceData);
                this.setBufferLineVisible(true, traceData, false);
                if (traceData.getCurrentTraceFrameId() != null) {
                    this.fStatusLabel.setText(TracepointsMessages.TraceControlView_trace_status_visualization);
                    this.setActionLinkVisible(true, TracepointsMessages.TraceControlView_action_finish_visualization);
                } else {
                    if (traceData.getNumberOfCollectedFrame() == 0) {
                        this.fStatusLabel.setText(TracepointsMessages.TraceControlView_trace_status_not_started);
                    } else {
                        this.fStatusLabel.setText(TracepointsMessages.TraceControlView_trace_status_stopped);
                    }
                    this.setActionLinkVisible(true, TracepointsMessages.TraceControlView_action_restart);
                }
            } else {
                String s = TracepointsMessages.TraceControlView_trace_status_in_progress;
                this.fStatusLabel.setText(s);
                this.setActionLinkVisible(true, TracepointsMessages.TraceControlView_action_stop);
                this.setSecondaryStatusLineVisible(true, traceData);
                this.setFrameLineVisible(false, traceData);
                this.setBufferLineVisible(true, traceData, true);
                this.startRefreshUIJob();
            }
            this.updateActionEnablement(traceData);
            this.updateLayout();
        }
    }

    protected void startRefreshUIJob() {
        if (this.refreshUIJob == null) {
            this.refreshUIJob = new UIJob("Refresh Trace Control view UI"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (TraceControlView.this.fAutoRefreshEnabled) {
                        TraceControlView.this.fTraceControlModel.updateContent();
                    } else {
                        TraceControlView.this.updateUI(TraceControlView.this.fLastTraceData);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.refreshUIJob.schedule(1000L);
    }

    protected String getStopMessage(IGDBTraceControl.ITraceStatusDMData2 tData) {
        IGDBTraceControl.STOP_REASON_ENUM fStopReason = tData.getStopReason();
        String stopMessage = fStopReason == IGDBTraceControl.STOP_REASON_ENUM.REQUEST ? TracepointsMessages.TraceControlView_tracing_stopped_user_request : (fStopReason == IGDBTraceControl.STOP_REASON_ENUM.PASSCOUNT ? (tData.getStoppingTracepoint() != null ? TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_tracing_stopped_tracepoint_number, (Object)tData.getStoppingTracepoint()) : TracepointsMessages.TraceControlView_tracing_stopped_passcount) : (fStopReason == IGDBTraceControl.STOP_REASON_ENUM.OVERFLOW ? TracepointsMessages.TraceControlView_tracing_stopped_buffer_full : (fStopReason == IGDBTraceControl.STOP_REASON_ENUM.DISCONNECTION ? TracepointsMessages.TraceControlView_tracing_stopped_disconnection : (fStopReason == IGDBTraceControl.STOP_REASON_ENUM.ERROR ? TracepointsMessages.TraceControlView_tracing_stopped_error : TracepointsMessages.TraceControlView_tracing_stopped_unknown))));
        String user = EMPTY_STRING;
        if (tData.getUserName() != null && tData.getUserName().length() > 0) {
            user = TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_trace_status_secondary_user, (Object)tData.getUserName());
        }
        stopMessage = tData.isTracingFromFile() ? TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_trace_status_secondary_offline, (Object[])new Object[]{this.formatTime(tData.getStartTime()), user, this.formatTime(tData.getStopTime()), stopMessage}) : TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_trace_status_secondary_stopped, (Object[])new Object[]{this.formatTimeInterval(tData.getStartTime(), tData.getStopTime()), user, this.formatTime(tData.getStopTime()), stopMessage});
        return stopMessage;
    }

    protected void updateActionEnablement(IGDBTraceControl.ITraceStatusDMData2 traceData) {
        this.fOpenTraceVarDetails.setEnabled(traceData != null && traceData.isTracingSupported());
        this.fExitVisualizationAction.setEnabled(traceData != null && traceData.getCurrentTraceFrameId() != null && !traceData.isTracingFromFile());
        this.fDisconnectedTracingAction.setChecked(traceData != null && traceData.isDisconnectedTracingEnabled());
    }

    public void setFocus() {
        if (this.fStatusLabel != null) {
            this.fStatusLabel.setFocus();
        }
    }

    public void updateLayout() {
        this.fStatusComposite.layout(true);
        this.fTopComposite.layout(true);
    }

    protected long getTimeMilliseconds(String time) {
        long microseconds = 0L;
        try {
            if (time.length() != 0) {
                String[] times = time.split("\\.");
                microseconds += Long.parseLong(times[0]) * 1000000L;
                microseconds += Long.parseLong(times[1]);
            }
        }
        catch (NumberFormatException ex) {
            GdbPlugin.log((Throwable)ex);
        }
        return microseconds / 1000L;
    }

    protected String formatTime(String time) {
        long milliseconds = this.getTimeMilliseconds(time);
        return this.formatTime(milliseconds);
    }

    protected String formatTime(long milliseconds) {
        Date date = new Date(milliseconds);
        long currentTime = System.currentTimeMillis();
        long days = TimeUnit.MILLISECONDS.toDays(currentTime - milliseconds);
        if (days == 0L) {
            return TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_today, (Object)DateFormat.getTimeInstance(3).format(date));
        }
        if (days == 1L) {
            return TracepointsMessages.bind((String)TracepointsMessages.TraceControlView_yesterday, (Object)DateFormat.getTimeInstance(3).format(date));
        }
        return DateFormat.getDateTimeInstance(3, 3).format(date);
    }

    protected String formatTimeInterval(String startTime, String stopTime) {
        long startMicroseconds = 0L;
        long stopMicroseconds = 0L;
        try {
            String[] times;
            if (startTime.length() != 0) {
                times = startTime.split("\\.");
                startMicroseconds += Long.parseLong(times[0]) * 1000000L;
                startMicroseconds += Long.parseLong(times[1]);
            }
            if (stopTime.length() != 0) {
                times = stopTime.split("\\.");
                stopMicroseconds += Long.parseLong(times[0]) * 1000000L;
                stopMicroseconds += Long.parseLong(times[1]);
            }
            return this.formatTimeInterval(startMicroseconds / 1000L, stopMicroseconds / 1000L, true);
        }
        catch (NumberFormatException ex) {
            GdbPlugin.log((Throwable)ex);
            return EMPTY_STRING;
        }
    }

    protected String formatTimeInterval(long startMilliseconds, long stopMilliseconds, boolean shortForm) {
        long millis = stopMilliseconds - startMilliseconds;
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (!shortForm) {
            if (days != 0L) {
                sb.append(days).append(TracepointsMessages.TraceControlView_date_days);
            }
            if (hours != 0L) {
                sb.append(hours).append(TracepointsMessages.TraceControlView_date_hours);
            }
            if (minutes != 0L) {
                sb.append(minutes).append(TracepointsMessages.TraceControlView_date_minutes);
            }
            if (seconds != 0L) {
                sb.append(seconds).append(TracepointsMessages.TraceControlView_date_seconds);
            }
            if (sb.length() == 0) {
                sb.append(TracepointsMessages.TraceControlView_date_zero);
            }
        } else {
            if (days != 0L) {
                sb.append(days).append(TracepointsMessages.TraceControlView_date_short_days);
            }
            if (hours != 0L) {
                sb.append(hours).append(TracepointsMessages.TraceControlView_date_short_hours);
            }
            if (minutes != 0L) {
                sb.append(minutes).append(TracepointsMessages.TraceControlView_date_short_minutes);
            }
            if (seconds != 0L) {
                sb.append(seconds).append(TracepointsMessages.TraceControlView_date_short_seconds);
            }
            if (sb.length() == 0) {
                sb.append(TracepointsMessages.TraceControlView_date_short_zero);
            }
        }
        return sb.toString();
    }

    protected String removeQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    protected final class AutoRefreshAction
    extends Action {
        public AutoRefreshAction() {
            super(TracepointsMessages.TraceControlView_auto_refresh_action_label, 2);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Refresh_Auto));
        }

        public void run() {
            if (this.isChecked()) {
                TraceControlView.this.fAutoRefreshEnabled = true;
                TraceControlView.this.fRefreshViewAction.setEnabled(false);
                TraceControlView.this.fTraceControlModel.updateContent();
            } else {
                TraceControlView.this.fAutoRefreshEnabled = false;
                TraceControlView.this.fRefreshViewAction.setEnabled(true);
            }
        }
    }

    protected final class DisconnectedTracingAction
    extends Action {
        public DisconnectedTracingAction() {
            super(TracepointsMessages.TraceControlView_action_Disconnected_tracing_label, 2);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Disconnected_Tracing));
        }

        public void run() {
            TraceControlView.this.fTraceControlModel.setDisconnectedTracing(this.isChecked());
        }
    }

    protected final class ExitVisualizationModeDetailsAction
    extends Action {
        public ExitVisualizationModeDetailsAction() {
            this.setText(TracepointsMessages.TraceControlView_action_exit_visualization_mode);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Exit_Visualization));
        }

        public void run() {
            TraceControlView.this.fTraceControlModel.exitVisualizationMode();
        }
    }

    public static class FailedTraceVariableCreationException
    extends Exception {
        private static final long serialVersionUID = -3042693455630687285L;

        FailedTraceVariableCreationException() {
        }

        FailedTraceVariableCreationException(String errorMessage) {
            super(errorMessage);
        }
    }

    protected final class OpenTraceVarDetailsAction
    extends Action {
        public OpenTraceVarDetailsAction() {
            this.setText(TracepointsMessages.TraceControlView_action_trace_variable_details);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Trace_Variables));
        }

        public void run() {
            Shell shell = Display.getDefault().getActiveShell();
            TraceVarDetailsDialog dialog = new TraceVarDetailsDialog(shell, TraceControlView.this);
            dialog.open();
        }
    }

    private final class RefreshViewAction
    extends Action {
        public RefreshViewAction() {
            this.setText(TracepointsMessages.TraceControlView_action_Refresh_label);
            this.setImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Refresh_enabled));
            this.setDisabledImageDescriptor(TracepointImageRegistry.getImageDescriptor(TracepointImageRegistry.ICON_Refresh_disabled));
        }

        public void run() {
            TraceControlView.this.fLastRefreshTime = System.currentTimeMillis();
            TraceControlView.this.fTraceControlModel.updateContent();
        }
    }
}

