/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser.browsers;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.eclipse.ui.internal.browser.browsers.StreamConsumer;

public class MozillaBrowser
extends AbstractWebBrowser {
    protected static final int DELAY = 5000;
    protected long browserFullyOpenedAt = 0L;
    private BrowserThread lastBrowserThread = null;
    protected String executable;
    protected boolean firstLaunch = true;
    private String parameters;

    public MozillaBrowser(String id, String executable, String parameters) {
        super(id);
        this.executable = executable;
        this.parameters = parameters == null ? "" : parameters;
    }

    String getExecutable() {
        return this.executable;
    }

    String getParameters() {
        return this.parameters;
    }

    public void openURL(URL url2) {
        String url = null;
        url = url2 != null ? url2.toExternalForm() : "";
        if (this.lastBrowserThread != null) {
            this.lastBrowserThread.exitRequested = true;
        }
        this.lastBrowserThread = new BrowserThread(url);
        this.lastBrowserThread.setDaemon(true);
        this.lastBrowserThread.start();
    }

    private class BrowserThread
    extends Thread {
        public boolean exitRequested = false;
        private String url;

        public BrowserThread(String urlName) {
            this.url = urlName;
        }

        private int openBrowser(String command, String ... parameters) {
            int ret;
            block4: {
                String[] commandArray = new String[parameters.length + 1];
                commandArray[0] = command;
                System.arraycopy(parameters, 0, commandArray, 1, parameters.length);
                Process pr = Runtime.getRuntime().exec(commandArray);
                StreamConsumer outputs = new StreamConsumer(pr.getInputStream());
                outputs.start();
                StreamConsumer errors = new StreamConsumer(pr.getErrorStream());
                errors.start();
                pr.waitFor();
                ret = pr.exitValue();
                if (ret != 0 || !this.errorsInOutput(outputs, errors)) break block4;
                return -1;
            }
            try {
                return ret;
            }
            catch (InterruptedException commandArray) {
            }
            catch (IOException e) {
                WebBrowserUIPlugin.logError("Launching " + MozillaBrowser.this.executable + " has failed.", e);
                return 0;
            }
            return -1;
        }

        private boolean errorsInOutput(StreamConsumer outputs, StreamConsumer errors) {
            block4: {
                outputs.join(1000L);
                if (outputs.getLastLine() == null || outputs.getLastLine().indexOf("No running window found") < 0 && outputs.getLastLine().indexOf("not running on display") < 0) break block4;
                return true;
            }
            try {
                errors.join(1000L);
                if (errors.getLastLine() != null && (errors.getLastLine().indexOf("No running window found") >= 0 || errors.getLastLine().indexOf("not running on display") >= 0)) {
                    return true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public void run() {
            this.waitForBrowser();
            if (this.exitRequested) {
                return;
            }
            if (MozillaBrowser.this.firstLaunch && "win32".equals(Platform.getOS())) {
                if (this.openBrowser(MozillaBrowser.this.executable, WebBrowserUtil.createParameterArray(MozillaBrowser.this.parameters, this.url)) == 0) {
                    return;
                }
                MozillaBrowser.this.browserFullyOpenedAt = System.currentTimeMillis() + 5000L;
                return;
            }
            if (this.openBrowser(MozillaBrowser.this.executable, WebBrowserUtil.createParameterArray(String.valueOf(MozillaBrowser.this.parameters) + " -remote openURL(" + "%URL%" + ")", this.url)) == 0) {
                return;
            }
            if (this.exitRequested) {
                return;
            }
            MozillaBrowser.this.browserFullyOpenedAt = System.currentTimeMillis() + 5000L;
            this.openBrowser(MozillaBrowser.this.executable, WebBrowserUtil.createParameterArray(MozillaBrowser.this.parameters, this.url));
        }

        private void waitForBrowser() {
            while (System.currentTimeMillis() < MozillaBrowser.this.browserFullyOpenedAt) {
                try {
                    if (this.exitRequested) {
                        return;
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

