/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.eval;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptStackFrame;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.Messages;

public class StepIntoSelectionHandler
implements IDebugEventFilter {
    private IFunction function;
    private String signature;
    private IJavaScriptThread thread;
    private String origname;
    private int origdepth;
    private boolean firststep = true;
    private int eventkind = -1;
    private int eventdetail = -1;

    public StepIntoSelectionHandler(IJavaScriptThread thread, IJavaScriptStackFrame frame, IFunction func) {
        this.function = func;
        this.thread = thread;
        try {
            this.origname = frame.getName();
            this.signature = func.getSignature();
        }
        catch (CoreException e) {
            JavaScriptDebugUIPlugin.log(e);
        }
    }

    protected IJavaScriptThread getThread() {
        return this.thread;
    }

    protected IJavaScriptDebugTarget getDebugTarget() {
        return (IJavaScriptDebugTarget)this.getThread().getDebugTarget();
    }

    protected IFunction getMethod() {
        return this.function;
    }

    protected String getSignature() {
        return this.signature;
    }

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        DebugEvent event = null;
        int index = -1;
        int threadEvents = 0;
        int i = 0;
        while (i < events.length) {
            DebugEvent e = events[i];
            if (this.isExpectedEvent(e)) {
                event = e;
                index = i;
                ++threadEvents;
            } else if (e.getSource() == this.getThread()) {
                ++threadEvents;
            }
            ++i;
        }
        if (event == null) {
            return events;
        }
        DebugEvent[] filtered = new DebugEvent[events.length - 1];
        if (filtered.length > 0) {
            int j = 0;
            int i2 = 0;
            while (i2 < events.length) {
                if (i2 != index) {
                    filtered[j] = events[i2];
                    ++j;
                }
                ++i2;
            }
        }
        if (threadEvents > 1) {
            this.cleanup();
            return filtered;
        }
        switch (event.getKind()) {
            case 1: {
                this.setExpectedEvent(2, 8);
                if (this.firststep) {
                    this.firststep = false;
                    return events;
                }
                return filtered;
            }
            case 2: {
                try {
                    final IJavaScriptStackFrame frame = (IJavaScriptStackFrame)this.getThread().getTopStackFrame();
                    int stackDepth = frame.getThread().getStackFrames().length;
                    String name = frame.getName();
                    if (name.equals(this.getMethod().getElementName())) {
                        this.cleanup();
                        return events;
                    }
                    Runnable r = null;
                    if (stackDepth > this.origdepth) {
                        r = new Runnable(){

                            public void run() {
                                try {
                                    StepIntoSelectionHandler.this.setExpectedEvent(1, 4);
                                    frame.stepReturn();
                                }
                                catch (DebugException e) {
                                    JavaScriptDebugUIPlugin.log(e);
                                    StepIntoSelectionHandler.this.cleanup();
                                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)StepIntoSelectionHandler.this.getDebugTarget(), 16)});
                                }
                            }
                        };
                    } else if (stackDepth == this.origdepth) {
                        if (!frame.getName().equals(this.origname)) {
                            this.missed();
                            return events;
                        }
                        r = new Runnable(){

                            public void run() {
                                try {
                                    StepIntoSelectionHandler.this.setExpectedEvent(1, 1);
                                    frame.stepInto();
                                }
                                catch (DebugException e) {
                                    JavaScriptDebugUIPlugin.log(e);
                                    StepIntoSelectionHandler.this.cleanup();
                                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)StepIntoSelectionHandler.this.getDebugTarget(), 16)});
                                }
                            }
                        };
                    } else {
                        this.missed();
                        return events;
                    }
                    DebugPlugin.getDefault().asyncExec(r);
                    return filtered;
                }
                catch (CoreException e) {
                    JavaScriptDebugUIPlugin.log(e);
                    this.cleanup();
                    return events;
                }
            }
        }
        return events;
    }

    protected void missed() {
        this.cleanup();
        Runnable r = new Runnable(){

            public void run() {
                String methodName = null;
                try {
                    methodName = Signature.toString((String)StepIntoSelectionHandler.this.getMethod().getSignature(), (String)StepIntoSelectionHandler.this.getMethod().getElementName(), (String[])StepIntoSelectionHandler.this.getMethod().getParameterNames(), (boolean)false, (boolean)false);
                }
                catch (JavaScriptModelException e) {
                    methodName = StepIntoSelectionHandler.this.getMethod().getElementName();
                }
                new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.step_into_selection, null, NLS.bind((String)Messages.exe_did_not_enter__0__before_returning, (Object[])new String[]{methodName}), 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
            }
        };
        JavaScriptDebugUIPlugin.getStandardDisplay().asyncExec(r);
    }

    public void step() {
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
        try {
            this.origdepth = this.getThread().getStackFrames().length;
            this.setExpectedEvent(1, 1);
            this.getThread().stepInto();
        }
        catch (DebugException e) {
            JavaScriptDebugUIPlugin.log(e);
            this.cleanup();
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this.getDebugTarget(), 16)});
        }
    }

    protected void cleanup() {
        DebugPlugin.getDefault().removeDebugEventFilter((IDebugEventFilter)this);
    }

    private void setExpectedEvent(int kind, int detail) {
        this.eventkind = kind;
        this.eventdetail = detail;
    }

    protected boolean isExpectedEvent(DebugEvent event) {
        return event.getSource().equals(this.getThread()) && event.getKind() == this.eventkind && event.getDetail() == this.eventdetail;
    }
}

