/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.preferences.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.css.ui.internal.CSSUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class CSSSourcePreferencePage
extends AbstractPreferencePage {
    protected Button fAutoPropose;
    protected Label fAutoProposeLabel;
    protected Text fAutoProposeText;
    protected Button fClearAllBlankLines;
    protected Button fIdentLower;
    protected Button fIdentUpper;
    private Spinner fIndentationSize;
    private Button fIndentUsingSpaces;
    private Button fIndentUsingTabs;
    protected Label fLineWidthLabel;
    protected Text fLineWidthText;
    protected Button fNowrapAttr;
    protected Button fPropertyPerLine;
    protected Button fPropNameLower;
    protected Button spaceBetweenSelectors;
    protected Button fPropNameUpper;
    protected Button fPropValueLower;
    protected Button fPropValueUpper;
    protected Button fSelectorUpper;
    protected Button fSelectorLower;
    protected Button fSplitMultiAttrs;
    private final int MAX_INDENTATION_SIZE = 16;
    private final int MIN_INDENTATION_SIZE = 0;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.css.ui.webx0011");
        new PreferenceLinkArea(composite, 66, "org.eclipse.wst.sse.ui.preferences.editor", CSSUIMessages._UI_STRUCTURED_TEXT_EDITOR_PREFS_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null).getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(150, -1).create());
        new Label(composite, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.createContentsForFormattingGroup(composite);
        this.createContentsForContentAssistGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    private void createContentsForContentAssistGroup(Composite parent) {
        Group caseGroup = this.createGroup(parent, 4);
        caseGroup.setText(CSSUIMessages.PrefsLabel_CaseGroup);
        Group identGroup = this.createGroup((Composite)caseGroup, 1);
        identGroup.setText(CSSUIMessages.PrefsLabel_CaseIdent);
        this.fIdentUpper = this.createRadioButton((Composite)identGroup, CSSUIMessages.PrefsLabel_CaseIdentUpper);
        this.fIdentLower = this.createRadioButton((Composite)identGroup, CSSUIMessages.PrefsLabel_CaseIdentLower);
        Group selectorGroup = this.createGroup((Composite)caseGroup, 1);
        selectorGroup.setText(CSSUIMessages.PrefsLabel_SelectorTagName);
        this.fSelectorUpper = this.createRadioButton((Composite)selectorGroup, CSSUIMessages.PrefsLabel_SelectorTagNameUpper);
        this.fSelectorLower = this.createRadioButton((Composite)selectorGroup, CSSUIMessages.PrefsLabel_SelectorTagNameLower);
        Group propNameGroup = this.createGroup((Composite)caseGroup, 1);
        propNameGroup.setText(CSSUIMessages.PrefsLabel_CasePropName);
        this.fPropNameUpper = this.createRadioButton((Composite)propNameGroup, CSSUIMessages.PrefsLabel_CasePropNameUpper);
        this.fPropNameLower = this.createRadioButton((Composite)propNameGroup, CSSUIMessages.PrefsLabel_CasePropNameLower);
        Group propValueGroup = this.createGroup((Composite)caseGroup, 1);
        propValueGroup.setText(CSSUIMessages.PrefsLabel_CasePropValue);
        this.fPropValueUpper = this.createRadioButton((Composite)propValueGroup, CSSUIMessages.PrefsLabel_CasePropValueUpper);
        this.fPropValueLower = this.createRadioButton((Composite)propValueGroup, CSSUIMessages.PrefsLabel_CasePropValueLower);
    }

    private void createContentsForFormattingGroup(Composite parent) {
        Group formattingGroup = this.createGroup(parent, 2);
        formattingGroup.setText(CSSUIMessages.Formatting_UI_);
        this.fLineWidthLabel = this.createLabel((Composite)formattingGroup, CSSUIMessages.Line_width__UI_);
        this.fLineWidthText = new Text((Composite)formattingGroup, 2052);
        GridData gData = new GridData(33);
        gData.widthHint = 25;
        this.fLineWidthText.setLayoutData((Object)gData);
        this.fLineWidthText.addModifyListener((ModifyListener)this);
        this.fPropertyPerLine = this.createCheckBox((Composite)formattingGroup, CSSUIMessages.PrefsLabel_WrappingInsertLineBreak);
        ((GridData)this.fPropertyPerLine.getLayoutData()).horizontalSpan = 2;
        this.spaceBetweenSelectors = this.createCheckBox((Composite)formattingGroup, CSSUIMessages.PrefsLabel_SelectorWhitespace);
        ((GridData)this.spaceBetweenSelectors.getLayoutData()).horizontalSpan = 2;
        this.fNowrapAttr = this.createCheckBox((Composite)formattingGroup, CSSUIMessages.PrefsLabel_WrappingWithoutAttr);
        ((GridData)this.fNowrapAttr.getLayoutData()).horizontalSpan = 2;
        Composite indentComposite = this.createComposite((Composite)formattingGroup, 1);
        ((GridData)indentComposite.getLayoutData()).horizontalSpan = 2;
        ((GridLayout)indentComposite.getLayout()).marginWidth = 0;
        ((GridLayout)indentComposite.getLayout()).marginHeight = 0;
        this.fIndentUsingTabs = this.createRadioButton(indentComposite, CSSUIMessages.Indent_using_tabs_);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 1;
        this.fIndentUsingSpaces = this.createRadioButton(indentComposite, CSSUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 1;
        this.createLabel((Composite)formattingGroup, CSSUIMessages.Indentation_size);
        this.fIndentationSize = new Spinner((Composite)formattingGroup, 2048);
        GridData gd = new GridData(32);
        this.fIndentationSize.setLayoutData((Object)gd);
        this.fIndentationSize.setToolTipText(CSSUIMessages.Indentation_size_tip);
        this.fIndentationSize.setMinimum(0);
        this.fIndentationSize.setMaximum(16);
        this.fIndentationSize.setIncrement(1);
        this.fIndentationSize.setPageIncrement(4);
        this.fIndentationSize.addModifyListener((ModifyListener)this);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CSSUIPlugin.getDefault().getPreferenceStore();
    }

    private void doSavePreferenceStore() {
        CSSUIPlugin.getDefault().savePluginPreferences();
        CSSCorePlugin.getDefault().savePluginPreferences();
    }

    protected Preferences getModelPreferences() {
        return CSSCorePlugin.getDefault().getPluginPreferences();
    }

    protected void initializeValues() {
        this.initializeValuesForFormattingGroup();
        this.initializeValuesForContentAssistGroup();
    }

    private void initializeValuesForContentAssistGroup() {
        Preferences prefs = this.getModelPreferences();
        this.fIdentUpper.setSelection(prefs.getInt("identifierCase") == 2);
        this.fIdentLower.setSelection(prefs.getInt("identifierCase") == 1);
        this.fSelectorUpper.setSelection(prefs.getInt("selectorCase") == 2);
        this.fSelectorLower.setSelection(prefs.getInt("selectorCase") == 1);
        this.fPropNameUpper.setSelection(prefs.getInt("propNameCase") == 2);
        this.fPropNameLower.setSelection(prefs.getInt("propNameCase") == 1);
        this.fPropValueUpper.setSelection(prefs.getInt("propValueCase") == 2);
        this.fPropValueLower.setSelection(prefs.getInt("propValueCase") == 1);
    }

    private void initializeValuesForFormattingGroup() {
        Preferences prefs = this.getModelPreferences();
        this.fLineWidthText.setText(prefs.getString("lineWidth"));
        this.fPropertyPerLine.setSelection(prefs.getBoolean("onePropertyPerLine"));
        this.fNowrapAttr.setSelection(prefs.getBoolean("prohibitWrapOnAttr"));
        this.spaceBetweenSelectors.setSelection(prefs.getBoolean("spaceBetweenSelectors"));
        if ("tab".equals(this.getModelPreferences().getString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getInt("indentationSize"));
    }

    protected void performDefaults() {
        this.performDefaultsForFormattingGroup();
        this.performDefaultsForContentAssistGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    private void performDefaultsForContentAssistGroup() {
        Preferences prefs = this.getModelPreferences();
        this.fIdentUpper.setSelection(prefs.getDefaultInt("identifierCase") == 2);
        this.fIdentLower.setSelection(prefs.getDefaultInt("identifierCase") == 1);
        this.fSelectorUpper.setSelection(prefs.getDefaultInt("selectorCase") == 2);
        this.fSelectorLower.setSelection(prefs.getDefaultInt("selectorCase") == 1);
        this.fPropNameUpper.setSelection(prefs.getDefaultInt("propNameCase") == 2);
        this.fPropNameLower.setSelection(prefs.getDefaultInt("propNameCase") == 1);
        this.fPropValueUpper.setSelection(prefs.getDefaultInt("propValueCase") == 2);
        this.fPropValueLower.setSelection(prefs.getDefaultInt("propValueCase") == 1);
    }

    private void performDefaultsForFormattingGroup() {
        Preferences prefs = this.getModelPreferences();
        this.fLineWidthText.setText(prefs.getDefaultString("lineWidth"));
        this.fPropertyPerLine.setSelection(prefs.getDefaultBoolean("onePropertyPerLine"));
        this.fNowrapAttr.setSelection(prefs.getDefaultBoolean("prohibitWrapOnAttr"));
        this.spaceBetweenSelectors.setSelection(prefs.getDefaultBoolean("spaceBetweenSelectors"));
        if ("tab".equals(this.getModelPreferences().getDefaultString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getDefaultInt("indentationSize"));
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    protected void storeValues() {
        this.storeValuesForFormattingGroup();
        this.storeValuesForContentAssistGroup();
    }

    private void storeValuesForContentAssistGroup() {
        Preferences prefs = this.getModelPreferences();
        prefs.setValue("identifierCase", this.fIdentUpper.getSelection() ? 2 : 1);
        prefs.setValue("selectorCase", this.fSelectorUpper.getSelection() ? 2 : 1);
        prefs.setValue("propNameCase", this.fPropNameUpper.getSelection() ? 2 : 1);
        prefs.setValue("propValueCase", this.fPropValueUpper.getSelection() ? 2 : 1);
    }

    private void storeValuesForFormattingGroup() {
        Preferences prefs = this.getModelPreferences();
        prefs.setValue("lineWidth", this.fLineWidthText.getText());
        prefs.setValue("onePropertyPerLine", this.fPropertyPerLine.getSelection());
        prefs.setValue("prohibitWrapOnAttr", this.fNowrapAttr.getSelection());
        prefs.setValue("spaceBetweenSelectors", this.spaceBetweenSelectors.getSelection());
        if (this.fIndentUsingTabs.getSelection()) {
            this.getModelPreferences().setValue("indentationChar", "tab");
        } else {
            this.getModelPreferences().setValue("indentationChar", "space");
        }
        this.getModelPreferences().setValue("indentationSize", this.fIndentationSize.getSelection());
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfexc) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

