/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.workbench;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class ResourceExtensionLabelProvider
extends WorkbenchLabelProvider
implements ICommonLabelProvider {
    public void init(ICommonContentExtensionSite aConfig) {
    }

    public String getDescription(Object anElement) {
        if (anElement instanceof IResource) {
            return ((IResource)anElement).getFullPath().makeRelative().toString();
        }
        return null;
    }

    protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        ImageDescriptor descriptor = super.decorateImage(input, element);
        if (descriptor == null) {
            return null;
        }
        IResource resource = (IResource)Adapters.adapt((Object)element, IResource.class);
        if (resource != null && (resource.getType() != 4 || ((IProject)resource).isOpen())) {
            ImageDescriptor overlay = null;
            switch (this.getHighestProblemSeverity(resource)) {
                case 2: {
                    overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
                    break;
                }
                case 1: {
                    overlay = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
                }
            }
            if (overlay != null) {
                descriptor = new DecorationOverlayIcon(descriptor, overlay, 2);
            }
        }
        return descriptor;
    }

    private int getHighestProblemSeverity(IResource resource) {
        int problemSeverity = -1;
        try {
            IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                problemSeverity = Math.max(problemSeverity, marker.getAttribute("severity", -1));
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return problemSeverity;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }
}

