/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;

public class ExpressionsFix
extends AbstractFix {
    public static IFix createAddParanoidalParenthesisFix(JavaScriptUnit compilationUnit, ASTNode[] coveredNodes) throws CoreException {
        if (coveredNodes == null) {
            return null;
        }
        if (coveredNodes.length == 0) {
            return null;
        }
        ArrayList changedNodes = new ArrayList();
        int i = 0;
        while (i < coveredNodes.length) {
            ASTNode covered = coveredNodes[i];
            if (covered instanceof InfixExpression) {
                covered.accept((ASTVisitor)new MissingParenthesisVisitor(changedNodes));
            }
            ++i;
        }
        if (changedNodes.isEmpty()) {
            return null;
        }
        AddParenthesisOperation op = new AddParenthesisOperation(changedNodes.toArray(new Expression[changedNodes.size()]));
        return new ExpressionsFix(FixMessages.ExpressionsFix_addParanoiacParenthesis_description, compilationUnit, new IFixRewriteOperation[]{op});
    }

    public static IFix createRemoveUnnecessaryParenthesisFix(JavaScriptUnit compilationUnit, ASTNode[] nodes) {
        ArrayList changedNodes = new ArrayList();
        int i = 0;
        while (i < nodes.length) {
            ASTNode covered = nodes[i];
            if (covered instanceof ParenthesizedExpression || covered instanceof InfixExpression) {
                covered.accept((ASTVisitor)new UnnecessaryParenthesisVisitor(changedNodes));
            }
            ++i;
        }
        if (changedNodes.isEmpty()) {
            return null;
        }
        HashSet expressions = new HashSet(changedNodes);
        RemoveParenthesisOperation op = new RemoveParenthesisOperation(expressions);
        return new ExpressionsFix(FixMessages.ExpressionsFix_removeUnnecessaryParenthesis_description, compilationUnit, new IFixRewriteOperation[]{op});
    }

    public static IFix createCleanUp(JavaScriptUnit compilationUnit, boolean addParanoicParentesis, boolean removeUnnecessaryParenthesis) {
        if (addParanoicParentesis) {
            ArrayList changedNodes = new ArrayList();
            compilationUnit.accept((ASTVisitor)new MissingParenthesisVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            AddParenthesisOperation op = new AddParenthesisOperation(changedNodes.toArray(new Expression[changedNodes.size()]));
            return new ExpressionsFix(FixMessages.ExpressionsFix_add_parenthesis_change_name, compilationUnit, new IFixRewriteOperation[]{op});
        }
        if (removeUnnecessaryParenthesis) {
            ArrayList changedNodes = new ArrayList();
            compilationUnit.accept((ASTVisitor)new UnnecessaryParenthesisVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            HashSet expressions = new HashSet(changedNodes);
            RemoveParenthesisOperation op = new RemoveParenthesisOperation(expressions);
            return new ExpressionsFix(FixMessages.ExpressionsFix_remove_parenthesis_change_name, compilationUnit, new IFixRewriteOperation[]{op});
        }
        return null;
    }

    private static boolean isStringExpression(Expression expression) {
        ITypeBinding binding = expression.resolveTypeBinding();
        return binding.getQualifiedName().equals("String");
    }

    protected ExpressionsFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class AddParenthesisOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final Expression[] fExpressions;

        public AddParenthesisOperation(Expression[] expressions) {
            this.fExpressions = expressions;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.ExpressionsFix_addParanoiacParenthesis_description);
            textEditGroups.add(group);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            int i = 0;
            while (i < this.fExpressions.length) {
                Expression expression = this.fExpressions[i];
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expression));
                rewrite.replace((ASTNode)expression, (ASTNode)parenthesizedExpression, group);
                ++i;
            }
        }
    }

    private static final class MissingParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList fNodes;

        private MissingParenthesisVisitor(ArrayList nodes) {
            this.fNodes = nodes;
        }

        public void postVisit(ASTNode node) {
            if (!(node.getParent() instanceof InfixExpression)) {
                return;
            }
            boolean needParenthesis = false;
            if (node instanceof InfixExpression) {
                InfixExpression expression = (InfixExpression)node;
                InfixExpression.Operator operator = expression.getOperator();
                InfixExpression parentExpression = (InfixExpression)node.getParent();
                InfixExpression.Operator parentOperator = parentExpression.getOperator();
                if (parentOperator == operator) {
                    return;
                }
                boolean bl = needParenthesis = operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER_EQUALS || operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS || operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR;
            }
            if (node instanceof InstanceofExpression) {
                needParenthesis = true;
            }
            if (!needParenthesis) {
                return;
            }
            this.fNodes.add(node);
        }
    }

    private static class RemoveParenthesisOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final HashSet fExpressions;

        public RemoveParenthesisOperation(HashSet expressions) {
            this.fExpressions = expressions;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.ExpressionsFix_removeUnnecessaryParenthesis_description);
            textEditGroups.add(group);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            while (this.fExpressions.size() > 0) {
                ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)this.fExpressions.iterator().next();
                this.fExpressions.remove(parenthesizedExpression);
                ParenthesizedExpression down = parenthesizedExpression;
                while (this.fExpressions.contains(down.getExpression())) {
                    down = (ParenthesizedExpression)down.getExpression();
                    this.fExpressions.remove(down);
                }
                ASTNode move = rewrite.createMoveTarget((ASTNode)down.getExpression());
                ParenthesizedExpression top = parenthesizedExpression;
                while (this.fExpressions.contains(top.getParent())) {
                    top = (ParenthesizedExpression)top.getParent();
                    this.fExpressions.remove(top);
                }
                rewrite.replace((ASTNode)top, move, group);
            }
        }
    }

    private static final class UnnecessaryParenthesisVisitor
    extends ASTVisitor {
        private final ArrayList fNodes;

        private UnnecessaryParenthesisVisitor(ArrayList nodes) {
            this.fNodes = nodes;
        }

        public void postVisit(ASTNode node) {
            if (!(node instanceof ParenthesizedExpression)) {
                return;
            }
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)node;
            Expression expression = parenthesizedExpression.getExpression();
            while (expression instanceof ParenthesizedExpression) {
                expression = ((ParenthesizedExpression)expression).getExpression();
            }
            if (parenthesizedExpression.getParent() instanceof Expression) {
                int parentPrecedence;
                Expression parentExpression = (Expression)parenthesizedExpression.getParent();
                int expressionPrecedence = UnnecessaryParenthesisVisitor.getExpressionPrecedence(expression);
                if (expressionPrecedence > (parentPrecedence = UnnecessaryParenthesisVisitor.getExpressionPrecedence(parentExpression)) && !(parenthesizedExpression.getParent() instanceof ParenthesizedExpression)) {
                    return;
                }
                if (expressionPrecedence == parentPrecedence && parentExpression instanceof InfixExpression) {
                    InfixExpression parentInfix = (InfixExpression)parentExpression;
                    InfixExpression.Operator parentOperator = parentInfix.getOperator();
                    if (parentInfix.getLeftOperand() == parenthesizedExpression) {
                        this.fNodes.add(node);
                    } else if (this.isAssoziative(parentOperator)) {
                        if (parentOperator == InfixExpression.Operator.PLUS) {
                            if (ExpressionsFix.isStringExpression(parentInfix.getLeftOperand()) || ExpressionsFix.isStringExpression(parentInfix.getRightOperand())) {
                                return;
                            }
                            for (Expression operand : parentInfix.extendedOperands()) {
                                if (!ExpressionsFix.isStringExpression(operand)) continue;
                                return;
                            }
                        }
                        this.fNodes.add(node);
                    }
                    return;
                }
                if (expressionPrecedence == parentPrecedence && parentExpression instanceof ConditionalExpression && ((ConditionalExpression)parentExpression).getElseExpression() != parenthesizedExpression) {
                    return;
                }
            }
            this.fNodes.add(node);
        }

        private boolean isAssoziative(InfixExpression.Operator operator) {
            if (operator == InfixExpression.Operator.PLUS) {
                return true;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return true;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return true;
            }
            if (operator == InfixExpression.Operator.AND) {
                return true;
            }
            if (operator == InfixExpression.Operator.OR) {
                return true;
            }
            if (operator == InfixExpression.Operator.XOR) {
                return true;
            }
            return operator == InfixExpression.Operator.TIMES;
        }

        private static int getExpressionPrecedence(Expression expression) {
            if (expression instanceof PostfixExpression || expression instanceof FunctionInvocation) {
                return 0;
            }
            if (expression instanceof PrefixExpression) {
                return 1;
            }
            if (expression instanceof ClassInstanceCreation) {
                return 2;
            }
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                InfixExpression.Operator operator = infixExpression.getOperator();
                return UnnecessaryParenthesisVisitor.getInfixOperatorPrecedence(operator);
            }
            if (expression instanceof InstanceofExpression) {
                return 6;
            }
            if (expression instanceof ConditionalExpression) {
                return 13;
            }
            if (expression instanceof Assignment) {
                return 14;
            }
            return -1;
        }

        private static int getInfixOperatorPrecedence(InfixExpression.Operator operator) {
            if (operator == InfixExpression.Operator.TIMES || operator == InfixExpression.Operator.DIVIDE || operator == InfixExpression.Operator.REMAINDER) {
                return 3;
            }
            if (operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.MINUS) {
                return 4;
            }
            if (operator == InfixExpression.Operator.LEFT_SHIFT || operator == InfixExpression.Operator.RIGHT_SHIFT_SIGNED || operator == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED) {
                return 5;
            }
            if (operator == InfixExpression.Operator.LESS || operator == InfixExpression.Operator.GREATER || operator == InfixExpression.Operator.LESS_EQUALS || operator == InfixExpression.Operator.GREATER_EQUALS) {
                return 6;
            }
            if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) {
                return 7;
            }
            if (operator == InfixExpression.Operator.AND) {
                return 8;
            }
            if (operator == InfixExpression.Operator.XOR) {
                return 9;
            }
            if (operator == InfixExpression.Operator.OR) {
                return 10;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return 11;
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return 12;
            }
            return -1;
        }
    }
}

