/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class RenameVirtualMethodProcessor
extends RenameMethodProcessor {
    private IFunction fOriginalMethod = this.getMethod();
    private boolean fActivationChecked;
    private ITypeHierarchy fCachedHierarchy = null;

    public RenameVirtualMethodProcessor(IFunction method) {
        super(method);
    }

    RenameVirtualMethodProcessor(IFunction topLevel, IFunction[] ripples, TextChangeManager changeManager, ITypeHierarchy hierarchy, GroupCategorySet categorySet) {
        super(topLevel, changeManager, categorySet);
        this.fActivationChecked = true;
        this.fCachedHierarchy = hierarchy;
        this.setMethodsToRename(ripples);
    }

    public IFunction getOriginalMethod() {
        return this.fOriginalMethod;
    }

    private ITypeHierarchy getCachedHierarchy(IType declaring, IProgressMonitor monitor) throws JavaScriptModelException {
        if (this.fCachedHierarchy != null && declaring.equals(this.fCachedHierarchy.getType())) {
            return this.fCachedHierarchy;
        }
        this.fCachedHierarchy = declaring.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return this.fCachedHierarchy;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameVirtualMethodAvailable(this.getMethod());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = super.checkInitialConditions(monitor);
        if (result.hasFatalError()) {
            return result;
        }
        try {
            monitor.beginTask("", 3);
            if (!this.fActivationChecked) {
                IFunction topmost;
                IFunction method;
                this.fOriginalMethod = method = this.getMethod();
                ITypeHierarchy hierarchy = null;
                IType declaringType = method.getDeclaringType();
                if (declaringType != null) {
                    hierarchy = this.getCachedHierarchy(declaringType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (MethodChecks.isVirtual(topmost = this.getMethod())) {
                    topmost = MethodChecks.getTopmostMethod(this.getMethod(), hierarchy, monitor);
                }
                if (topmost != null) {
                    this.initialize(topmost);
                }
                this.fActivationChecked = true;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        try {
            pm.beginTask("", 9);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(super.doCheckFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 7), checkContext));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IFunction method = this.getMethod();
            IType declaring = method.getDeclaringType();
            ITypeHierarchy hierarchy = this.getCachedHierarchy(declaring, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            String name = this.getNewElementName();
            IFunction[] hierarchyMethods = RenameVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), hierarchy, method, name);
            int i = 0;
            while (i < hierarchyMethods.length) {
                IFunction hierarchyMethod = hierarchyMethods[i];
                RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                if (Checks.compareParamTypes(method.getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                    result.addError(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares2, name), context);
                } else {
                    result.addWarning(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares1, name), context);
                }
                ++i;
            }
            this.fCachedHierarchy = null;
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IFunction[] relatedTypeDeclaresMethodName(IProgressMonitor pm, IFunction method, String newName) throws CoreException {
        try {
            HashSet<IFunction> result = new HashSet<IFunction>();
            Set types = this.getRelatedTypes();
            pm.beginTask("", types.size());
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                IFunction found = Checks.findMethod(method, (IType)iter.next());
                IType declaring = found.getDeclaringType();
                result.addAll(Arrays.asList(RenameVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), declaring.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1)), found, newName)));
            }
            IFunction[] iFunctionArray = result.toArray(new IFunction[result.size()]);
            return iFunctionArray;
        }
        finally {
            pm.done();
        }
    }

    private boolean isSpecialCase() throws CoreException {
        String[] noParams = new String[]{};
        String[] specialNames = new String[]{"toString", "toString", "toString", "toString", "getClass", "getClass", "notify", "notifyAll", "wait"};
        String[][] specialParamTypes = new String[][]{noParams, noParams, noParams, noParams, noParams, noParams, noParams, noParams, noParams};
        String[] specialReturnTypes = new String[]{"QString;", "QString;", "Qjava.lang.String;", "Qjava.lang.String;", "QClass;", "Qjava.lang.Class;", "V", "V", "V"};
        Assert.isTrue((specialNames.length == specialParamTypes.length && specialParamTypes.length == specialReturnTypes.length ? 1 : 0) != 0);
        int i = 0;
        while (i < specialNames.length) {
            if (specialNames[i].equals(this.getNewElementName()) && Checks.compareParamTypes(this.getMethod().getParameterTypes(), specialParamTypes[i]) && !specialReturnTypes[i].equals(this.getMethod().getReturnType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Set getRelatedTypes() {
        Set methods = this.getMethodsToRename();
        HashSet<IType> result = new HashSet<IType>(methods.size());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            result.add(((IFunction)iter.next()).getDeclaringType());
        }
        return result;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        RefactoringStatus status = super.initialize(arguments);
        this.fOriginalMethod = this.getMethod();
        return status;
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

