/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.text.JavaScriptTextTools;

class JavaCompareUtilities {
    private static final char PACKAGEDECLARATION = '%';
    private static final char IMPORTDECLARATION = '#';
    private static final char IMPORT_CONTAINER = '<';
    private static final char FIELD = '^';
    private static final char METHOD = '~';
    private static final char INITIALIZER = '|';
    private static final char COMPILATIONUNIT = '{';
    private static final char TYPE = '[';

    JavaCompareUtilities() {
    }

    static String getString(ResourceBundle bundle, String key, String dfltValue) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return dfltValue;
    }

    static String getString(ResourceBundle bundle, String key) {
        return JavaCompareUtilities.getString(bundle, key, key);
    }

    static int getInteger(ResourceBundle bundle, String key, int dfltValue) {
        if (bundle != null) {
            try {
                String s = bundle.getString(key);
                if (s != null) {
                    return Integer.parseInt(s);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return dfltValue;
    }

    static ImageDescriptor getImageDescriptor(int type) {
        switch (type) {
            case 9: 
            case 10: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_method.gif");
            }
            case 8: {
                return JavaCompareUtilities.getImageDescriptor("obj16/compare_field.gif");
            }
            case 13: {
                return JavaPluginImages.DESC_OBJS_IMPDECL;
            }
            case 12: {
                return JavaPluginImages.DESC_OBJS_IMPCONT;
            }
            case 5: {
                return JavaPluginImages.DESC_OBJS_CUNIT;
            }
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    static ImageDescriptor getTypeImageDescriptor(boolean isClass) {
        if (isClass) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE;
    }

    static ImageDescriptor getEnumImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_ENUM;
    }

    static ImageDescriptor getAnnotationImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_ANNOTATION;
    }

    static ImageDescriptor getImageDescriptor(IMember element) {
        int t = element.getElementType();
        if (t == 7) {
            IType type = (IType)element;
            try {
                return JavaCompareUtilities.getTypeImageDescriptor(type.isClass());
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                return JavaPluginImages.DESC_OBJS_GHOST;
            }
        }
        return JavaCompareUtilities.getImageDescriptor(t);
    }

    static String getJavaElementID(IJavaScriptElement je) {
        if (je instanceof IMember && ((IMember)je).isBinary()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        switch (je.getElementType()) {
            case 5: {
                sb.append('{');
                break;
            }
            case 7: {
                sb.append('[');
                sb.append(je.getElementName());
                break;
            }
            case 8: {
                sb.append('^');
                sb.append(je.getElementName());
                break;
            }
            case 9: {
                sb.append('~');
                sb.append(JavaScriptElementLabels.getElementLabel(je, 1L));
                break;
            }
            case 10: {
                String id = je.getHandleIdentifier();
                int pos = id.lastIndexOf(124);
                if (pos < 0) break;
                sb.append(id.substring(pos));
                break;
            }
            case 12: {
                sb.append('<');
                break;
            }
            case 13: {
                sb.append('#');
                sb.append(je.getElementName());
                break;
            }
            default: {
                return null;
            }
        }
        return sb.toString();
    }

    static String buildID(int type, String name) {
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case 0: {
                sb.append('{');
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                sb.append('[');
                sb.append(name);
                break;
            }
            case 8: {
                sb.append('^');
                sb.append(name);
                break;
            }
            case 10: 
            case 11: {
                sb.append('~');
                sb.append(name);
                break;
            }
            case 9: {
                sb.append('|');
                sb.append(name);
                break;
            }
            case 1: {
                sb.append('%');
                break;
            }
            case 3: {
                sb.append('#');
                sb.append(name);
                break;
            }
            case 2: {
                sb.append('<');
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
            }
        }
        return sb.toString();
    }

    static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = JavaPluginImages.ICONS_PATH.append(relativePath);
        return JavaPluginImages.createImageDescriptor(JavaScriptPlugin.getDefault().getBundle(), path, true);
    }

    static boolean getBoolean(CompareConfiguration cc, String key, boolean dflt) {
        Object value;
        if (cc != null && (value = cc.getProperty(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        return dflt;
    }

    static Image getImage(IMember member) {
        ImageDescriptor id = JavaCompareUtilities.getImageDescriptor(member);
        return id.createImage();
    }

    static JavaScriptTextTools getJavaTextTools() {
        JavaScriptPlugin plugin = JavaScriptPlugin.getDefault();
        if (plugin != null) {
            return plugin.getJavaTextTools();
        }
        return null;
    }

    static IDocumentPartitioner createJavaPartitioner() {
        JavaScriptTextTools tools = JavaCompareUtilities.getJavaTextTools();
        if (tools != null) {
            return tools.createDocumentPartitioner();
        }
        return null;
    }

    static void setupDocument(IDocument document) {
        JavaScriptTextTools tools = JavaCompareUtilities.getJavaTextTools();
        if (tools != null) {
            tools.setupJavaDocumentPartitioner(document, "___java_partitioning");
        }
    }

    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return JavaCompareUtilities.readString(is, encoding);
        }
        return null;
    }

    static byte[] getBytes(String s, String encoding) {
        try {
            return s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    /*
     * Loose catch block
     */
    static String[] readLines(InputStream is2, String encoding) {
        String[] stringArray;
        BufferedReader reader;
        block15: {
            int c;
            reader = null;
            reader = new BufferedReader(new InputStreamReader(is2, encoding));
            StringBuffer sb = new StringBuffer();
            ArrayList<String> list = new ArrayList<String>();
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
                if (c == 13) {
                    c = reader.read();
                    if (c == -1) break;
                    sb.append((char)c);
                    if (c != 10) continue;
                    list.add(sb.toString());
                    sb = new StringBuffer();
                    continue;
                }
                if (c != 10) continue;
                list.add(sb.toString());
                sb = new StringBuffer();
            }
            if (sb.length() > 0) {
                list.add(sb.toString());
            }
            stringArray = list.toArray(new String[list.size()]);
            if (reader == null) break block15;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringArray;
        catch (IOException ex) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    static void initAction(IAction a, ResourceBundle bundle, String prefix) {
        String labelKey = "label";
        String tooltipKey = "tooltip";
        String imageKey = "image";
        String descriptionKey = "description";
        if (prefix != null && prefix.length() > 0) {
            labelKey = String.valueOf(prefix) + labelKey;
            tooltipKey = String.valueOf(prefix) + tooltipKey;
            imageKey = String.valueOf(prefix) + imageKey;
            descriptionKey = String.valueOf(prefix) + descriptionKey;
        }
        a.setText(JavaCompareUtilities.getString(bundle, labelKey, labelKey));
        a.setToolTipText(JavaCompareUtilities.getString(bundle, tooltipKey, null));
        a.setDescription(JavaCompareUtilities.getString(bundle, descriptionKey, null));
        String relPath = JavaCompareUtilities.getString(bundle, imageKey, null);
        if (relPath != null && relPath.trim().length() > 0) {
            String ePath;
            String dPath;
            if (relPath.indexOf("/") >= 0) {
                String path = relPath.substring(1);
                dPath = String.valueOf('d') + path;
                ePath = String.valueOf('e') + path;
            } else {
                dPath = "dlcl16/" + relPath;
                ePath = "elcl16/" + relPath;
            }
            ImageDescriptor id = JavaCompareUtilities.getImageDescriptor(dPath);
            if (id != null) {
                a.setDisabledImageDescriptor(id);
            }
            if ((id = JavaCompareUtilities.getImageDescriptor(ePath)) != null) {
                a.setImageDescriptor(id);
                a.setHoverImageDescriptor(id);
            }
        }
    }

    static void initToggleAction(IAction a, ResourceBundle bundle, String prefix, boolean checked) {
        String tooltip = null;
        tooltip = checked ? JavaCompareUtilities.getString(bundle, String.valueOf(prefix) + "tooltip.checked", null) : JavaCompareUtilities.getString(bundle, String.valueOf(prefix) + "tooltip.unchecked", null);
        if (tooltip == null) {
            tooltip = JavaCompareUtilities.getString(bundle, String.valueOf(prefix) + "tooltip", null);
        }
        if (tooltip != null) {
            a.setToolTipText(tooltip);
        }
        String description = null;
        description = checked ? JavaCompareUtilities.getString(bundle, String.valueOf(prefix) + "description.checked", null) : JavaCompareUtilities.getString(bundle, String.valueOf(prefix) + "description.unchecked", null);
        if (description == null) {
            description = JavaCompareUtilities.getString(bundle, String.valueOf(prefix) + "description", null);
        }
        if (description != null) {
            a.setDescription(description);
        }
    }
}

