/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java.hover;

import java.util.Properties;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTMLPrinter;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.wst.jsdt.internal.ui.text.java.hover.JavaHoverMessages;

public class NLSStringHover
extends AbstractJavaEditorTextHover {
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        IJavaScriptElement je = this.getEditorInputJavaElement();
        if (je == null) {
            return null;
        }
        JavaScriptUnit ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(je, ASTProvider.WAIT_NO, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, offset, 1);
        if (node instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)node;
            return new Region(stringLiteral.getStartPosition(), stringLiteral.getLength());
        }
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            return new Region(simpleName.getStartPosition(), simpleName.getLength());
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IStorage propertiesFile;
        if (!(this.getEditor() instanceof JavaEditor)) {
            return null;
        }
        IJavaScriptElement je = this.getEditorInputJavaElement();
        if (je == null) {
            return null;
        }
        JavaScriptUnit ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(je, ASTProvider.WAIT_ACTIVE_ONLY, null);
        if (ast == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)ast, hoverRegion.getOffset(), hoverRegion.getLength());
        if (!(node instanceof StringLiteral) && !(node instanceof SimpleName)) {
            return null;
        }
        if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        AccessorClassReference ref = NLSHintHelper.getAccessorClassReference(ast, hoverRegion);
        if (ref == null) {
            return null;
        }
        try {
            propertiesFile = NLSHintHelper.getResourceBundle(je.getJavaScriptProject(), ref);
            if (propertiesFile == null) {
                return this.toHtml(JavaHoverMessages.NLSStringHover_NLSStringHover_PropertiesFileNotDetectedWarning, "");
            }
        }
        catch (JavaScriptModelException ex) {
            return null;
        }
        String propertiesFileName = propertiesFile.getName();
        Properties properties = NLSHintHelper.getProperties(propertiesFile);
        if (properties == null) {
            return null;
        }
        if (properties.isEmpty()) {
            return this.toHtml(propertiesFileName, JavaHoverMessages.NLSStringHover_NLSStringHover_missingKeyWarning);
        }
        String identifier = null;
        identifier = node instanceof StringLiteral ? ((StringLiteral)node).getLiteralValue() : ((SimpleName)node).getIdentifier();
        if (identifier == null) {
            return null;
        }
        String value = properties.getProperty(identifier, null);
        value = value != null ? HTMLPrinter.convertToHTMLContent(value) : JavaHoverMessages.NLSStringHover_NLSStringHover_missingKeyWarning;
        return this.toHtml(propertiesFileName, value);
    }

    private String toHtml(String header, String string) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addSmallHeader(buffer, header);
        HTMLPrinter.addParagraph(buffer, string);
        HTMLPrinter.insertPageProlog(buffer, 0);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private IJavaScriptElement getEditorInputJavaElement() {
        IEditorInput editorInput;
        if (this.getEditor() instanceof CompilationUnitEditor) {
            return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.getEditor().getEditorInput());
        }
        if (this.getEditor() instanceof ClassFileEditor && (editorInput = this.getEditor().getEditorInput()) instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)editorInput).getClassFile();
        }
        return null;
    }
}

