/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class JavaSpellingReconcileStrategy
extends SpellingReconcileStrategy {
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private String fPartitioning;

    public JavaSpellingReconcileStrategy(ISourceViewer viewer, SpellingService spellingService, String partitioning) {
        super(viewer, spellingService);
        this.fPartitioning = partitioning;
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        return new JSSpellingProblemCollector(super.createSpellingProblemCollector());
    }

    private class JSSpellingProblemCollector
    implements ISpellingProblemCollector {
        private ISpellingProblemCollector fParentCollector;

        public JSSpellingProblemCollector(ISpellingProblemCollector parentCollector) {
            this.fParentCollector = parentCollector;
        }

        public void accept(SpellingProblem problem) {
            try {
                String type = ((IDocumentExtension3)JavaSpellingReconcileStrategy.this.getDocument()).getPartition(JavaSpellingReconcileStrategy.this.fPartitioning, problem.getOffset(), false).getType();
                if ("__java_javadoc".equals(type) || "__java_multiline_comment".equals(type) || "__java_singleline_comment".equals(type)) {
                    this.fParentCollector.accept(problem);
                }
            }
            catch (BadLocationException e) {
                this.fParentCollector.accept(problem);
            }
            catch (BadPartitioningException e) {
                this.fParentCollector.accept(problem);
            }
        }

        public void beginCollecting() {
            this.fParentCollector.beginCollecting();
        }

        public void endCollecting() {
            this.fParentCollector.endCollecting();
        }
    }
}

