/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.core.DocumentAdapter;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IQuickFixProcessor;

public class SpellingQuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(IJavaScriptUnit unit, int problemId) {
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<Region> regions = new ArrayList<Region>();
        int i = 0;
        while (i < locations.length) {
            if (locations[i].getMarkerType() == "org.eclipse.ui.workbench.texteditor.spelling") {
                regions.add(new Region(locations[i].getOffset(), locations[i].getLength()));
            }
            ++i;
        }
        SpellingProblemCollector collector = new SpellingProblemCollector(context);
        if (!regions.isEmpty()) {
            SpellingContext spellingContext = new SpellingContext();
            spellingContext.setContentType(Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource"));
            EditorsUI.getSpellingService().check((IDocument)new DocumentAdapter(context.getCompilationUnit().getBuffer()), regions.toArray(new IRegion[regions.size()]), spellingContext, (ISpellingProblemCollector)collector, (IProgressMonitor)new NullProgressMonitor());
        }
        return collector.getProposals();
    }

    static final class SpellingProblemCollector
    implements ISpellingProblemCollector {
        IQuickAssistInvocationContext fContext = null;
        private List fProposals = new ArrayList();

        SpellingProblemCollector(final IInvocationContext context) {
            this.fContext = new IQuickAssistInvocationContext(){

                public ISourceViewer getSourceViewer() {
                    return null;
                }

                public int getOffset() {
                    return context.getSelectionOffset();
                }

                public int getLength() {
                    return context.getSelectionLength();
                }
            };
        }

        public void accept(SpellingProblem problem) {
            ICompletionProposal[] proposals = problem.getProposals(this.fContext);
            int i = 0;
            while (i < proposals.length) {
                this.fProposals.add(new SpellingProposal(proposals[i]));
                ++i;
            }
        }

        public void beginCollecting() {
            this.fProposals.clear();
        }

        public void endCollecting() {
        }

        IJavaCompletionProposal[] getProposals() {
            return this.fProposals.toArray(new IJavaCompletionProposal[this.fProposals.size()]);
        }
    }

    private static class SpellingProposal
    implements IJavaCompletionProposal {
        ICompletionProposal fProposal;

        SpellingProposal(ICompletionProposal spellingProposal) {
            this.fProposal = spellingProposal;
        }

        public int getRelevance() {
            return 50;
        }

        public void apply(IDocument document) {
            this.fProposal.apply(document);
        }

        public String getAdditionalProposalInfo() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public IContextInformation getContextInformation() {
            return this.fProposal.getContextInformation();
        }

        public String getDisplayString() {
            return this.fProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        public Point getSelection(IDocument document) {
            return this.fProposal.getSelection(document);
        }
    }
}

