/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.preferences.HTMLUIPreferenceNames;
import org.eclipse.wst.sse.ui.contentassist.StructuredContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationPresenter;

public class HTMLStructuredContentAssistProcessor
extends StructuredContentAssistProcessor {
    private char[] fCompletionProposalAutoActivationCharacters;
    private IContextInformationValidator fContextInformationValidator;

    public HTMLStructuredContentAssistProcessor(ContentAssistant assistant, String partitionTypeID, ITextViewer viewer) {
        super(assistant, partitionTypeID, viewer, HTMLUIPlugin.getDefault().getPreferenceStore());
        this.getAutoActivationCharacterPreferences();
        this.updateAutoActivationDelay();
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fContextInformationValidator == null) {
            this.fContextInformationValidator = new AttributeContextInformationPresenter();
        }
        return this.fContextInformationValidator;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return super.getCompletionProposalAutoActivationCharacters() != null ? super.getCompletionProposalAutoActivationCharacters() : this.fCompletionProposalAutoActivationCharacters;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(HTMLUIPreferenceNames.AUTO_PROPOSE) || event.getProperty().equals(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE)) {
            this.getAutoActivationCharacterPreferences();
        } else if (event.getProperty().equals("autoProposeDelay")) {
            this.updateAutoActivationDelay();
        }
    }

    private void updateAutoActivationDelay() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean doAuto = store.getBoolean(HTMLUIPreferenceNames.AUTO_PROPOSE);
        if (doAuto) {
            this.setAutoActivationDelay(store.getInt("autoProposeDelay"));
        }
    }

    private void getAutoActivationCharacterPreferences() {
        String key = HTMLUIPreferenceNames.AUTO_PROPOSE;
        boolean doAuto = this.getPreferenceStore().getBoolean(key);
        if (doAuto) {
            key = HTMLUIPreferenceNames.AUTO_PROPOSE_CODE;
            String completionProposalAutoActivationCharacters = String.valueOf(this.getPreferenceStore().getString(key)) + "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            this.fCompletionProposalAutoActivationCharacters = completionProposalAutoActivationCharacters.toCharArray();
        } else {
            this.fCompletionProposalAutoActivationCharacters = null;
        }
    }
}

