/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language.settings.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProviderAssociationManager;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProvidersLabelProvider;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsProvidersPage;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.internal.ui.newui.StatusMessageLine;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.language.settings.providers.AbstractLanguageSettingProviderOptionPage;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LanguageSettingsProviderTab
extends AbstractCPropertyTab {
    private static final String WORKSPACE_PREFERENCE_PAGE = "org.eclipse.cdt.ui.preferences.BuildSettingProperties";
    private static final String TEST_PLUGIN_ID_PATTERN = "org.eclipse.cdt.*.tests.*";
    private static final String CLEAR_STR = Messages.LanguageSettingsProviderTab_Clear;
    private static final String RESET_STR = Messages.LanguageSettingsProviderTab_Reset;
    private static final int BUTTON_CLEAR = 0;
    private static final int BUTTON_RESET = 1;
    private static final int BUTTON_MOVE_UP = 3;
    private static final int BUTTON_MOVE_DOWN = 4;
    private static final int[] DEFAULT_CONFIGURE_SASH_WEIGHTS = new int[]{50, 50};
    private SashForm sashFormProviders;
    private Table tableProviders;
    private CheckboxTableViewer tableProvidersViewer;
    private Group groupOptionsPage;
    private ICOptionPage currentOptionsPage = null;
    private Composite compositeOptionsPage;
    private StatusMessageLine fStatusLine;
    private Button sharedProviderCheckBox = null;
    private Link linkToWorkspacePreferences = null;
    private Button projectStorageCheckBox = null;
    private LanguageSettingsProvidersPage masterPropertyPage = null;
    private List<ILanguageSettingsProvider> presentedProviders = null;
    private final Map<String, ICOptionPage> optionsPageMap = new HashMap<String, ICOptionPage>();
    private Map<String, List<ILanguageSettingsProvider>> initialProvidersByCfg = new HashMap<String, List<ILanguageSettingsProvider>>();

    public ILanguageSettingsProvider getProvider(String id) {
        return this.findProvider(id, this.presentedProviders);
    }

    public ILanguageSettingsProvider getInitialProvider(String id) {
        ILanguageSettingsProvider initialProvider = null;
        if (this.page.isForPrefs()) {
            initialProvider = LanguageSettingsManager.getWorkspaceProvider((String)id);
        } else {
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            List<ILanguageSettingsProvider> initialProviders = this.initialProvidersByCfg.get(cfgDescription.getId());
            initialProvider = this.findProvider(id, initialProviders);
        }
        return initialProvider;
    }

    private boolean isWorkingCopy(ILanguageSettingsProvider provider) {
        boolean isWorkingCopy = false;
        if (this.page.isForPrefs()) {
            isWorkingCopy = !LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider);
        } else if (!LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider)) {
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            List<ILanguageSettingsProvider> initialProviders = this.initialProvidersByCfg.get(cfgDescription.getId());
            isWorkingCopy = initialProviders != null && !initialProviders.contains(provider);
        }
        return isWorkingCopy;
    }

    public ILanguageSettingsProvider getWorkingCopy(String id) {
        ILanguageSettingsProvider provider = this.findProvider(id, this.presentedProviders);
        if (this.isWorkingCopy(provider)) {
            return provider;
        }
        ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
        ILanguageSettingsEditableProvider newProvider = LanguageSettingsManager.getProviderCopy((ILanguageSettingsEditableProvider)((ILanguageSettingsEditableProvider)rawProvider), (boolean)true);
        if (newProvider != null) {
            this.replaceSelectedProvider((ILanguageSettingsProvider)newProvider);
        }
        return newProvider;
    }

    public void refreshItem(ILanguageSettingsProvider provider) {
        this.tableProvidersViewer.refresh((Object)provider);
        this.updateButtons();
    }

    private boolean isReconfiguredForProject(ILanguageSettingsProvider provider) {
        String id = provider.getId();
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        String[] defaultIds = ((ILanguageSettingsProvidersKeeper)cfgDescription).getDefaultLanguageSettingsProvidersIds();
        List providers = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
        if (defaultIds != null && Arrays.asList(defaultIds).contains(id) != providers.contains(provider)) {
            return true;
        }
        if (!providers.contains(provider)) {
            return false;
        }
        if (LanguageSettingsManager.isPreferShared((String)id) != LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider)) {
            return true;
        }
        return !LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider) && !LanguageSettingsManager.isEqualExtensionProvider((ILanguageSettingsProvider)provider, (boolean)false);
    }

    private boolean isEditedForProject(ILanguageSettingsProvider provider) {
        String id = provider.getId();
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        List<ILanguageSettingsProvider> initialProviders = this.initialProvidersByCfg.get(cfgDescription.getId());
        List<ILanguageSettingsProvider> providers = this.getCheckedProviders();
        ILanguageSettingsProvider initialProvider = this.findProvider(id, initialProviders);
        if (initialProvider != null != providers.contains(provider)) {
            return true;
        }
        if (providers.contains(provider) && LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)initialProvider) != LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider)) {
            return true;
        }
        return !LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider) && !provider.equals(initialProvider);
    }

    private boolean isPresentedAsShared(ILanguageSettingsProvider provider) {
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        List providers = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
        return LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider) && (providers.contains(provider) || LanguageSettingsManager.isPreferShared((String)provider.getId()));
    }

    private ILanguageSettingsProvider findProvider(String id, List<ILanguageSettingsProvider> providers) {
        if (providers != null) {
            for (ILanguageSettingsProvider provider : providers) {
                if (!provider.getId().equals(id)) continue;
                return provider;
            }
        }
        return null;
    }

    private ILanguageSettingsProvider getSelectedProvider() {
        ILanguageSettingsProvider provider = null;
        int pos = this.tableProviders.getSelectionIndex();
        if (pos >= 0 && pos < this.tableProviders.getItemCount()) {
            provider = (ILanguageSettingsProvider)this.tableProvidersViewer.getElementAt(pos);
        }
        return provider;
    }

    private ICConfigurationDescription getConfigurationDescription() {
        if (this.page.isForPrefs()) {
            return null;
        }
        return this.getResDesc().getConfiguration();
    }

    private List<ILanguageSettingsProvider> getCheckedProviders() {
        return Arrays.asList(this.tableProvidersViewer.getCheckedElements());
    }

    private void replaceSelectedProvider(ILanguageSettingsProvider newProvider) {
        int pos = this.tableProviders.getSelectionIndex();
        boolean isChecked = this.tableProvidersViewer.getChecked(this.tableProvidersViewer.getElementAt(pos));
        this.presentedProviders.set(pos, newProvider);
        this.tableProvidersViewer.refresh();
        this.tableProvidersViewer.setChecked((Object)newProvider, isChecked);
        this.tableProviders.setSelection(pos);
        this.saveCheckedProviders();
        this.tableProvidersViewer.refresh((Object)newProvider);
    }

    private void saveCheckedProviders() {
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            ((ILanguageSettingsProvidersKeeper)cfgDescription).setLanguageSettingProviders(this.getCheckedProviders());
        }
    }

    private void trackInitialSettings() {
        if (!this.page.isForPrefs()) {
            ICConfigurationDescription[] cfgDescriptions;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgDescriptions = this.page.getCfgsEditable();
            int n = cfgDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription cfgDescription = iCConfigurationDescriptionArray[n2];
                if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                    String cfgId = cfgDescription.getId();
                    List initialProviders = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
                    this.initialProvidersByCfg.put(cfgId, initialProviders);
                }
                ++n2;
            }
        }
    }

    private void createProvidersPane(Composite parent) {
        Composite composite = new Composite(parent, 2052);
        composite.setLayout((Layout)new GridLayout());
        this.tableProviders = new Table(composite, this.page.isForPrefs() ? 0 : 32);
        this.tableProviders.setLayoutData((Object)new GridData(1808));
        this.tableProviders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageSettingsProviderTab.this.displaySelectedOptionPage();
                LanguageSettingsProviderTab.this.updateButtons();
            }
        });
        this.tableProvidersViewer = new CheckboxTableViewer(this.tableProviders);
        this.tableProvidersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableProvidersViewer.setLabelProvider((IBaseLabelProvider)new ProvidersTableLabelProvider());
        this.tableProvidersViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ILanguageSettingsProvider checkedProvider = (ILanguageSettingsProvider)event.getElement();
                String id = checkedProvider.getId();
                ILanguageSettingsProvider newProvider = null;
                if (event.getChecked()) {
                    ILanguageSettingsProvider rawProvider;
                    if (LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)checkedProvider) && !LanguageSettingsManager.isPreferShared((String)id) && (newProvider = LanguageSettingsProviderTab.this.getInitialProvider(id)) == null && (rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)checkedProvider)) instanceof ILanguageSettingsEditableProvider) {
                        newProvider = LanguageSettingsManager.getProviderCopy((ILanguageSettingsEditableProvider)((ILanguageSettingsEditableProvider)rawProvider), (boolean)false);
                    }
                } else if (!LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)checkedProvider)) {
                    newProvider = LanguageSettingsManager.getWorkspaceProvider((String)id);
                }
                int pos = LanguageSettingsProviderTab.this.presentedProviders.indexOf(checkedProvider);
                LanguageSettingsProviderTab.this.tableProviders.setSelection(pos);
                if (newProvider != null) {
                    LanguageSettingsProviderTab.this.replaceSelectedProvider(newProvider);
                    LanguageSettingsProviderTab.this.createOptionsPage(newProvider);
                } else {
                    LanguageSettingsProviderTab.this.saveCheckedProviders();
                    LanguageSettingsProviderTab.this.tableProvidersViewer.refresh((Object)checkedProvider);
                }
                LanguageSettingsProviderTab.this.displaySelectedOptionPage();
                LanguageSettingsProviderTab.this.updateButtons();
            }
        });
    }

    private ILanguageSettingsProvider toggleGlobalProvider(ILanguageSettingsProvider provider, boolean toGlobal) {
        ILanguageSettingsProvider newProvider = null;
        String id = provider.getId();
        if (toGlobal) {
            newProvider = LanguageSettingsManager.getWorkspaceProvider((String)id);
        } else {
            newProvider = this.getInitialProvider(id);
            if (newProvider == null || LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)newProvider)) {
                try {
                    ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
                    if (rawProvider instanceof ILanguageSettingsEditableProvider) {
                        newProvider = ((ILanguageSettingsEditableProvider)rawProvider).cloneShallow();
                    }
                }
                catch (CloneNotSupportedException e) {
                    CUIPlugin.log("Error cloning provider " + id, e);
                }
            }
        }
        if (newProvider != null) {
            this.replaceSelectedProvider(newProvider);
            this.createOptionsPage(newProvider);
            this.displaySelectedOptionPage();
            this.updateButtons();
        } else {
            newProvider = provider;
        }
        return newProvider;
    }

    private void createSharedProviderCheckBox(Composite parent) {
        this.sharedProviderCheckBox = new Button(parent, 32);
        this.sharedProviderCheckBox.setText(Messages.LanguageSettingsProviderTab_ShareProviders);
        this.sharedProviderCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ILanguageSettingsProvider provider;
                boolean isGlobal = LanguageSettingsProviderTab.this.sharedProviderCheckBox.getSelection();
                if (isGlobal != LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)(provider = LanguageSettingsProviderTab.this.getSelectedProvider()))) {
                    provider = LanguageSettingsProviderTab.this.toggleGlobalProvider(provider, isGlobal);
                }
                LanguageSettingsProviderTab.this.projectStorageCheckBox.setSelection(provider instanceof LanguageSettingsSerializableProvider && LanguageSettingsManager.isStoringEntriesInProjectArea((LanguageSettingsSerializableProvider)((LanguageSettingsSerializableProvider)provider)));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createProjectStorageCheckBox(Composite parent) {
        this.projectStorageCheckBox = new Button(parent, 32);
        this.projectStorageCheckBox.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        this.projectStorageCheckBox.setText(Messages.LanguageSettingsProviderTab_StoreEntriesInsideProject);
        this.projectStorageCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean inProjectArea = LanguageSettingsProviderTab.this.projectStorageCheckBox.getSelection();
                ILanguageSettingsProvider newProvider = LanguageSettingsProviderTab.this.getWorkingCopy(LanguageSettingsProviderTab.this.getSelectedProvider().getId());
                LanguageSettingsManager.setStoringEntriesInProjectArea((LanguageSettingsSerializableProvider)((LanguageSettingsSerializableProvider)newProvider), (boolean)inProjectArea);
                LanguageSettingsProviderTab.this.replaceSelectedProvider(newProvider);
                LanguageSettingsProviderTab.this.createOptionsPage(newProvider);
                LanguageSettingsProviderTab.this.displaySelectedOptionPage();
                LanguageSettingsProviderTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createLinkToPreferences(final Composite parent, int span) {
        this.linkToWorkspacePreferences = new Link(parent, 0);
        String href = NLS.bind((String)"<a href=\"workspace\">{0}</a>", (Object)Messages.LanguageSettingsProviderTab_WorkspaceSettings);
        this.linkToWorkspacePreferences.setText(NLS.bind((String)Messages.LanguageSettingsProviderTab_OptionsCanBeChangedInPreferencesDiscoveryTab, (Object)href));
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        this.linkToWorkspacePreferences.setLayoutData((Object)gd);
        this.linkToWorkspacePreferences.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)LanguageSettingsProviderTab.WORKSPACE_PREFERENCE_PAGE, null, null).open();
            }
        });
    }

    private void createOptionsPane(Composite parent) {
        this.groupOptionsPage = new Group(parent, 16);
        this.groupOptionsPage.setText(Messages.LanguageSettingsProviderTab_LanguageSettingsProvidersOptions);
        this.groupOptionsPage.setLayout((Layout)new GridLayout(2, false));
        if (!this.page.isForPrefs()) {
            this.createSharedProviderCheckBox((Composite)this.groupOptionsPage);
            this.createProjectStorageCheckBox((Composite)this.groupOptionsPage);
            this.createLinkToPreferences((Composite)this.groupOptionsPage, 2);
        }
        Composite comp = new Composite((Composite)this.groupOptionsPage, 0);
        comp.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        this.compositeOptionsPage = new Composite(comp, 0);
        this.compositeOptionsPage.setLayout((Layout)new TabFolderLayout());
        this.compositeOptionsPage.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                LanguageSettingsProviderTab.this.compositeOptionsPage.setBounds(LanguageSettingsProviderTab.this.compositeOptionsPage.getParent().getClientArea());
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void createSashForm() {
        this.sashFormProviders = new SashForm(this.usercomp, 512);
        GridLayout layout = new GridLayout();
        this.sashFormProviders.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sashFormProviders.setLayoutData((Object)gd);
        this.createProvidersPane((Composite)this.sashFormProviders);
        this.createOptionsPane((Composite)this.sashFormProviders);
        this.sashFormProviders.setWeights(DEFAULT_CONFIGURE_SASH_WEIGHTS);
    }

    private void enableTabControls(boolean enable) {
        this.sashFormProviders.setEnabled(enable);
        this.tableProviders.setEnabled(enable);
        this.compositeOptionsPage.setEnabled(enable);
        this.buttoncomp.setEnabled(enable);
        if (enable) {
            this.displaySelectedOptionPage();
        } else {
            if (this.currentOptionsPage != null) {
                this.currentOptionsPage.setVisible(false);
            }
            this.buttonSetEnabled(0, false);
            this.buttonSetEnabled(1, false);
            this.buttonSetEnabled(3, false);
            this.buttonSetEnabled(4, false);
        }
    }

    @Override
    public void createControls(Composite parent) {
        String[] buttonLabels;
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout());
        GridData gd = (GridData)this.usercomp.getLayoutData();
        gd.heightHint = 1;
        if (this.page instanceof LanguageSettingsProvidersPage) {
            this.masterPropertyPage = (LanguageSettingsProvidersPage)this.page;
        }
        this.trackInitialSettings();
        this.createSashForm();
        this.fStatusLine = new StatusMessageLine(this.usercomp, 16384, 2);
        if (!this.page.isForPrefs() && !this.page.isMultiCfg()) {
            this.enableTabControls(this.masterPropertyPage.isLanguageSettingsProvidersEnabled());
        }
        if (this.page.isForPrefs()) {
            buttonLabels = new String[]{CLEAR_STR, RESET_STR};
        } else {
            buttonLabels = new String[5];
            buttonLabels[0] = CLEAR_STR;
            buttonLabels[1] = RESET_STR;
            buttonLabels[3] = MOVEUP_STR;
            buttonLabels[4] = MOVEDOWN_STR;
        }
        this.initButtons(buttonLabels);
        this.updateData(this.getResDesc());
    }

    private void performClear(ILanguageSettingsProvider selectedProvider) {
        if (this.isWorkingCopy(selectedProvider)) {
            if (selectedProvider instanceof LanguageSettingsSerializableProvider) {
                LanguageSettingsSerializableProvider editableProvider = (LanguageSettingsSerializableProvider)selectedProvider;
                editableProvider.clear();
                this.tableProvidersViewer.update((Object)selectedProvider, null);
            }
        } else {
            ILanguageSettingsEditableProvider newProvider;
            ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)selectedProvider);
            if (rawProvider instanceof ILanguageSettingsEditableProvider && (newProvider = LanguageSettingsManager.getProviderCopy((ILanguageSettingsEditableProvider)((ILanguageSettingsEditableProvider)rawProvider), (boolean)false)) != null) {
                this.replaceSelectedProvider((ILanguageSettingsProvider)newProvider);
                this.createOptionsPage((ILanguageSettingsProvider)newProvider);
                this.displaySelectedOptionPage();
            }
        }
        this.updateButtons();
    }

    private void performReset(ILanguageSettingsProvider selectedProvider) {
        String id = selectedProvider.getId();
        ILanguageSettingsProvider newProvider = null;
        if (this.page.isForPrefs()) {
            newProvider = LanguageSettingsManager.getExtensionProviderCopy((String)id, (boolean)true);
            if (newProvider == null) {
                Status status = new Status(4, "org.eclipse.cdt.ui", 4, Messages.GeneralMessages_InternalError_ReportLogToCdtTeam, (Throwable)new Exception("Internal Error getting copy of provider id=" + id));
                this.fStatusLine.setErrorStatus((IStatus)status);
                CUIPlugin.log((IStatus)status);
            }
        } else {
            ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
            String[] defaultIds = ((ILanguageSettingsProvidersKeeper)cfgDescription).getDefaultLanguageSettingsProvidersIds();
            boolean isDefault = Arrays.asList(defaultIds).contains(id);
            if (isDefault && !LanguageSettingsManager.isPreferShared((String)id)) {
                newProvider = LanguageSettingsManager.getExtensionProviderCopy((String)id, (boolean)true);
                if (newProvider == null) {
                    Status status = new Status(4, "org.eclipse.cdt.ui", 4, Messages.GeneralMessages_InternalError_ReportLogToCdtTeam, (Throwable)new Exception("Internal Error getting copy of provider id=" + id));
                    this.fStatusLine.setErrorStatus((IStatus)status);
                    CUIPlugin.log((IStatus)status);
                }
            } else {
                newProvider = LanguageSettingsManager.getWorkspaceProvider((String)id);
            }
            this.tableProvidersViewer.setChecked((Object)selectedProvider, isDefault);
        }
        if (newProvider != null) {
            this.replaceSelectedProvider(newProvider);
            this.createOptionsPage(newProvider);
            this.displaySelectedOptionPage();
            this.updateButtons();
        }
    }

    private void moveProvider(int oldPos, int newPos) {
        Collections.swap(this.presentedProviders, oldPos, newPos);
        this.tableProvidersViewer.refresh();
        this.tableProviders.showSelection();
        this.saveCheckedProviders();
        this.updateButtons();
    }

    private void performMoveUp(ILanguageSettingsProvider selectedProvider) {
        int pos = this.presentedProviders.indexOf(selectedProvider);
        if (pos > 0) {
            this.moveProvider(pos, pos - 1);
        }
    }

    private void performMoveDown(ILanguageSettingsProvider selectedProvider) {
        int pos = this.presentedProviders.indexOf(selectedProvider);
        int last = this.presentedProviders.size() - 1;
        if (pos >= 0 && pos < last) {
            this.moveProvider(pos, pos + 1);
        }
    }

    @Override
    public void buttonPressed(int buttonIndex) {
        ILanguageSettingsProvider selectedProvider = this.getSelectedProvider();
        switch (buttonIndex) {
            case 0: {
                this.performClear(selectedProvider);
                break;
            }
            case 1: {
                this.performReset(selectedProvider);
                break;
            }
            case 3: {
                this.performMoveUp(selectedProvider);
                break;
            }
            case 4: {
                this.performMoveDown(selectedProvider);
            }
        }
    }

    @Override
    protected void updateButtons() {
        boolean canClear;
        ILanguageSettingsProvider provider = this.getSelectedProvider();
        boolean isProviderSelected = provider != null;
        boolean canForWorkspace = isProviderSelected && this.page.isForPrefs();
        boolean canForProject = isProviderSelected && this.page.isForProject();
        int pos = this.tableProviders.getSelectionIndex();
        int count = this.tableProviders.getItemCount();
        int last = count - 1;
        boolean isRangeOk = pos >= 0 && pos <= last;
        ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
        boolean isAllowedClearing = rawProvider instanceof ILanguageSettingsEditableProvider && rawProvider instanceof LanguageSettingsSerializableProvider && LanguageSettingsProviderAssociationManager.isAllowedToClear(rawProvider);
        boolean bl = canClear = isAllowedClearing && (canForWorkspace || canForProject && !LanguageSettingsManager.isWorkspaceProvider((ILanguageSettingsProvider)provider));
        if (rawProvider instanceof LanguageSettingsSerializableProvider) {
            canClear = canClear && !((LanguageSettingsSerializableProvider)rawProvider).isEmpty();
        }
        boolean canResetForProject = canForProject && this.isReconfiguredForProject(provider);
        boolean canResetForWorkspace = canForWorkspace && rawProvider instanceof ILanguageSettingsEditableProvider && !LanguageSettingsManager.isEqualExtensionProvider((ILanguageSettingsProvider)rawProvider, (boolean)false) && LanguageSettingsManager.getExtensionProviderIds().contains(rawProvider.getId());
        boolean canReset = canResetForProject || canResetForWorkspace;
        boolean canMoveUp = canForProject && isRangeOk && pos != 0;
        boolean canMoveDown = canForProject && isRangeOk && pos != last;
        this.buttonSetEnabled(0, canClear);
        this.buttonSetEnabled(1, canReset);
        this.buttonSetEnabled(3, canMoveUp);
        this.buttonSetEnabled(4, canMoveDown);
    }

    private void sortByName(List<ILanguageSettingsProvider> providers) {
        Collections.sort(providers, new Comparator<ILanguageSettingsProvider>(){

            @Override
            public int compare(ILanguageSettingsProvider prov1, ILanguageSettingsProvider prov2) {
                Boolean isTest2;
                Boolean isTest1 = prov1.getId().matches(LanguageSettingsProviderTab.TEST_PLUGIN_ID_PATTERN);
                int result = isTest1.compareTo(isTest2 = Boolean.valueOf(prov2.getId().matches(LanguageSettingsProviderTab.TEST_PLUGIN_ID_PATTERN)));
                if (result == 0) {
                    String name1 = prov1.getName();
                    String name2 = prov2.getName();
                    if (name1 != null && name2 != null) {
                        result = name1.compareTo(name2);
                    }
                }
                return result;
            }
        });
    }

    private void initializeProviders() {
        ArrayList<ILanguageSettingsProvider> providers;
        ArrayList<String> idsList = new ArrayList<String>();
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            providers = new ArrayList(((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders());
            for (ILanguageSettingsProvider provider : providers) {
                idsList.add(provider.getId());
            }
        } else {
            providers = new ArrayList<ILanguageSettingsProvider>();
        }
        List allAvailableProvidersSet = LanguageSettingsManager.getWorkspaceProviders();
        this.sortByName(allAvailableProvidersSet);
        for (ILanguageSettingsProvider provider : allAvailableProvidersSet) {
            String id = provider.getId();
            if (idsList.contains(id) || !ScannerDiscoveryLegacySupport.isProviderCompatible((String)id, (ICConfigurationDescription)cfgDescription)) continue;
            providers.add(provider);
            idsList.add(id);
        }
        this.presentedProviders = providers;
        ILanguageSettingsProvider selectedProvider = this.getSelectedProvider();
        String selectedId = selectedProvider != null ? selectedProvider.getId() : null;
        this.tableProvidersViewer.setInput(this.presentedProviders);
        if (selectedId != null) {
            int i = 0;
            while (i < this.presentedProviders.size()) {
                if (selectedId.equals(this.presentedProviders.get(i).getId())) {
                    this.tableProviders.setSelection(i);
                    break;
                }
                ++i;
            }
        }
    }

    private ICOptionPage getOptionsPage(ILanguageSettingsProvider provider) {
        ICOptionPage optionsPage = null;
        if (provider != null) {
            ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
            if (rawProvider != null) {
                optionsPage = LanguageSettingsProviderAssociationManager.createOptionsPage(rawProvider);
            }
            if (optionsPage instanceof AbstractLanguageSettingProviderOptionPage) {
                ((AbstractLanguageSettingProviderOptionPage)optionsPage).init(this, provider.getId());
            }
        }
        return optionsPage;
    }

    private void createOptionsPage(ILanguageSettingsProvider provider) {
        ICOptionPage optionsPage = this.getOptionsPage(provider);
        if (optionsPage != null) {
            ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
            boolean isEditableForProject = this.page.isForProject() && provider instanceof ILanguageSettingsEditableProvider;
            boolean isEditableForPrefs = this.page.isForPrefs() && rawProvider instanceof ILanguageSettingsEditableProvider;
            boolean isEditable = isEditableForProject || isEditableForPrefs;
            this.compositeOptionsPage.setEnabled(isEditable);
            String id = provider != null ? provider.getId() : null;
            this.optionsPageMap.put(id, optionsPage);
            optionsPage.setContainer(this.page);
            optionsPage.createControl(this.compositeOptionsPage);
            optionsPage.setVisible(false);
            this.compositeOptionsPage.layout(true);
        }
    }

    private void displaySelectedOptionPage() {
        ILanguageSettingsProvider provider;
        if (this.currentOptionsPage != null) {
            this.currentOptionsPage.setVisible(false);
        }
        String id = (provider = this.getSelectedProvider()) != null ? provider.getId() : null;
        ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
        this.currentOptionsPage = this.optionsPageMap.get(id);
        if (!this.page.isForPrefs()) {
            boolean isChecked = this.tableProvidersViewer.getChecked((Object)provider);
            boolean isShared = this.isPresentedAsShared(provider);
            boolean isRawProviderEditable = rawProvider instanceof ILanguageSettingsEditableProvider;
            this.sharedProviderCheckBox.setVisible(provider != null);
            this.sharedProviderCheckBox.setEnabled(isChecked && isRawProviderEditable);
            this.sharedProviderCheckBox.setSelection(isShared);
            this.projectStorageCheckBox.setVisible(rawProvider instanceof LanguageSettingsSerializableProvider);
            this.projectStorageCheckBox.setEnabled(isChecked && !isShared);
            this.projectStorageCheckBox.setSelection(provider instanceof LanguageSettingsSerializableProvider && LanguageSettingsManager.isStoringEntriesInProjectArea((LanguageSettingsSerializableProvider)((LanguageSettingsSerializableProvider)provider)));
            this.linkToWorkspacePreferences.setVisible(isShared && this.currentOptionsPage != null);
            this.linkToWorkspacePreferences.setEnabled(isChecked);
        }
        if (this.currentOptionsPage != null) {
            this.currentOptionsPage.setVisible(true);
            boolean isEditableForProject = this.page.isForProject() && provider instanceof ILanguageSettingsEditableProvider;
            boolean isEditableForPrefs = this.page.isForPrefs() && rawProvider instanceof ILanguageSettingsEditableProvider;
            boolean isEditable = isEditableForProject || isEditableForPrefs;
            this.currentOptionsPage.getControl().setEnabled(isEditable);
            this.compositeOptionsPage.setEnabled(isEditable);
            this.compositeOptionsPage.layout(true);
        }
    }

    private void updateProvidersTable() {
        ILanguageSettingsProvider selectedProvider = this.getSelectedProvider();
        String selectedId = selectedProvider != null ? selectedProvider.getId() : null;
        boolean wasChecked = selectedProvider != null && this.tableProvidersViewer.getChecked((Object)selectedProvider);
        int pos = this.tableProviders.getSelectionIndex();
        this.tableProvidersViewer.setInput(this.presentedProviders);
        this.tableProviders.setSelection(pos);
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            List cfgProviders = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
            this.tableProvidersViewer.setCheckedElements((Object[])cfgProviders.toArray(new ILanguageSettingsProvider[0]));
        }
        if (selectedId != null) {
            int i = 0;
            while (i < this.presentedProviders.size()) {
                ILanguageSettingsProvider provider = this.presentedProviders.get(i);
                if (selectedId.equals(provider.getId())) {
                    boolean isChecked = this.tableProvidersViewer.getChecked((Object)provider);
                    if (isChecked || isChecked == wasChecked) {
                        this.tableProviders.setSelection(i);
                        break;
                    }
                    this.tableProviders.setSelection(0);
                    break;
                }
                ++i;
            }
        }
        this.tableProvidersViewer.refresh();
        this.optionsPageMap.clear();
        for (ILanguageSettingsProvider provider : this.presentedProviders) {
            this.createOptionsPage(provider);
        }
        this.displaySelectedOptionPage();
    }

    @Override
    public void updateData(ICResourceDescription rcDes) {
        String cfgId;
        if (!this.canBeVisible()) {
            return;
        }
        ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
        if (cfgDescription != null && !this.initialProvidersByCfg.containsKey(cfgId = cfgDescription.getId()) && cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
            List initialProviders = ((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders();
            this.initialProvidersByCfg.put(cfgId, initialProviders);
        }
        if (rcDes != null) {
            if (this.page.isMultiCfg()) {
                this.setAllVisible(false, null);
                return;
            }
            this.setAllVisible(true, null);
            if (this.masterPropertyPage != null) {
                boolean enabled = this.masterPropertyPage.isLanguageSettingsProvidersEnabled();
                this.enableTabControls(enabled);
            }
        }
        if (!this.page.isForPrefs() || this.presentedProviders == null) {
            this.initializeProviders();
        }
        this.updateProvidersTable();
        this.updateButtons();
    }

    @Override
    protected void performDefaults() {
        if (this.page.isForPrefs() || this.page.isForProject()) {
            if (MessageDialog.openQuestion((Shell)this.usercomp.getShell(), (String)Messages.LanguageSettingsProviderTab_TitleResetProviders, (String)Messages.LanguageSettingsProviderTab_AreYouSureToResetProviders)) {
                if (this.page.isForProject()) {
                    String[] defaultIds;
                    List newProviders;
                    ArrayList cfgProviders;
                    this.masterPropertyPage.setLanguageSettingsProvidersEnabled(ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(null));
                    ICConfigurationDescription cfgDescription = this.getConfigurationDescription();
                    if (cfgDescription instanceof ILanguageSettingsProvidersKeeper && !(cfgProviders = new ArrayList(((ILanguageSettingsProvidersKeeper)cfgDescription).getLanguageSettingProviders())).equals(newProviders = LanguageSettingsManager.createLanguageSettingsProviders((String[])(defaultIds = ((ILanguageSettingsProvidersKeeper)cfgDescription).getDefaultLanguageSettingsProvidersIds())))) {
                        ((ILanguageSettingsProvidersKeeper)cfgDescription).setLanguageSettingProviders(newProviders);
                    }
                } else if (this.page.isForPrefs()) {
                    this.presentedProviders = new ArrayList<ILanguageSettingsProvider>();
                    for (String id : LanguageSettingsManager.getExtensionProviderIds()) {
                        ILanguageSettingsProvider extProvider;
                        ILanguageSettingsProvider provider = LanguageSettingsManager.getWorkspaceProvider((String)id);
                        ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
                        if (!LanguageSettingsManager.isEqualExtensionProvider((ILanguageSettingsProvider)rawProvider, (boolean)true) && (extProvider = LanguageSettingsManager.getExtensionProviderCopy((String)id, (boolean)true)) != null) {
                            provider = extProvider;
                        }
                        this.presentedProviders.add(provider);
                    }
                    this.sortByName(this.presentedProviders);
                }
            }
            ICResourceDescription rcDescription = this.getResDesc();
            this.updateData(rcDescription);
            if (this.masterPropertyPage != null) {
                this.masterPropertyPage.informAll(4, rcDescription);
            }
        }
    }

    @Override
    protected void performApply(ICResourceDescription srcRcDescription, ICResourceDescription destRcDescription) {
        if (!this.page.isForPrefs()) {
            ICConfigurationDescription sd = srcRcDescription.getConfiguration();
            ICConfigurationDescription dd = destRcDescription.getConfiguration();
            if (sd instanceof ILanguageSettingsProvidersKeeper && dd instanceof ILanguageSettingsProvidersKeeper) {
                List newProviders = ((ILanguageSettingsProvidersKeeper)sd).getLanguageSettingProviders();
                ((ILanguageSettingsProvidersKeeper)dd).setLanguageSettingProviders(newProviders);
            }
        }
        this.performOK();
        this.trackInitialSettings();
        this.updateData(this.getResDesc());
    }

    @Override
    protected void performOK() {
        Collection<ICOptionPage> optionPages = this.optionsPageMap.values();
        for (ICOptionPage op : optionPages) {
            try {
                op.performApply(null);
            }
            catch (CoreException e) {
                CUIPlugin.log("Error applying options page", e);
            }
        }
        if (this.page.isForPrefs()) {
            try {
                LanguageSettingsManager.setWorkspaceProviders(this.presentedProviders);
            }
            catch (CoreException e) {
                CUIPlugin.log("Error setting user defined providers", e);
            }
            this.initializeProviders();
        }
        if (this.masterPropertyPage != null && this.masterPropertyPage.isLanguageSettingsProvidersEnabled()) {
            this.masterPropertyPage.applyLanguageSettingsProvidersEnabled();
        }
    }

    @Override
    public boolean canBeVisible() {
        if (!ScannerDiscoveryLegacySupport.isLanguageSettingsProvidersFunctionalityEnabled(null)) {
            return false;
        }
        return this.page.isForPrefs() || this.page.isForProject();
    }

    private class ProvidersTableLabelProvider
    extends LanguageSettingsProvidersLabelProvider {
        private ProvidersTableLabelProvider() {
        }

        @Override
        protected String[] getOverlayKeys(ILanguageSettingsProvider provider) {
            String[] overlayKeys = super.getOverlayKeys(provider);
            if (provider.getName() == null) {
                return overlayKeys;
            }
            if (LanguageSettingsProviderTab.this.page.isForProject()) {
                if (LanguageSettingsProviderTab.this.isEditedForProject(provider)) {
                    overlayKeys[1] = "icons/ovr16/edited_ovr.gif";
                } else if (!LanguageSettingsManager.getExtensionProviderIds().contains(provider.getId())) {
                    overlayKeys[1] = "icons/ovr16/person_ovr.gif";
                } else if (LanguageSettingsProviderTab.this.isReconfiguredForProject(provider)) {
                    overlayKeys[1] = "icons/tovr16/setting_nav.png";
                }
            } else if (LanguageSettingsProviderTab.this.page.isForPrefs()) {
                if (LanguageSettingsProviderTab.this.isWorkingCopy(provider) && !provider.equals(LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)LanguageSettingsManager.getWorkspaceProvider((String)provider.getId())))) {
                    overlayKeys[1] = "icons/ovr16/edited_ovr.gif";
                } else if (!LanguageSettingsManager.getExtensionProviderIds().contains(provider.getId())) {
                    overlayKeys[1] = "icons/ovr16/person_ovr.gif";
                } else {
                    ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)provider);
                    if (rawProvider instanceof ILanguageSettingsEditableProvider && !LanguageSettingsManager.isEqualExtensionProvider((ILanguageSettingsProvider)rawProvider, (boolean)false)) {
                        overlayKeys[1] = "icons/tovr16/setting_nav.png";
                    }
                }
            }
            return overlayKeys;
        }

        @Override
        public String getText(Object element) {
            ILanguageSettingsProvider provider;
            String name;
            if (element instanceof ILanguageSettingsProvider && (name = (provider = (ILanguageSettingsProvider)element).getName()) != null && (LanguageSettingsProviderTab.this.page.isForPrefs() || LanguageSettingsProviderTab.this.isPresentedAsShared(provider))) {
                return String.valueOf(name) + Messages.LanguageSettingsProvidersLabelProvider_TextDecorator_Shared;
            }
            return super.getText(element);
        }
    }
}

