/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;

public class XMLSourcePreferencePage
extends AbstractPreferencePage
implements ModifyListener,
SelectionListener,
IWorkbenchPreferencePage {
    private final int MIN_INDENTATION_SIZE = 0;
    private final int MAX_INDENTATION_SIZE = 16;
    protected Label fLineWidthLabel;
    protected Text fLineWidthText;
    protected Button fSplitMultiAttrs;
    private Button fIndentUsingTabs;
    private Button fIndentUsingSpaces;
    private Spinner fIndentationSize;
    private Button fPreservePCDATAContent;
    private Button fAlignEndBracket;
    private Button fFormatComments;
    private Button fFormatCommentsJoinLines;
    private Button fSpaceBeforeEmptyCloseTag;
    protected Button fClearAllBlankLines;
    protected Button fUseInferredGrammar;

    protected Control createContents(Composite parent) {
        Composite composite = super.createComposite(parent, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.xml.ui.webx0061");
        new PreferenceLinkArea(composite, 66, "org.eclipse.wst.sse.ui.preferences.editor", XMLUIMessages._UI_STRUCTURED_TEXT_EDITOR_PREFS_LINK, (IWorkbenchPreferenceContainer)this.getContainer(), null).getControl().setLayoutData((Object)GridDataFactory.fillDefaults().hint(150, -1).create());
        new Label(composite, 0).setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.createContentsForFormattingGroup(composite);
        this.createContentsForGrammarConstraintsGroup(composite);
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForFormattingGroup(Composite parent) {
        Group formattingGroup = this.createGroup(parent, 2);
        formattingGroup.setText(XMLUIMessages.Formatting_UI_);
        this.fLineWidthLabel = this.createLabel((Composite)formattingGroup, XMLUIMessages.Line_width__UI_);
        this.fLineWidthText = new Text((Composite)formattingGroup, 2052);
        GridData gData = new GridData(33);
        gData.widthHint = 25;
        this.fLineWidthText.setLayoutData((Object)gData);
        this.fLineWidthText.addModifyListener((ModifyListener)this);
        this.fSplitMultiAttrs = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Split_multiple_attributes);
        ((GridData)this.fSplitMultiAttrs.getLayoutData()).horizontalSpan = 2;
        this.fAlignEndBracket = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Align_final_bracket);
        ((GridData)this.fAlignEndBracket.getLayoutData()).horizontalSpan = 2;
        this.fPreservePCDATAContent = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Preserve_PCDATA_Content);
        ((GridData)this.fPreservePCDATAContent.getLayoutData()).horizontalSpan = 2;
        this.fClearAllBlankLines = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Clear_all_blank_lines_UI_);
        ((GridData)this.fClearAllBlankLines.getLayoutData()).horizontalSpan = 2;
        this.fFormatComments = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Format_comments);
        ((GridData)this.fFormatComments.getLayoutData()).horizontalSpan = 2;
        this.fFormatComments.addSelectionListener((SelectionListener)this);
        this.fFormatCommentsJoinLines = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Format_comments_join_lines);
        ((GridData)this.fFormatCommentsJoinLines.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.fFormatCommentsJoinLines.getLayoutData()).horizontalIndent = 20;
        this.fSpaceBeforeEmptyCloseTag = this.createCheckBox((Composite)formattingGroup, XMLUIMessages.Space_before_empty_close_tag);
        ((GridData)this.fSpaceBeforeEmptyCloseTag.getLayoutData()).horizontalSpan = 2;
        Composite indentComposite = this.createComposite((Composite)formattingGroup, 1);
        ((GridData)indentComposite.getLayoutData()).horizontalSpan = 2;
        ((GridLayout)indentComposite.getLayout()).marginWidth = 0;
        ((GridLayout)indentComposite.getLayout()).marginHeight = 0;
        this.fIndentUsingTabs = this.createRadioButton(indentComposite, XMLUIMessages.Indent_using_tabs);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 1;
        this.fIndentUsingSpaces = this.createRadioButton(indentComposite, XMLUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 1;
        this.createLabel((Composite)formattingGroup, XMLUIMessages.Indentation_size);
        this.fIndentationSize = new Spinner((Composite)formattingGroup, 2048);
        GridData gd = new GridData(32);
        this.fIndentationSize.setLayoutData((Object)gd);
        this.fIndentationSize.setToolTipText(XMLUIMessages.Indentation_size_tip);
        this.fIndentationSize.setMinimum(0);
        this.fIndentationSize.setMaximum(16);
        this.fIndentationSize.setIncrement(1);
        this.fIndentationSize.setPageIncrement(4);
        this.fIndentationSize.addModifyListener((ModifyListener)this);
    }

    protected void createContentsForGrammarConstraintsGroup(Composite parent) {
        Group grammarConstraintsGroup = this.createGroup(parent, 1);
        grammarConstraintsGroup.setText(XMLUIMessages.Grammar_Constraints);
        grammarConstraintsGroup.setLayoutData((Object)new GridData(768));
        this.fUseInferredGrammar = this.createCheckBox((Composite)grammarConstraintsGroup, XMLUIMessages.Use_inferred_grammar_in_absence_of);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    protected void doSavePreferenceStore() {
        XMLUIPlugin.getDefault().savePluginPreferences();
        XMLCorePlugin.getDefault().savePluginPreferences();
    }

    protected void enableValues() {
        if (this.fFormatComments != null && this.fFormatCommentsJoinLines != null) {
            this.fFormatCommentsJoinLines.setEnabled(this.fFormatComments.getSelection());
        }
    }

    protected Preferences getModelPreferences() {
        return XMLCorePlugin.getDefault().getPluginPreferences();
    }

    protected void initializeValues() {
        this.initializeValuesForFormattingGroup();
        this.initializeValuesForGrammarConstraintsGroup();
    }

    protected void initializeValuesForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getBoolean("clearAllBlankLines"));
        this.fPreservePCDATAContent.setSelection(this.getModelPreferences().getBoolean("preserveCDATAContent"));
        this.fSpaceBeforeEmptyCloseTag.setSelection(this.getModelPreferences().getBoolean("spaceBeforeEmptyCloseTag"));
        this.fFormatComments.setSelection(this.getModelPreferences().getBoolean("formatCommentText"));
        this.fFormatCommentsJoinLines.setSelection(this.getModelPreferences().getBoolean("formatCommentJoinLines"));
        if ("tab".equals(this.getModelPreferences().getString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getInt("indentationSize"));
    }

    protected void initializeValuesForGrammarConstraintsGroup() {
        this.fUseInferredGrammar.setSelection(this.getPreferenceStore().getBoolean(XMLUIPreferenceNames.USE_INFERRED_GRAMMAR));
    }

    protected void performDefaults() {
        this.performDefaultsForFormattingGroup();
        this.performDefaultsForGrammarConstraintsGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    protected void performDefaultsForFormattingGroup() {
        this.fLineWidthText.setText(this.getModelPreferences().getDefaultString("lineWidth"));
        this.fSplitMultiAttrs.setSelection(this.getModelPreferences().getDefaultBoolean("splitMultiAttrs"));
        this.fAlignEndBracket.setSelection(this.getModelPreferences().getDefaultBoolean("alignEndBracket"));
        this.fClearAllBlankLines.setSelection(this.getModelPreferences().getDefaultBoolean("clearAllBlankLines"));
        this.fPreservePCDATAContent.setSelection(this.getModelPreferences().getDefaultBoolean("preserveCDATAContent"));
        this.fSpaceBeforeEmptyCloseTag.setSelection(this.getModelPreferences().getDefaultBoolean("spaceBeforeEmptyCloseTag"));
        this.fFormatComments.setSelection(this.getModelPreferences().getDefaultBoolean("formatCommentText"));
        this.fFormatCommentsJoinLines.setSelection(this.getModelPreferences().getDefaultBoolean("formatCommentJoinLines"));
        if ("tab".equals(this.getModelPreferences().getDefaultString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getModelPreferences().getDefaultInt("indentationSize"));
    }

    protected void performDefaultsForGrammarConstraintsGroup() {
        this.fUseInferredGrammar.setSelection(this.getPreferenceStore().getDefaultBoolean(XMLUIPreferenceNames.USE_INFERRED_GRAMMAR));
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }

    protected void storeValues() {
        this.storeValuesForFormattingGroup();
        this.storeValuesForGrammarConstraintsGroup();
    }

    protected void storeValuesForFormattingGroup() {
        this.getModelPreferences().setValue("lineWidth", this.fLineWidthText.getText());
        this.getModelPreferences().setValue("splitMultiAttrs", this.fSplitMultiAttrs.getSelection());
        this.getModelPreferences().setValue("alignEndBracket", this.fAlignEndBracket.getSelection());
        this.getModelPreferences().setValue("clearAllBlankLines", this.fClearAllBlankLines.getSelection());
        this.getModelPreferences().setValue("preserveCDATAContent", this.fPreservePCDATAContent.getSelection());
        this.getModelPreferences().setValue("spaceBeforeEmptyCloseTag", this.fSpaceBeforeEmptyCloseTag.getSelection());
        this.getModelPreferences().setValue("formatCommentText", this.fFormatComments.getSelection());
        this.getModelPreferences().setValue("formatCommentJoinLines", this.fFormatCommentsJoinLines.getSelection());
        if (this.fIndentUsingTabs.getSelection()) {
            this.getModelPreferences().setValue("indentationChar", "tab");
        } else {
            this.getModelPreferences().setValue("indentationChar", "space");
        }
        this.getModelPreferences().setValue("indentationSize", this.fIndentationSize.getSelection());
    }

    protected void storeValuesForGrammarConstraintsGroup() {
        this.getPreferenceStore().setValue(XMLUIPreferenceNames.USE_INFERRED_GRAMMAR, this.fUseInferredGrammar.getSelection());
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfexc) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        int indentSize = 0;
        if (this.fIndentationSize != null) {
            try {
                indentSize = this.fIndentationSize.getSelection();
                if (indentSize < 0 || indentSize > 16) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfexc) {
                this.setInvalidInputMessage(Integer.toString(indentSize));
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }
}

