/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ErrorPreferencePage;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExtensionNode;
import org.eclipse.ui.statushandlers.StatusManager;

public class WorkbenchPreferenceNode
extends WorkbenchPreferenceExtensionNode {
    private static Map<String, Integer> reservedPreferenceNodeId;

    public WorkbenchPreferenceNode(String nodeId, IConfigurationElement element) {
        super(nodeId, element);
        reservedPreferenceNodeId = new HashMap<String, Integer>();
        reservedPreferenceNodeId.put("org.tizen.common.preferences.tizencommon", new Integer(-100));
        reservedPreferenceNodeId.put("org.eclipse.cdt.ui.preferences.CPluginPreferencePage", new Integer(-99));
        reservedPreferenceNodeId.put("org.eclipse.wst.html.ui.preferences.web", new Integer(-98));
        reservedPreferenceNodeId.put("org.eclipse.ui.preferencePages.Workbench", new Integer(-97));
        reservedPreferenceNodeId.put("org.tizen.common.preferences.others", new Integer(-96));
    }

    public void createPage() {
        IWorkbenchPreferencePage page;
        try {
            page = (IWorkbenchPreferencePage)WorkbenchPlugin.createExtension(this.getConfigurationElement(), "class");
        }
        catch (CoreException e) {
            IStatus errStatus = StatusUtil.newStatus(e.getStatus(), WorkbenchMessages.PreferenceNode_errorMessage);
            StatusManager.getManager().handle(errStatus, 3);
            page = new ErrorPreferencePage();
        }
        page.init(PlatformUI.getWorkbench());
        if (this.getLabelImage() != null) {
            page.setImageDescriptor(this.getImageDescriptor());
        }
        page.setTitle(this.getLabelText());
        this.setPage(page);
    }

    public String getCategory() {
        String categoryId = this.getConfigurationElement().getAttribute("category");
        if (categoryId == null && !reservedPreferenceNodeId.containsKey(this.getId())) {
            return "org.tizen.common.preferences.others";
        }
        return categoryId;
    }
}

