/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ExceptionHandler;

public class WidgetMethodHandler
extends AbstractHandler
implements IExecutableExtension {
    protected static final Class[] NO_PARAMETERS = new Class[0];
    protected String methodName;
    private Listener focusListener;
    private Display display = Display.getCurrent();

    public WidgetMethodHandler() {
        if (this.display != null) {
            this.focusListener = event -> this.updateEnablement();
            this.display.addFilter(15, this.focusListener);
        }
    }

    void updateEnablement() {
        boolean rc = this.isHandled();
        if (rc != this.isEnabled()) {
            this.setBaseEnabled(rc);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block9: {
            Method methodToExecute = this.getMethodToExecute();
            if (methodToExecute != null) {
                try {
                    Control focusControl = Display.getCurrent().getFocusControl();
                    if (focusControl instanceof Composite && (((Composite)focusControl).getStyle() & 0x1000000) != 0) {
                        try {
                            Object focusComponent = this.getFocusComponent();
                            if (focusComponent != null) {
                                Runnable methodRunnable = () -> {
                                    try {
                                        methodToExecute.invoke(focusComponent, new Object[0]);
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                    }
                                    catch (InvocationTargetException e2) {
                                        focusControl.getDisplay().asyncExec(() -> ExceptionHandler.getInstance().handleException(new ExecutionException("An exception occurred while executing " + methodToExecute.getName(), e2.getTargetException())));
                                    }
                                };
                                this.swingInvokeLater(methodRunnable);
                            }
                            break block9;
                        }
                        catch (ClassNotFoundException focusComponent) {
                            break block9;
                        }
                        catch (NoSuchMethodException e) {
                            throw new Error("Something is seriously wrong here");
                        }
                    }
                    methodToExecute.invoke((Object)focusControl, new Object[0]);
                }
                catch (IllegalAccessException focusControl) {
                }
                catch (InvocationTargetException e) {
                    throw new ExecutionException("An exception occurred while executing " + methodToExecute.getName(), e.getTargetException());
                }
            }
        }
        return null;
    }

    protected void swingInvokeLater(Runnable methodRunnable) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> swingUtilitiesClass = Class.forName("javax.swing.SwingUtilities");
        Method swingUtilitiesInvokeLaterMethod = swingUtilitiesClass.getMethod("invokeLater", Runnable.class);
        swingUtilitiesInvokeLaterMethod.invoke(swingUtilitiesClass, methodRunnable);
    }

    protected Object getFocusComponent() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> keyboardFocusManagerClass = null;
        try {
            keyboardFocusManagerClass = Class.forName("java.awt.KeyboardFocusManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (keyboardFocusManagerClass != null) {
            Method keyboardFocusManagerGetCurrentKeyboardFocusManagerMethod = keyboardFocusManagerClass.getMethod("getCurrentKeyboardFocusManager", new Class[0]);
            Object keyboardFocusManager = keyboardFocusManagerGetCurrentKeyboardFocusManagerMethod.invoke(keyboardFocusManagerClass, new Object[0]);
            Method keyboardFocusManagerGetFocusOwner = keyboardFocusManagerClass.getMethod("getFocusOwner", new Class[0]);
            Object focusComponent = keyboardFocusManagerGetFocusOwner.invoke(keyboardFocusManager, new Object[0]);
            return focusComponent;
        }
        Class<?> focusManagerClass = Class.forName("javax.swing.FocusManager");
        Method focusManagerGetCurrentManagerMethod = focusManagerClass.getMethod("getCurrentManager", new Class[0]);
        Object focusManager = focusManagerGetCurrentManagerMethod.invoke(focusManagerClass, new Object[0]);
        Method focusManagerGetFocusOwner = focusManagerClass.getMethod("getFocusOwner", new Class[0]);
        Object focusComponent = focusManagerGetFocusOwner.invoke(focusManager, new Object[0]);
        return focusComponent;
    }

    public final boolean isHandled() {
        return this.getMethodToExecute() != null;
    }

    protected Method getMethodToExecute() {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Control focusControl = display.getFocusControl();
        Method method = null;
        if (focusControl != null) {
            Class<?> clazz = focusControl.getClass();
            try {
                method = clazz.getMethod(this.methodName, NO_PARAMETERS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (method == null && focusControl instanceof Composite && (((Composite)focusControl).getStyle() & 0x1000000) != 0) {
            try {
                Object focusComponent = this.getFocusComponent();
                if (focusComponent != null) {
                    Class<?> clazz = focusComponent.getClass();
                    try {
                        method = clazz.getMethod(this.methodName, NO_PARAMETERS);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            catch (ClassNotFoundException focusComponent) {
            }
            catch (NoSuchMethodException e) {
                throw new Error("Something is seriously wrong here");
            }
            catch (IllegalAccessException e) {
                throw new Error("Something is seriously wrong here");
            }
            catch (InvocationTargetException e) {
                throw new Error("Something is seriously wrong here");
            }
        }
        return method;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.methodName = data.toString();
    }

    public void dispose() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.removeFilter(15, this.focusListener);
        }
        this.display = null;
        this.focusListener = null;
    }
}

