/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;

public class PrimitiveType
extends Type {
    public static final Code INT = new Code("int");
    public static final Code CHAR = new Code("char");
    public static final Code BOOLEAN = new Code("boolean");
    public static final Code SHORT = new Code("short");
    public static final Code LONG = new Code("long");
    public static final Code FLOAT = new Code("float");
    public static final Code DOUBLE = new Code("double");
    public static final Code BYTE = new Code("byte");
    public static final Code ANY_CODE = new Code("any");
    public static final Code VOID = new Code("void");
    private Code typeCode = INT;
    private static final Map CODES = new HashMap(20);
    public static final SimplePropertyDescriptor PRIMITIVE_TYPE_CODE_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS;

    static {
        Code[] ops = new Code[]{INT, BYTE, CHAR, BOOLEAN, SHORT, LONG, FLOAT, DOUBLE, VOID, ANY_CODE};
        int i = 0;
        while (i < ops.length) {
            CODES.put(ops[i].toString(), ops[i]);
            ++i;
        }
        PRIMITIVE_TYPE_CODE_PROPERTY = new SimplePropertyDescriptor(PrimitiveType.class, "primitiveTypeCode", Code.class, true);
        ArrayList propertyList = new ArrayList(2);
        PrimitiveType.createPropertyList(PrimitiveType.class, propertyList);
        PrimitiveType.addProperty(PRIMITIVE_TYPE_CODE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = PrimitiveType.reapPropertyList(propertyList);
    }

    public static Code toCode(String token) {
        return (Code)CODES.get(token);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public static PrimitiveType createAnyType(AST ast) {
        PrimitiveType type = new PrimitiveType(ast);
        type.setPrimitiveTypeCode(ANY_CODE);
        return type;
    }

    PrimitiveType(AST ast) {
        super(ast);
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return PrimitiveType.propertyDescriptors(apiLevel);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == PRIMITIVE_TYPE_CODE_PROPERTY) {
            if (get) {
                return this.getPrimitiveTypeCode();
            }
            this.setPrimitiveTypeCode((Code)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    final int getNodeType0() {
        return 39;
    }

    ASTNode clone0(AST target) {
        PrimitiveType result = new PrimitiveType(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setPrimitiveTypeCode(this.getPrimitiveTypeCode());
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public Code getPrimitiveTypeCode() {
        return this.typeCode;
    }

    public void setPrimitiveTypeCode(Code typeCode) {
        if (typeCode == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(PRIMITIVE_TYPE_CODE_PROPERTY);
        this.typeCode = typeCode;
        this.postValueChange(PRIMITIVE_TYPE_CODE_PROPERTY);
    }

    int memSize() {
        return 44;
    }

    int treeSize() {
        return this.memSize();
    }

    public static class Code {
        private String name;

        Code(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

