/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceMapper;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class JavaElement
extends PlatformObject
implements IJavaScriptElement {
    private static final byte[] CLOSING_DOUBLE_QUOTE = new byte[]{34};
    private static final byte[] CHARSET = new byte[]{99, 104, 97, 114, 115, 101, 116, 61};
    private static final byte[] CONTENT_TYPE = new byte[]{34, 67, 111, 110, 116, 101, 110, 116, 45, 84, 121, 112, 101, 34};
    private static final byte[] CONTENT = new byte[]{99, 111, 110, 116, 101, 110, 116, 61, 34};
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_JAVAPROJECT = '=';
    public static final char JEM_PACKAGEFRAGMENTROOT = '/';
    public static final char JEM_PACKAGEFRAGMENT = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_INITIALIZER = '|';
    public static final char JEM_COMPILATIONUNIT = '{';
    public static final char JEM_CLASSFILE = '(';
    public static final char JEM_METADATA = '&';
    public static final char JEM_TYPE = '[';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public static final char JEM_TYPE_PARAMETER = ']';
    protected JavaElement parent;
    protected static final JavaElement[] NO_ELEMENTS = new JavaElement[0];
    protected static final Object NO_INFO = new Object();

    protected JavaElement(JavaElement parent) throws IllegalArgumentException {
        this.parent = parent;
    }

    public void close() throws JavaScriptModelException {
        JavaModelManager.getJavaModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws JavaScriptModelException;

    protected abstract Object createElementInfo();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        JavaElement other = (JavaElement)o;
        return this.getElementName().equals(other.getElementName()) && this.parent.equals(other.parent);
    }

    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '%': 
                case '(': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '~': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }

    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }

    public ASTNode findNode(JavaScriptUnit ast) {
        return null;
    }

    protected abstract void generateInfos(Object var1, HashMap var2, IProgressMonitor var3) throws JavaScriptModelException;

    public IJavaScriptElement getAncestor(int ancestorType) {
        IJavaScriptElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public IJavaScriptElement[] getChildren() throws JavaScriptModelException {
        Object elementInfo = this.getElementInfo();
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    public ArrayList getChildrenOfType(int type) throws JavaScriptModelException {
        IJavaScriptElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<JavaElement> list = new ArrayList<JavaElement>(size);
        int i = 0;
        while (i < size) {
            JavaElement elt = (JavaElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public IClassFile getClassFile() {
        return null;
    }

    public IJavaScriptUnit getCompilationUnit() {
        return this.getJavaScriptUnit();
    }

    public IJavaScriptUnit getJavaScriptUnit() {
        return null;
    }

    public Object getElementInfo() throws JavaScriptModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws JavaScriptModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    public String getElementName() {
        return "";
    }

    public abstract IJavaScriptElement getHandleFromMemento(String var1, MementoTokenizer var2, WorkingCopyOwner var3);

    public IJavaScriptElement getHandleFromMemento(MementoTokenizer memento, WorkingCopyOwner owner) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento, owner);
    }

    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer();
        this.getHandleMemento(buff);
        return buff.toString();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    public IJavaScriptModel getJavaScriptModel() {
        IJavaScriptElement current = this;
        do {
            if (!(current instanceof IJavaScriptModel)) continue;
            return (IJavaScriptModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IJavaScriptProject getJavaScriptProject() {
        IJavaScriptElement current = this;
        do {
            if (!(current instanceof IJavaScriptProject)) continue;
            return (IJavaScriptProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    public IJavaScriptElement getParent() {
        return this.parent;
    }

    public IJavaScriptElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    protected IJavaScriptElement getSourceElementAt(int position) throws JavaScriptModelException {
        if (this instanceof ISourceReference) {
            IJavaScriptElement[] children = this.getChildren();
            int i = children.length - 1;
            while (i >= 0) {
                IJavaScriptElement aChild = children[i];
                if (aChild instanceof SourceRefElement) {
                    SourceRefElement child = (SourceRefElement)children[i];
                    ISourceRange range = child.getSourceRange();
                    int start = range.getOffset();
                    int end = start + range.getLength();
                    if (start <= position && position <= end) {
                        if (child instanceof IField) {
                            int declarationStart = start;
                            SourceRefElement candidate = null;
                            do {
                                if (position > (range = ((IField)((Object)child)).getNameRange()).getOffset() + range.getLength()) {
                                    return candidate == null ? child.getSourceElementAt(position) : candidate.getSourceElementAt(position);
                                }
                                candidate = child;
                                SourceRefElement sourceRefElement = child = --i >= 0 ? (SourceRefElement)children[i] : null;
                            } while (child != null && child.getSourceRange().getOffset() == declarationStart);
                            return candidate.getSourceElementAt(position);
                        }
                        if (child instanceof IParent) {
                            return child.getSourceElementAt(position);
                        }
                        return child;
                    }
                }
                --i;
            }
        } else {
            Assert.isTrue((boolean)false);
        }
        return this;
    }

    public SourceMapper getSourceMapper() {
        return ((JavaElement)this.getParent()).getSourceMapper();
    }

    public ISchedulingRule getSchedulingRule() {
        IResource resource = this.getResource();
        if (resource == null) {
            class NoResourceSchedulingRule
            implements ISchedulingRule {
                public IPath path;

                public NoResourceSchedulingRule(IPath path) {
                    this.path = path;
                }

                public boolean contains(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        return this.path.isPrefixOf(((NoResourceSchedulingRule)rule).path);
                    }
                    return false;
                }

                public boolean isConflicting(ISchedulingRule rule) {
                    if (rule instanceof NoResourceSchedulingRule) {
                        IPath otherPath = ((NoResourceSchedulingRule)rule).path;
                        return this.path.isPrefixOf(otherPath) || otherPath.isPrefixOf(this.path);
                    }
                    return false;
                }
            }
            return new NoResourceSchedulingRule(this.getPath());
        }
        return resource;
    }

    public boolean hasChildren() throws JavaScriptModelException {
        Object elementInfo = JavaModelManager.getJavaModelManager().getInfo(this);
        if (elementInfo instanceof JavaElementInfo) {
            return ((JavaElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getElementName().hashCode(), this.parent.hashCode());
    }

    public boolean isAncestorOf(IJavaScriptElement e) {
        IJavaScriptElement parentElement = e.getParent();
        while (parentElement != null && !parentElement.equals(this)) {
            parentElement = parentElement.getParent();
        }
        return parentElement != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public JavaScriptModelException newNotPresentException() {
        return new JavaScriptModelException(new JavaModelStatus(969, this));
    }

    public JavaScriptModelException newJavaModelException(IStatus status) {
        if (status instanceof IJavaScriptModelStatus) {
            return new JavaScriptModelException((IJavaScriptModelStatus)status);
        }
        return new JavaScriptModelException(new JavaModelStatus(status.getSeverity(), status.getCode(), status.getMessage()));
    }

    protected Object openWhenClosed(Object info, IProgressMonitor monitor) throws JavaScriptModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean hadTemporaryCache = manager.hasTemporaryCache();
        try {
            HashMap newElements = manager.getTemporaryCache();
            this.generateInfos(info, newElements, monitor);
            if (info == null) {
                info = newElements.get(this);
            }
            if (info == null) {
                Openable openable = (Openable)this.getOpenable();
                if (newElements.containsKey(openable)) {
                    openable.closeBuffer();
                }
                throw this.newNotPresentException();
            }
            if (!hadTemporaryCache) {
                manager.putInfos(this, newElements);
            }
        }
        finally {
            if (!hadTemporaryCache) {
                manager.resetTemporaryCache();
            }
        }
        return info;
    }

    public String readableName() {
        return this.getElementName();
    }

    public JavaElement resolved(Binding binding) {
        return this;
    }

    public JavaElement unresolved() {
        return this;
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, true);
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public String toStringWithAncestors() {
        return this.toStringWithAncestors(true);
    }

    public String toStringWithAncestors(boolean showResolvedInfo) {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, showResolvedInfo);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        JavaElement parentElement = (JavaElement)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO, false);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof JavaElementInfo)) {
            return;
        }
        IJavaScriptElement[] children = ((JavaElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((JavaElement)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info, true);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getElementName());
    }

    protected URL getJavadocBaseLocation() throws JavaScriptModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getAncestor(3);
        if (root == null) {
            return null;
        }
        if (root.getKind() == 2) {
            IIncludePathEntry entry = root.getRawIncludepathEntry();
            if (entry == null) {
                return null;
            }
            if (entry.getEntryKind() == 5 && (entry = JavaElement.getRealClasspathEntry(root.getJavaScriptProject(), entry.getPath(), root.getPath())) == null) {
                return null;
            }
            return JavaElement.getLibraryJavadocLocation(entry);
        }
        return null;
    }

    private static IIncludePathEntry getRealClasspathEntry(IJavaScriptProject jproject, IPath containerPath, IPath libPath) throws JavaScriptModelException {
        IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer(containerPath, jproject);
        if (container != null) {
            IIncludePathEntry[] entries = container.getIncludepathEntries();
            int i = 0;
            while (i < entries.length) {
                IIncludePathEntry curr = entries[i];
                if (curr == null) {
                    if (!JavaModelManager.CP_RESOLVE_VERBOSE) break;
                    JavaModelManager.getJavaModelManager().verbose_missbehaving_container(jproject, containerPath, entries);
                    break;
                }
                IIncludePathEntry resolved = JavaScriptCore.getResolvedIncludepathEntry(curr);
                if (resolved != null && libPath.equals((Object)resolved.getPath())) {
                    return curr;
                }
                ++i;
            }
        }
        return null;
    }

    protected static URL getLibraryJavadocLocation(IIncludePathEntry entry) throws JavaScriptModelException {
        switch (entry.getEntryKind()) {
            case 1: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Entry must be of kind CPE_LIBRARY or CPE_VARIABLE");
            }
        }
        IIncludePathAttribute[] extraAttributes = entry.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IIncludePathAttribute attrib = extraAttributes[i];
            if ("javadoc_location".equals(attrib.getName())) {
                String value = attrib.getValue();
                try {
                    return new URL(value);
                }
                catch (MalformedURLException e) {
                    throw new JavaScriptModelException(new JavaModelStatus(1008, value));
                }
            }
            ++i;
        }
        return null;
    }

    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaScriptModelException {
        return null;
    }

    int getIndexOf(byte[] array, byte[] toBeFound, int start) {
        if (array == null || toBeFound == null) {
            return -1;
        }
        int arrayLength = array.length;
        int toBeFoundLength = toBeFound.length;
        if (arrayLength < toBeFoundLength) {
            return -1;
        }
        int i = start;
        int max = arrayLength - toBeFoundLength + 1;
        while (i < max) {
            block6: {
                if (array[i] == toBeFound[0]) {
                    int j = 1;
                    while (j < toBeFoundLength) {
                        if (array[i + j] == toBeFound[j]) {
                            ++j;
                            continue;
                        }
                        break block6;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    protected String getURLContents(String docUrlValue) throws JavaScriptModelException {
        InputStream stream = null;
        JarURLConnection connection2 = null;
        try {
            int charsetIndex;
            int offset;
            int index2;
            int index;
            URL docUrl = new URL(docUrlValue);
            URLConnection connection = docUrl.openConnection();
            if (connection instanceof JarURLConnection) {
                connection2 = (JarURLConnection)connection;
                connection.setUseCaches(false);
            }
            stream = new BufferedInputStream(connection.getInputStream());
            String encoding = connection.getContentEncoding();
            byte[] contents = org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsByteArray(stream, connection.getContentLength());
            if (encoding == null && (index = this.getIndexOf(contents, CONTENT_TYPE, 0)) != -1 && (index = this.getIndexOf(contents, CONTENT, index)) != -1 && (index2 = this.getIndexOf(contents, CLOSING_DOUBLE_QUOTE, offset = index + CONTENT.length)) != -1 && (charsetIndex = this.getIndexOf(contents, CHARSET, offset)) != -1) {
                int start = charsetIndex + CHARSET.length;
                encoding = new String(contents, start, index2 - start, "UTF-8");
            }
            try {
                if (encoding == null) {
                    encoding = this.getJavaScriptProject().getProject().getDefaultCharset();
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (contents != null) {
                if (encoding != null) {
                    String string = new String(contents, encoding);
                    return string;
                }
                String string = new String(contents);
                return string;
            }
        }
        catch (MalformedURLException e) {
            throw new JavaScriptModelException(new JavaModelStatus(1008, this));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            e.printStackTrace(writer);
            writer.flush();
            writer.close();
            throw new JavaScriptModelException(new JavaModelStatus(1008, (IJavaScriptElement)this, String.valueOf(stringWriter.getBuffer())));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (connection2 != null) {
                try {
                    connection2.getJarFile().close();
                }
                catch (IOException iOException) {
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        return null;
    }

    public NameLookup newNameLookup(IJavaScriptUnit[] workingCopies) throws JavaScriptModelException {
        return this.parent != null ? this.parent.newNameLookup(workingCopies) : this.getJavaScriptProject().newNameLookup(workingCopies);
    }

    public NameLookup newNameLookup(WorkingCopyOwner owner) throws JavaScriptModelException {
        return this.parent != null ? this.parent.newNameLookup(owner) : this.getJavaScriptProject().newNameLookup(owner);
    }

    public SearchableEnvironment newSearchableNameEnvironment(IJavaScriptUnit[] workingCopies) throws JavaScriptModelException {
        return this.parent != null ? this.parent.newSearchableNameEnvironment(workingCopies) : this.getJavaScriptProject().newSearchableNameEnvironment(workingCopies);
    }

    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaScriptModelException {
        return this.parent != null ? this.parent.newSearchableNameEnvironment(owner) : this.getJavaScriptProject().newSearchableNameEnvironment(owner);
    }

    public String getDisplayName() {
        return this.getElementName();
    }

    public boolean isVirtual() {
        return this.parent.isVirtual();
    }

    public URI getHostPath() {
        if (this.isVirtual()) {
            return this.parent.getHostPath();
        }
        return null;
    }

    public LibrarySuperType getCommonSuperType() {
        return null;
    }
}

