/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;

public class IndexSelector {
    IJavaScriptSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;

    public IndexSelector(IJavaScriptSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaScriptElement focus, boolean isPolymorphicSearch, IPath projectOrJarPath) {
        try {
            IJavaScriptModel model;
            IJavaScriptProject project;
            IIncludePathEntry[] focusEntries = null;
            if (isPolymorphicSearch) {
                JavaProject focusProject = (JavaProject)focus;
                focusEntries = focusProject.getExpandedClasspath();
            }
            if ((project = IndexSelector.getJavaProject(projectOrJarPath, model = focus.getJavaScriptModel())) != null) {
                return IndexSelector.canSeeFocus(focus, (JavaProject)project, focusEntries);
            }
            IJavaScriptProject[] allProjects = model.getJavaScriptProjects();
            int i = 0;
            int length = allProjects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                JavaProject otherProject = (JavaProject)allProjects[i];
                IIncludePathEntry entry = otherProject.getClasspathEntryFor(projectOrJarPath);
                if (entry != null && entry.getEntryKind() == 1 && IndexSelector.canSeeFocus(focus, otherProject, focusEntries)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaScriptElement focus, JavaProject javaProject, IIncludePathEntry[] focusEntriesForPolymorphicSearch) {
        try {
            IIncludePathEntry entry;
            int i;
            IPath focusPath;
            if (focus.equals(javaProject)) {
                return true;
            }
            if (focusEntriesForPolymorphicSearch != null) {
                IPath projectPath = javaProject.getProject().getFullPath();
                int i2 = 0;
                int length = focusEntriesForPolymorphicSearch.length;
                while (i2 < length) {
                    IIncludePathEntry entry2 = focusEntriesForPolymorphicSearch[i2];
                    if (entry2.getEntryKind() == 2 && entry2.getPath().equals((Object)projectPath)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (focus instanceof LibraryFragmentRoot || focus instanceof PackageFragmentRoot) {
                focusPath = focus.getPath();
                IIncludePathEntry[] entries = javaProject.getExpandedClasspath();
                i = 0;
                int length = entries.length;
                while (true) {
                    if (i >= length) {
                        if (!(focus instanceof LibraryFragmentRoot)) break;
                        return false;
                    }
                    entry = entries[i];
                    if ((entry.getEntryKind() == 1 || entry.getEntryKind() == 3) && entry.getPath().equals((Object)focusPath)) {
                        return true;
                    }
                    ++i;
                }
            }
            focusPath = null;
            focusPath = focus instanceof PackageFragmentRoot ? ((JavaProject)focus.getParent()).getProject().getFullPath() : ((JavaProject)focus).getProject().getFullPath();
            IIncludePathEntry[] entries = javaProject.getExpandedClasspath();
            i = 0;
            int length = entries.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeIndexLocations() {
        projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        manager = JavaModelManager.getJavaModelManager().getIndexManager();
        locations = new SimpleSet();
        focus = MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            i = 0;
            while (i < projectsAndJars.length) {
                locations.add(manager.computeIndexLocation(projectsAndJars[i]));
                ++i;
            }
        } else {
            try {
                length = projectsAndJars.length;
                projectsCanSeeFocus = new JavaProject[length];
                visitedProjects = new SimpleSet(length);
                projectIndex = 0;
                jarsToCheck = new SimpleSet(length);
                focusEntries = null;
                if (this.pattern instanceof MethodPattern) {
                    focusProject = focus instanceof LibraryFragmentRoot != false || focus instanceof PackageFragmentRoot != false ? (JavaProject)focus.getParent() : (JavaProject)focus;
                    focusEntries = focusProject.getExpandedClasspath();
                }
                model = JavaModelManager.getJavaModelManager().getJavaModel();
                i = 0;
                while (i < length) {
                    path = projectsAndJars[i];
                    project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        if (IndexSelector.canSeeFocus(focus, project, focusEntries)) {
                            locations.add(manager.computeIndexLocation(path));
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        jarsToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && jarsToCheck.elementSize > 0) {
                    entries = projectsCanSeeFocus[i].getResolvedClasspath();
                    j = entries.length;
                    while (--j >= 0) {
                        entry = entries[j];
                        if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                        locations.add(manager.computeIndexLocation(entry.getPath()));
                        jarsToCheck.remove(path);
                    }
                    ++i;
                }
                if (jarsToCheck.elementSize <= 0) ** GOTO lbl76
                allProjects = model.getJavaScriptProjects();
                i = 0;
                l = allProjects.length;
                while (i < l && jarsToCheck.elementSize > 0) {
                    project = (JavaProject)allProjects[i];
                    if (!visitedProjects.includes(project)) {
                        entries = project.getResolvedClasspath();
                        j = entries.length;
                        while (--j >= 0) {
                            entry = entries[j];
                            if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                            locations.add(manager.computeIndexLocation(entry.getPath()));
                            jarsToCheck.remove(path);
                        }
                    }
                    ++i;
                }
            }
            catch (JavaScriptModelException length) {
                // empty catch block
            }
        }
lbl76:
        // 4 sources

        this.indexLocations = new IPath[locations.elementSize];
        values = locations.values;
        count = 0;
        i = values.length;
        while (--i >= 0) {
            if (values[i] == null) continue;
            this.indexLocations[count++] = (IPath)values[i];
        }
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IJavaScriptProject getJavaProject(IPath path, IJavaScriptModel model) {
        IJavaScriptProject project = model.getJavaScriptProject(path.segment(0));
        if (project.exists()) {
            return project;
        }
        return null;
    }
}

