/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.util.DefaultSourcePathProvider;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.osgi.framework.Bundle;

public class ConvertUtility {
    private static final String[] NATURE_IDS = new String[]{"org.eclipse.wst.jsdt.core.jsNature"};
    private static final String SYSTEM_LIBRARY = "org.eclipse.wst.jsdt.launching.JRE_CONTAINER";
    private static final String SYSTEM_SUPER_TYPE_NAME = new String(IIndexConstants.GLOBAL);
    private static final String BROWSER_LIBRARY = "org.eclipse.wst.jsdt.launching.baseBrowserLibrary";
    public static final IPath BROWSER_LIBRARY_PATH = new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary");
    private static final String BROWSER_SUPER_TYPE_NAME = new String(IIndexConstants.WINDOW);
    public static final String VIRTUAL_CONTAINER = "org.eclipse.wst.jsdt.launching.WebProject";
    public static final IIncludePathEntry VIRTUAL_SCOPE_ENTRY = JavaScriptCore.newContainerEntry((IPath)new Path("org.eclipse.wst.jsdt.launching.WebProject"), new IAccessRule[0], new IIncludePathAttribute[]{IIncludePathAttribute.HIDE}, false);
    private boolean DEBUG = false;
    private IProject fCurrProject;
    private JavaProject fJavaProject;
    private IPath fOutputLocation;

    static void addJsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!ConvertUtility.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + NATURE_IDS.length];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            int i = 0;
            while (i < NATURE_IDS.length) {
                newNatures[prevNatures.length + i] = NATURE_IDS[i];
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasNature(IProject project) {
        try {
            int i = 0;
            while (true) {
                if (i >= NATURE_IDS.length) {
                    return true;
                }
                if (!project.hasNature(NATURE_IDS[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            return false;
        }
    }

    static void removeJsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (ConvertUtility.hasNature(project)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length - NATURE_IDS.length];
            int k = 0;
            int i = 0;
            while (i < prevNatures.length) {
                block7: {
                    int j = 0;
                    while (j < NATURE_IDS.length) {
                        if (!prevNatures[i].equals(NATURE_IDS[j])) {
                            ++j;
                            continue;
                        }
                        break block7;
                    }
                    newNatures[k++] = prevNatures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public ConvertUtility(IProject project) {
        this.fCurrProject = project;
        this.fOutputLocation = this.fCurrProject.getFullPath();
    }

    private IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor != null) {
            return monitor;
        }
        return new NullProgressMonitor();
    }

    public void addBrowserSupport(boolean changeSuperType, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor progressMonitor = this.monitorFor(monitor);
        progressMonitor.beginTask(Messages.converter_ConfiguringForBrowser, 2);
        this.fJavaProject = (JavaProject)JavaScriptCore.create(this.fCurrProject);
        if (!this.fJavaProject.exists()) {
            this.configure((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        this.fJavaProject.setProject(this.fCurrProject);
        IIncludePathEntry[] includePath = this.getRawClassPath();
        includePath = this.addEntry(includePath, VIRTUAL_SCOPE_ENTRY, false);
        includePath = this.addEntry(includePath, JavaScriptCore.newContainerEntry(BROWSER_LIBRARY_PATH), false);
        try {
            if (!this.hasProjectClassPathFile()) {
                this.fJavaProject.setRawIncludepath(includePath, this.fOutputLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                this.fJavaProject.setRawIncludepath(includePath, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (changeSuperType) {
            LibrarySuperType superType = new LibrarySuperType(BROWSER_LIBRARY_PATH, (IJavaScriptProject)this.getJavaScriptProject(), BROWSER_SUPER_TYPE_NAME);
            this.getJavaScriptProject().setCommonSuperType(superType);
        }
        progressMonitor.done();
    }

    private IIncludePathEntry[] addEntry(IIncludePathEntry[] entries, IIncludePathEntry newEntry, boolean first) {
        int i = 0;
        while (i < entries.length) {
            if (newEntry.getPath().equals((Object)entries[i].getPath())) {
                return entries;
            }
            ++i;
        }
        ArrayList<IIncludePathEntry> entriesList = new ArrayList<IIncludePathEntry>(Arrays.asList(entries));
        if (first && !entriesList.isEmpty()) {
            entriesList.add(0, newEntry);
        } else {
            entriesList.add(newEntry);
        }
        return entriesList.toArray(new IIncludePathEntry[entriesList.size()]);
    }

    private IIncludePathEntry[] addSystemEntry(IIncludePathEntry[] entries) {
        IIncludePathEntry defaultJRELibrary;
        block4: {
            defaultJRELibrary = this.createRuntimeEntry();
            try {
                int i = 0;
                while (i < entries.length) {
                    if (defaultJRELibrary.equals(entries[i])) {
                        return entries;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block4;
                System.out.println("Error checking system library in include path:" + e);
            }
        }
        return this.addEntry(entries, defaultJRELibrary, false);
    }

    public void configure(IProgressMonitor monitor) throws CoreException {
        IProgressMonitor progressMonitor = this.monitorFor(monitor);
        progressMonitor.beginTask("", 2);
        ConvertUtility.addJsNature(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        this.fJavaProject = (JavaProject)JavaScriptCore.create(this.fCurrProject);
        this.fJavaProject.setProject(this.fCurrProject);
        IIncludePathEntry[] includePath = this.getRawClassPath();
        includePath = this.addSystemEntry(includePath);
        try {
            if (!this.hasProjectClassPathFile()) {
                this.fJavaProject.setRawIncludepath(includePath, this.fOutputLocation, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                this.fJavaProject.setRawIncludepath(includePath, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        LibrarySuperType superType = new LibrarySuperType((IPath)new Path(SYSTEM_LIBRARY), (IJavaScriptProject)this.getJavaScriptProject(), SYSTEM_SUPER_TYPE_NAME);
        this.getJavaScriptProject().setCommonSuperType(superType);
        progressMonitor.done();
    }

    private IIncludePathEntry createRuntimeEntry() {
        return JavaScriptCore.newContainerEntry((IPath)new Path(SYSTEM_LIBRARY));
    }

    private JavaProject getJavaScriptProject() {
        if (this.fJavaProject == null) {
            this.fJavaProject = (JavaProject)JavaScriptCore.create(this.fCurrProject);
            this.fJavaProject.setProject(this.fCurrProject);
        }
        return this.fJavaProject;
    }

    public IProject getProject() {
        return this.fCurrProject;
    }

    public IIncludePathEntry[] getDefaultSourcePaths(IProject p) {
        IIncludePathEntry[] defaults;
        block10: {
            IPath[] defaultExclusionPatterns = JavaScriptCore.getJavaScriptCore().getDefaultClasspathExclusionPatterns();
            defaults = new IIncludePathEntry[]{JavaScriptCore.newSourceEntry(p.getFullPath(), defaultExclusionPatterns)};
            try {
                IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.jsdt.core.sourcePathProvider");
                HashMap<IPath, IIncludePathEntry> paths = new HashMap<IPath, IIncludePathEntry>();
                int i = 0;
                while (i < configurationElements.length) {
                    DefaultSourcePathProvider provider = (DefaultSourcePathProvider)configurationElements[i].createExecutableExtension("class");
                    if (provider != null) {
                        IIncludePathEntry[] defaultSourcePaths = provider.getDefaultSourcePaths(p);
                        int j = 0;
                        while (j < defaultSourcePaths.length) {
                            if (defaultSourcePaths[i] instanceof ClasspathEntry) {
                                ClasspathEntry cpe = (ClasspathEntry)defaultSourcePaths[i];
                                HashSet<IPath> exclusions = new HashSet<IPath>();
                                exclusions.addAll(Arrays.asList(cpe.getExclusionPatterns()));
                                exclusions.addAll(Arrays.asList(defaultExclusionPatterns));
                                IPath[] exclusionPatterns = exclusions.toArray(new IPath[exclusions.size()]);
                                defaultSourcePaths[i] = JavaScriptCore.newSourceEntry(cpe.getPath(), cpe.getInclusionPatterns(), exclusionPatterns, cpe.getOutputLocation(), cpe.getExtraAttributes());
                            }
                            paths.put(defaultSourcePaths[j].getPath(), defaultSourcePaths[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
                if (!paths.isEmpty()) {
                    IPath[] pathsArray = paths.keySet().toArray(new IPath[paths.size()]);
                    int i2 = 0;
                    while (i2 < pathsArray.length) {
                        int j = 0;
                        while (j < pathsArray.length) {
                            if (i2 != j && pathsArray[i2] != null && pathsArray[j] != null && pathsArray[j].isPrefixOf(pathsArray[i2]) && ((IIncludePathEntry)paths.get(pathsArray[i2])).getEntryKind() == ((IIncludePathEntry)paths.get(pathsArray[j])).getEntryKind()) {
                                paths.remove(pathsArray[j]);
                                pathsArray[j] = null;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    defaults = paths.values().toArray(new IIncludePathEntry[paths.size()]);
                    Arrays.sort(defaults, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            IIncludePathEntry entry1 = (IIncludePathEntry)o1;
                            IIncludePathEntry entry2 = (IIncludePathEntry)o2;
                            if (entry1.getEntryKind() == 3 && entry2.getEntryKind() != 3) {
                                return -1;
                            }
                            if (entry1.getEntryKind() != 3 && entry2.getEntryKind() == 3) {
                                return 1;
                            }
                            return entry1.getPath().toString().compareTo(entry2.getPath().toString());
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!Platform.inDebugMode()) break block10;
                Platform.getLog((Bundle)JavaScriptCore.getPlugin().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.jsdt.core", "Problem getting source paths", (Throwable)e));
            }
        }
        return defaults;
    }

    private IIncludePathEntry[] getRawClassPath() {
        JavaProject proj = new JavaProject();
        proj.setProject(this.fCurrProject);
        return proj.readRawIncludepath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAValidSourcePath() {
        if (!this.hasProjectClassPathFile()) return false;
        try {
            IIncludePathEntry[] entries = this.getRawClassPath();
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return false;
                }
                if (entries[i].getEntryKind() == 3) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            if (!this.DEBUG) return false;
            System.out.println("Error checking sourcepath:" + e);
        }
        return false;
    }

    private boolean hasProjectClassPathFile() {
        if (this.fCurrProject == null) {
            return false;
        }
        return this.fCurrProject.getFolder(".settings").getFile(".jsdtscope").exists();
    }
}

