/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.egit.ui.internal.synchronize.GitSynchronizeWizard;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class SynchronizeWithMenu
extends ContributionItem
implements IWorkbenchContribution {
    private static final int MAX_NUM_MENU_ENTRIES = 20;
    private final Image tagImage = UIIcons.TAG.createImage();
    private final Image branchImage = UIIcons.BRANCH.createImage();
    private ISelectionService srv;

    public SynchronizeWithMenu() {
        this(null);
    }

    public SynchronizeWithMenu(String id) {
        super(id);
    }

    public void fill(final Menu menu, int index) {
        String currentBranch;
        if (this.srv == null) {
            return;
        }
        final IResource selectedResource = this.getSelection();
        if (selectedResource == null || selectedResource.isLinked(512)) {
            return;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)selectedResource.getProject());
        if (mapping == null) {
            return;
        }
        final Repository repo = mapping.getRepository();
        if (repo == null) {
            return;
        }
        LinkedList refs = new LinkedList();
        RefDatabase refDatabase = repo.getRefDatabase();
        try {
            refs.addAll(refDatabase.getAdditionalRefs());
        }
        catch (IOException iOException) {}
        try {
            refs.addAll(refDatabase.getRefs("").values());
        }
        catch (IOException iOException) {}
        Collections.sort(refs, CommonUtils.REF_ASCENDING_COMPARATOR);
        try {
            currentBranch = repo.getFullBranch();
        }
        catch (IOException iOException) {
            currentBranch = "";
        }
        int count = 0;
        String oldName = null;
        int refsLength = "refs/".length();
        int tagsLength = "refs/tags/".substring(refsLength).length();
        for (Ref ref : refs) {
            final String name = ref.getName();
            if (name.equals("HEAD") || name.equals(currentBranch) || this.excludeTag(ref, repo)) continue;
            if (name.startsWith("refs/") && oldName != null && !oldName.regionMatches(refsLength, name, refsLength, tagsLength)) {
                new MenuItem(menu, 2);
            }
            MenuItem item = new MenuItem(menu, 8);
            item.setText(name);
            if (name.startsWith("refs/tags/")) {
                item.setImage(this.tagImage);
            } else if (name.startsWith("refs/heads/") || name.startsWith("refs/remotes/")) {
                item.setImage(this.branchImage);
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        GitSynchronizeData data = new GitSynchronizeData(repo, "HEAD", name, true);
                        if (!(selectedResource instanceof IProject)) {
                            HashSet<IResource> resources = new HashSet<IResource>();
                            resources.add(selectedResource);
                            data.setIncludedResources(resources);
                        }
                        GitModelSynchronize.launch(data, new IResource[]{selectedResource});
                    }
                    catch (IOException e) {
                        Activator.logError(e.getMessage(), e);
                    }
                }
            });
            if (++count == 20) break;
            oldName = name;
        }
        if (count > 1) {
            new MenuItem(menu, 2);
        }
        MenuItem custom = new MenuItem(menu, 8);
        custom.setText(UIText.SynchronizeWithMenu_custom);
        custom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitSynchronizeWizard gitWizard = new GitSynchronizeWizard();
                WizardDialog wizard = new WizardDialog(menu.getShell(), (IWizard)gitWizard);
                wizard.create();
                wizard.open();
            }
        });
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.srv = CommonUtils.getService(serviceLocator, ISelectionService.class);
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        this.tagImage.dispose();
        this.branchImage.dispose();
    }

    @Nullable
    private IResource getSelection() {
        ISelection sel = this.srv.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        Object selected = ((IStructuredSelection)sel).getFirstElement();
        return AdapterUtils.adaptToAnyResource((Object)selected);
    }

    private boolean excludeTag(Ref ref, Repository repo) {
        if (ref instanceof ObjectIdRef.PeeledTag) {
            RevWalk rw = new RevWalk(repo);
            try {
                RevTag tag = rw.parseTag((AnyObjectId)ref.getObjectId());
                boolean bl = !(rw.parseAny((AnyObjectId)tag.getObject()) instanceof RevCommit);
                return bl;
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
            finally {
                rw.close();
                rw.dispose();
            }
        }
        return false;
    }
}

