/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.jobs;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.action.Action;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;

public abstract class RepositoryJobResultAction
extends Action {
    private final File repositoryDir;
    private boolean repositoryGone;

    public RepositoryJobResultAction(@NonNull Repository repository, String title) {
        super(title);
        this.repositoryDir = repository.getDirectory();
    }

    public final void run() {
        Repository repo = null;
        if (!this.repositoryGone) {
            RepositoryCache repoCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
            repo = repoCache.getRepository(this.repositoryDir);
            if (repo == null && RepositoryCache.FileKey.isGitRepository((File)this.repositoryDir, (FS)FS.DETECTED)) {
                try {
                    repo = repoCache.lookupRepository(this.repositoryDir);
                }
                catch (IOException iOException) {}
            }
            boolean bl = this.repositoryGone = repo == null;
        }
        if (this.repositoryGone || repo == null) {
            Activator.showError(MessageFormat.format(UIText.RepositoryJobResultAction_RepositoryGone, this.repositoryDir), null);
            return;
        }
        this.showResult(repo);
    }

    protected abstract void showResult(@NonNull Repository var1);
}

