/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.pull;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.pull.PullOperationUI;
import org.eclipse.egit.ui.internal.pull.PullWizardPage;
import org.eclipse.egit.ui.internal.push.AddRemotePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class PullWizard
extends Wizard {
    private final Repository repository;
    private PullWizardPage page;
    private AddRemotePage addRemotePage;

    public PullWizard(Repository repo) {
        this.repository = repo;
        this.setWindowTitle(UIText.PullWizardPage_PageTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        Set remoteNames = this.repository.getConfig().getSubsections("remote");
        if (remoteNames.isEmpty()) {
            this.addRemotePage = new AddRemotePage(this.repository);
            this.addPage((IWizardPage)this.addRemotePage);
        }
        this.page = new PullWizardPage(this.repository);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            if (this.addRemotePage != null) {
                this.storeCredentials(this.addRemotePage);
                URIish uri = this.addRemotePage.getSelection().getURI();
                this.configureNewRemote(uri);
            }
            if (this.page.overrideUpstreamConfiguration()) {
                this.configureUpstream();
            }
            this.startPull();
            return true;
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            return false;
        }
        catch (URISyntaxException e) {
            Activator.logError(e.getMessage(), e);
            return false;
        }
    }

    private void storeCredentials(AddRemotePage remotePage) {
        URIish uri;
        if (remotePage.getStoreInSecureStore() && (uri = remotePage.getSelection().getURI()) != null) {
            SecureStoreUtils.storeCredentials(remotePage.getCredentials(), uri);
        }
    }

    private void configureNewRemote(URIish uri) throws URISyntaxException, IOException {
        StoredConfig config = this.repository.getConfig();
        String remoteName = this.page.getRemoteConfig().getName();
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, remoteName);
        remoteConfig.addURI(uri);
        RefSpec defaultFetchSpec = new RefSpec().setForceUpdate(true).setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
        remoteConfig.addFetchRefSpec(defaultFetchSpec);
        remoteConfig.update((Config)config);
        config.save();
    }

    private void configureUpstream() throws IOException {
        String fullBranch = this.repository.getFullBranch();
        if (fullBranch == null || !fullBranch.startsWith("refs/heads/")) {
            return;
        }
        String remoteName = this.page.getRemoteConfig().getName();
        String fullRemoteBranchName = this.page.getFullRemoteReference();
        String localBranchName = this.repository.getBranch();
        StoredConfig config = this.repository.getConfig();
        config.setString("branch", localBranchName, "remote", remoteName);
        config.setString("branch", localBranchName, "merge", fullRemoteBranchName);
        BranchConfig.BranchRebaseMode rebaseMode = this.page.getUpstreamConfig();
        if (rebaseMode != null) {
            config.setEnum("branch", localBranchName, "rebase", (Enum)rebaseMode);
        }
        config.save();
    }

    private void startPull() {
        HashMap<Repository, PullOperation.PullReferenceConfig> repos = new HashMap<Repository, PullOperation.PullReferenceConfig>(1);
        PullOperation.PullReferenceConfig config = new PullOperation.PullReferenceConfig(this.page.getRemoteConfig().getName(), this.page.getFullRemoteReference(), this.page.getUpstreamConfig());
        repos.put(this.repository, config);
        PullOperationUI pullOperationUI = new PullOperationUI(repos);
        pullOperationUI.start();
    }
}

