@ECHO OFF
set shortcut_name=Tizen Studio
set execute_file=TizenStudio.exe
set icon_file=tizen_studio.ico
set font_file=EcoSansMonoBD_110929.ttf
set program_path=%INSTALLED_PATH%\ide
set execute_path=%program_path%\%execute_file%
set icon_path=%program_path%\resources\icons
set font_path=%program_path%\resources\fonts
set subdir1=false

echo Setting shortcut...
wscript.exe "%MAKESHORTCUT_PATH%" /shortcut:"%shortcut_name%" /target:"%execute_path%" /icon:"%icon_path%\%icon_file%" /subdir1:"%subdir1%"
echo Make shortcut success.

echo Create init file...
set init_file=%program_path%\init

IF NOT EXIST "%init_file%" (
    fsutil file createnew "%program_path%\init" 1
)

echo Setting sdk version...
:: Set parameter
set ide_path=%INSTALLED_PATH%\ide
set config_file_path=%ide_path%\configuration\config.ini
set splash_version_parameter=eclipse.buildId
set emulator_version_path=%INSTALLED_PATH%\tools\emulator\etc

:: Get version
set version_path=%INSTALLED_PATH%\sdk.version
IF NOT EXIST "%version_path%" (
    exit
)

FOR /F "usebackq tokens=1,2* delims==" %%A IN ("%version_path%") DO (set %%A=%%B)

set tizen_sdk_version=%TIZEN_SDK_VERSION%

::set branding_plugin
set base_ide_platform_path=%ide_path%\plugins\org.tizen.product.plugin*
IF EXIST "%base_ide_platform_path%" (
    for /f %%R in ('dir /B /A:D /O:D "%base_ide_platform_path%"') do (set branding_plugin=%%R)
)
echo "branding plugin: %branding_plugin%"

set about_mapping_path=%ide_path%\plugins\%branding_plugin%\about.mappings
echo "about_mapping_path: %about_mapping_path%"

set about_version_parameter=1

echo "Set product's version (%tizen_sdk_version%)"
:: modify splash version
IF EXIST "%config_file_path%" (
    echo "modify config.ini"

    Type "%config_file_path%" | findstr /I /V /C:"%splash_version_parameter%=" > "%config_file_path%.modi"

    for %%^" in ("") do (echo %splash_version_parameter%=%%~"%tizen_sdk_version%%%~" >> "%config_file_path%.modi")

    del "%config_file_path%"

    move "%config_file_path%.modi" "%config_file_path%"
)

:: modify about dialog version
IF EXIST "%about_mapping_path%" (
    echo "modify about.mappings"

    Type "%about_mapping_path%" | findstr /I /V /C:"%about_version_parameter%=" > "%about_mapping_path%.modi"

    for %%^" in ("") do (echo %about_version_parameter%=%%~"%tizen_sdk_version%%%~" >> "%about_mapping_path%.modi")

    del "%about_mapping_path%"

    move "%about_mapping_path%.modi" "%about_mapping_path%"
)

exit 0
