/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultViewEntry;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.IActionGroupFactory;
import org.eclipse.search.ui.IContextMenuContributor;
import org.eclipse.search.ui.IGroupByKeyComputer;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.widgets.Shell;

@Deprecated
public class Search {
    private String fPageId;
    private String fSingularLabel;
    private String fPluralLabelPattern;
    private ImageDescriptor fImageDescriptor;
    private ILabelProvider fLabelProvider;
    private ISelection fSelection;
    private ArrayList<SearchResultViewEntry> fResults;
    private IAction fGotoMarkerAction;
    private IContextMenuContributor fContextMenuContributor;
    private IActionGroupFactory fActionGroupFactory;
    private IGroupByKeyComputer fGroupByKeyComputer;
    private IRunnableWithProgress fOperation;

    public Search(String pageId, String singularLabel, String pluralLabelPattern, ILabelProvider labelProvider, ImageDescriptor imageDescriptor, IAction gotoMarkerAction, IActionGroupFactory groupFactory, IGroupByKeyComputer groupByKeyComputer, IRunnableWithProgress operation) {
        this.fPageId = pageId;
        this.fSingularLabel = singularLabel;
        this.fPluralLabelPattern = pluralLabelPattern;
        this.fImageDescriptor = imageDescriptor;
        this.fLabelProvider = labelProvider;
        this.fGotoMarkerAction = gotoMarkerAction;
        this.fActionGroupFactory = groupFactory;
        this.fGroupByKeyComputer = groupByKeyComputer;
        this.fOperation = operation;
        if (this.fPluralLabelPattern == null) {
            this.fPluralLabelPattern = "";
        }
    }

    public Search(String pageId, String singularLabel, String pluralLabelPattern, ILabelProvider labelProvider, ImageDescriptor imageDescriptor, IAction gotoMarkerAction, IContextMenuContributor contextMenuContributor, IGroupByKeyComputer groupByKeyComputer, IRunnableWithProgress operation) {
        this.fPageId = pageId;
        this.fSingularLabel = singularLabel;
        this.fPluralLabelPattern = pluralLabelPattern;
        this.fImageDescriptor = imageDescriptor;
        this.fLabelProvider = labelProvider;
        this.fGotoMarkerAction = gotoMarkerAction;
        this.fContextMenuContributor = contextMenuContributor;
        this.fGroupByKeyComputer = groupByKeyComputer;
        this.fOperation = operation;
        if (this.fPluralLabelPattern == null) {
            this.fPluralLabelPattern = "";
        }
    }

    String getFullDescription() {
        if (this.fSingularLabel != null && this.getItemCount() == 1) {
            return this.fSingularLabel;
        }
        int i = this.fPluralLabelPattern.lastIndexOf("{0}");
        if (i < 0) {
            return this.fPluralLabelPattern;
        }
        return String.valueOf(this.fPluralLabelPattern.substring(0, i)) + this.getItemCount() + this.fPluralLabelPattern.substring(Math.min(i + 3, this.fPluralLabelPattern.length()));
    }

    String getShortDescription() {
        String text = this.getFullDescription();
        int separatorPos = text.indexOf(" - ");
        if (separatorPos < 1) {
            return String.valueOf(text.substring(0, Math.min(50, text.length()))) + "...";
        }
        if (separatorPos < 30) {
            return text;
        }
        if (text.charAt(0) == '\"') {
            return String.valueOf(text.substring(0, Math.min(30, text.length()))) + "...\" - " + text.substring(Math.min(separatorPos + 3, text.length()));
        }
        return String.valueOf(text.substring(0, Math.min(30, text.length()))) + "... - " + text.substring(Math.min(separatorPos + 3, text.length()));
    }

    ImageDescriptor getImageDescriptor() {
        return this.fImageDescriptor;
    }

    int getItemCount() {
        int count = 0;
        Iterator<SearchResultViewEntry> iter = this.getResults().iterator();
        while (iter.hasNext()) {
            count += ((ISearchResultViewEntry)iter.next()).getMatchCount();
        }
        return count;
    }

    List<SearchResultViewEntry> getResults() {
        if (this.fResults == null) {
            return new ArrayList<SearchResultViewEntry>();
        }
        return this.fResults;
    }

    ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    void searchAgain() {
        if (this.fOperation == null) {
            return;
        }
        Shell shell = SearchPlugin.getActiveWorkbenchShell();
        boolean isAutoBuilding = SearchPlugin.setAutoBuilding(false);
        try {
            try {
                new ProgressMonitorDialog(shell).run(true, true, this.fOperation);
            }
            catch (InvocationTargetException ex) {
                ExceptionHandler.handle(ex, shell, SearchMessages.Search_Error_search_title, SearchMessages.Search_Error_search_message);
                SearchPlugin.setAutoBuilding(isAutoBuilding);
            }
            catch (InterruptedException interruptedException) {
                SearchPlugin.setAutoBuilding(isAutoBuilding);
            }
        }
        finally {
            SearchPlugin.setAutoBuilding(isAutoBuilding);
        }
    }

    boolean isSameSearch(Search search) {
        return search != null && search.getOperation() == this.fOperation && this.fOperation != null;
    }

    void backupMarkers() {
        Iterator<SearchResultViewEntry> iter = this.getResults().iterator();
        while (iter.hasNext()) {
            iter.next().backupMarkers();
        }
    }

    String getPageId() {
        return this.fPageId;
    }

    IGroupByKeyComputer getGroupByKeyComputer() {
        return this.fGroupByKeyComputer;
    }

    public IRunnableWithProgress getOperation() {
        return this.fOperation;
    }

    IAction getGotoMarkerAction() {
        return this.fGotoMarkerAction;
    }

    IContextMenuContributor getContextMenuContributor() {
        return this.fContextMenuContributor;
    }

    IActionGroupFactory getActionGroupFactory() {
        return this.fActionGroupFactory;
    }

    public void removeResults() {
        this.fResults = null;
    }

    void setResults(ArrayList<SearchResultViewEntry> results) {
        Assert.isNotNull(results);
        this.fResults = results;
    }

    ISelection getSelection() {
        return this.fSelection;
    }

    void setSelection(ISelection selection) {
        this.fSelection = selection;
    }
}

