/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocument;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLPropertyDeclaration;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLMinimalContentModelGenerator;
import org.eclipse.wst.html.ui.internal.contentassist.XHTMLMinimalContentModelGenerator;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.basic.CMElementDeclarationImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractXMLModelQueryCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationPresenter;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformationProvider;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public class HTMLTagsCompletionProposalComputer
extends AbstractXMLModelQueryCompletionProposalComputer {
    protected boolean isXHTML = false;
    private IContextInformationValidator fContextInformationValidator = null;
    static /* synthetic */ Class class$0;

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)context.getViewer(), (int)context.getInvocationOffset());
        IDOMNode node = (IDOMNode)treeNode;
        boolean isXHTMLNode = HTMLTagsCompletionProposalComputer.isXHTMLNode((Node)node);
        if (this.isXHTML != isXHTMLNode) {
            this.isXHTML = isXHTMLNode;
        }
        return super.computeCompletionProposals(context, monitor);
    }

    public List computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        AttributeContextInformationProvider attributeInfoProvider = new AttributeContextInformationProvider((IStructuredDocument)context.getDocument(), (AttributeContextInformationPresenter)this.getContextInformationValidator());
        return Arrays.asList(attributeInfoProvider.getAttributeInformation(context.getInvocationOffset()));
    }

    protected XMLContentModelGenerator getContentGenerator() {
        if (this.isXHTML) {
            return XHTMLMinimalContentModelGenerator.getInstance();
        }
        return HTMLMinimalContentModelGenerator.getInstance();
    }

    protected boolean validModelQueryNode(CMNode node) {
        boolean isValid = false;
        Object cmdoc = node.getProperty("CMDocument");
        if (cmdoc instanceof CMNode) {
            String name = ((CMNode)cmdoc).getNodeName();
            isValid = name != null && name.endsWith(".dtd") && name.indexOf("html") != -1;
        } else if (node.supports("isHTML")) {
            Boolean isHTML = (Boolean)node.getProperty("isHTML");
            isValid = isHTML == null || isHTML != false;
        } else if (node instanceof HTMLPropertyDeclaration) {
            HTMLPropertyDeclaration propDec = (HTMLPropertyDeclaration)node;
            isValid = !propDec.isJSP();
        } else if (node instanceof CMAttributeDeclaration || node instanceof CMElementDeclarationImpl) {
            isValid = true;
        } else if (node instanceof CMElementDeclaration) {
            Boolean isXHTML = (Boolean)node.getProperty("isXHTML");
            boolean bl = isValid = isXHTML != null && isXHTML != false;
        }
        if (isValid && node.supports("isObsolete")) {
            Boolean isObsolete = (Boolean)node.getProperty("isObsolete");
            isValid = isObsolete == null || isObsolete == false;
        }
        return isValid;
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.addHTMLTagProposal(contentAssistRequest, context);
    }

    protected void addStartDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        boolean xmlpiIsFirstElement;
        Node aNode = contentAssistRequest.getNode();
        Document owningDocument = aNode.getOwnerDocument();
        Node first = owningDocument.getFirstChild();
        boolean bl = xmlpiIsFirstElement = first != null && first.getNodeType() == 7;
        if (xmlpiIsFirstElement && owningDocument.getDoctype() == null && this.isCursorAfterXMLPI(contentAssistRequest)) {
            this.addDocTypeProposal(contentAssistRequest, true);
        } else {
            this.addDocTypeProposal(contentAssistRequest, false);
        }
    }

    private void addDocTypeProposal(ContentAssistRequest contentAssistRequest, boolean isXHTML) {
        String rootname = "unspecified";
        if (contentAssistRequest.getNode().getOwnerDocument().getDocumentElement() != null) {
            rootname = contentAssistRequest.getNode().getOwnerDocument().getDocumentElement().getNodeName();
        }
        HTMLDocumentTypeEntry entry = isXHTML ? HTMLDocumentTypeRegistry.getInstance().getXHTMLDefaultEntry() : HTMLDocumentTypeRegistry.getInstance().getDefaultEntry();
        String proposedText = "<!DOCTYPE " + rootname + " PUBLIC \"" + entry.getPublicId() + "\" \"" + entry.getSystemId() + "\">";
        CustomCompletionProposal proposal = new CustomCompletionProposal(proposedText, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), 10, XMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/doctype.png"), String.valueOf(entry.getDisplayName()) + " " + HTMLUIMessages.Expandable_label_document_type, null, null, 600);
        contentAssistRequest.addProposal((ICompletionProposal)proposal);
    }

    /*
     * Exception decompiling
     */
    private void addHTMLTagProposal(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 282->286)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isXHTMLNode(Node node) {
        DocumentType docType;
        if (node == null) {
            return false;
        }
        Document doc = null;
        doc = node.getNodeType() != 9 ? node.getOwnerDocument() : (Document)node;
        if (doc instanceof IDOMDocument) {
            return ((IDOMDocument)doc).isXMLType();
        }
        if (doc instanceof INodeNotifier) {
            INodeNotifier iNodeNotifier = (INodeNotifier)doc;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ModelQueryAdapter adapter = (ModelQueryAdapter)iNodeNotifier.getAdapterFor((Object)clazz);
            CMDocument cmdoc = null;
            if (adapter != null && adapter.getModelQuery() != null) {
                cmdoc = adapter.getModelQuery().getCorrespondingCMDocument((Node)doc);
            }
            if (cmdoc != null) {
                if (cmdoc instanceof HTMLCMDocument) {
                    return false;
                }
                if (cmdoc.supports("isXHTML")) {
                    return Boolean.TRUE.equals(cmdoc.getProperty("isXHTML"));
                }
            }
        }
        return (docType = doc.getDoctype()) != null && docType.getPublicId() != null && docType.getPublicId().indexOf("-//W3C//DTD XHTML ") == 0;
    }

    private IContextInformationValidator getContextInformationValidator() {
        if (this.fContextInformationValidator == null) {
            this.fContextInformationValidator = new AttributeContextInformationPresenter();
        }
        return this.fContextInformationValidator;
    }
}

