/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.contentassist.CustomTemplateProposal;
import org.eclipse.wst.html.ui.internal.editor.HTMLEditorPluginImageHelper;
import org.eclipse.wst.xml.ui.internal.contentassist.ReplaceNameTemplateContext;

public class HTMLTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private static final Comparator fgProposalComparator = new ProposalComparator();
    private String fContextTypeId = null;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())), offset)) == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block6: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException e) {
                    break block6;
                }
                if (template.matches(prefix, context.getContextType().getId())) {
                    matches.add(this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        Collections.sort(matches, fgProposalComparator);
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    private TemplateContext createContext(ITextViewer viewer, IRegion region, int offset) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new ReplaceNameTemplateContext(contextType, document, region.getOffset(), region.getLength(), offset);
        }
        return null;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new CustomTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        TemplateContextType type = null;
        ContextTypeRegistry registry = this.getTemplateContextRegistry();
        if (registry != null) {
            type = registry.getContextType(this.fContextTypeId);
        }
        return type;
    }

    protected Image getImage(Template template) {
        return HTMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/tag-template.png");
    }

    private ContextTypeRegistry getTemplateContextRegistry() {
        return HTMLUIPlugin.getDefault().getTemplateContextRegistry();
    }

    protected Template[] getTemplates(String contextTypeId) {
        Template[] templates = null;
        TemplateStore store = this.getTemplateStore();
        if (store != null) {
            templates = store.getTemplates(contextTypeId);
        }
        return templates;
    }

    private TemplateStore getTemplateStore() {
        return HTMLUIPlugin.getDefault().getTemplateStore();
    }

    public void setContextType(String contextTypeId) {
        this.fContextTypeId = contextTypeId;
    }

    private static final class ProposalComparator
    implements Comparator {
        private ProposalComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
        }
    }
}

