/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class AddToFavoritesAction
extends SelectionListenerAction {
    private ILaunchConfiguration fConfiguration = null;
    private String fMode = null;
    private ILaunchGroup fGroup = null;

    public AddToFavoritesAction() {
        super("");
        this.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.edit_launch_configuration_action_context");
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ILaunchConfiguration config;
        this.setLaunchConfiguration(null);
        this.setMode(null);
        this.setGroup(null);
        if (selection.size() == 1) {
            ILaunchConfiguration configuration;
            Object object = selection.getFirstElement();
            ILaunch launch = null;
            if (object instanceof IAdaptable) {
                launch = (ILaunch)((IAdaptable)object).getAdapter(ILaunch.class);
            }
            if (launch == null) {
                if (object instanceof ILaunch) {
                    launch = (ILaunch)object;
                } else if (object instanceof IDebugElement) {
                    launch = ((IDebugElement)object).getLaunch();
                } else if (object instanceof IProcess) {
                    launch = ((IProcess)object).getLaunch();
                }
            }
            if (launch != null && (configuration = launch.getLaunchConfiguration()) != null) {
                ILaunchGroup group = DebugUITools.getLaunchGroup(configuration, this.getMode());
                if (group == null) {
                    return false;
                }
                this.setGroup(group);
                this.setLaunchConfiguration(configuration);
                this.setMode(launch.getLaunchMode());
                this.setText(MessageFormat.format((String)ActionMessages.AddToFavoritesAction_1, (Object[])new Object[]{DebugUIPlugin.removeAccelerators(this.getGroup().getLabel())}));
            }
        }
        if ((config = this.getLaunchConfiguration()) == null) {
            return false;
        }
        if (DebugUITools.isPrivate(config)) {
            return false;
        }
        if (this.getGroup() != null) {
            try {
                List groups = config.getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                if (groups != null) {
                    return !groups.contains(this.getGroup().getIdentifier());
                }
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfiguration;
    }

    protected void setMode(String mode) {
        this.fMode = mode;
    }

    protected String getMode() {
        return this.fMode;
    }

    protected void setGroup(ILaunchGroup group) {
        this.fGroup = group;
    }

    protected ILaunchGroup getGroup() {
        return this.fGroup;
    }

    public void run() {
        final CoreException[] ex = new CoreException[1];
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<String> list = AddToFavoritesAction.this.getLaunchConfiguration().getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(AddToFavoritesAction.this.getGroup().getIdentifier());
                    ILaunchConfigurationWorkingCopy copy = AddToFavoritesAction.this.getLaunchConfiguration().getWorkingCopy();
                    copy.setAttribute("org.eclipse.debug.ui.favoriteGroups", list);
                    copy.doSave();
                    AddToFavoritesAction.this.setEnabled(false);
                }
                catch (CoreException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), ActionMessages.AddToFavoritesAction_2, ActionMessages.AddToFavoritesAction_3, ex[0].getStatus());
        }
    }
}

