/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LaunchAction
extends Action {
    private ILaunchConfiguration fConfiguration;
    private String fMode;

    public LaunchAction(ILaunchConfiguration configuration, String mode) {
        this.fConfiguration = configuration;
        this.fMode = mode;
        this.setText(configuration.getName());
        this.setImageDescriptor(DebugUITools.getDefaultImageDescriptor(configuration));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.relaunch_history_action_context");
    }

    public void run() {
        this.runInternal(false);
    }

    private void runInternal(boolean isShift) {
        DebugUITools.launch(this.fConfiguration, this.fMode, isShift);
    }

    public void runWithEvent(Event event) {
        if ((event.stateMask & SWT.MOD1) > 0 && (event.stateMask & SWT.MOD2) > 0) {
            ILaunchGroup[] groups = this.getAllGroupsForConfiguration(this.fConfiguration);
            if (groups.length > 0) {
                IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
                if (store.getBoolean("org.eclipse.debug.ui.RemoveFromLaunchHistory")) {
                    MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)DebugUIPlugin.getShell(), (String)ActionMessages.LaunchAction_0, (String)MessageFormat.format((String)ActionMessages.LaunchAction_1, (Object[])new Object[]{this.fConfiguration.getName()}), (String)ActionMessages.LaunchAction_2, (boolean)false, null, null);
                    int ret = mdwt.getReturnCode();
                    if (ret == 2) {
                        this.removeFromLaunchHistories(this.fConfiguration, groups);
                        store.setValue("org.eclipse.debug.ui.RemoveFromLaunchHistory", !mdwt.getToggleState());
                    }
                } else {
                    this.removeFromLaunchHistories(this.fConfiguration, groups);
                }
            }
        } else if ((event.stateMask & SWT.MOD1) > 0) {
            ILaunchGroup group = DebugUITools.getLaunchGroup(this.fConfiguration, this.fMode);
            if (group != null) {
                DebugUITools.openLaunchConfigurationDialogOnGroup(DebugUIPlugin.getShell(), (IStructuredSelection)new StructuredSelection((Object)this.fConfiguration), group.getIdentifier());
            } else {
                this.runInternal((event.stateMask & 0x20000) > 0);
            }
        } else {
            this.runInternal((event.stateMask & 0x20000) > 0);
        }
    }

    private void removeFromLaunchHistories(ILaunchConfiguration config, ILaunchGroup[] groups) {
        LaunchHistory history = null;
        int i = 0;
        while (i < groups.length) {
            history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory(groups[i].getIdentifier());
            if (history != null) {
                history.removeFromHistory(this.fConfiguration);
            } else {
                DebugUIPlugin.logErrorMessage(MessageFormat.format((String)"Unable to remove configuration [{0}] from launch history. The launch history for mode [{1}] does not exist.", (Object[])new Object[]{config.getName(), groups[i].getMode()}));
            }
            ++i;
        }
    }

    private ILaunchGroup[] getAllGroupsForConfiguration(ILaunchConfiguration config) {
        ArrayList<ILaunchGroup> list = new ArrayList<ILaunchGroup>();
        try {
            ILaunchConfigurationType type = config.getType();
            Set modes = type.getSupportedModeCombinations();
            String mode = null;
            ILaunchGroup group = null;
            for (Set modesets : modes) {
                if (modesets.size() != 1 || (group = DebugUITools.getLaunchGroup(config, mode = (String)modesets.toArray()[0])) == null || list.contains(group)) continue;
                list.add(group);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return list.toArray(new ILaunchGroup[list.size()]);
    }
}

