/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesViewer;
import org.eclipse.cdt.debug.internal.ui.views.executables.Messages;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.Bundle;

public class ExecutablesView
extends ViewPart {
    public static final int NAME = 0;
    public static final int PROJECT = 1;
    public static final int LOCATION = 2;
    public static final int SIZE = 3;
    public static final int MODIFIED = 4;
    public static final int TYPE = 5;
    public static final int ORG_LOCATION = 6;
    public static int ASCENDING = 1;
    public static int DESCENDING = -1;
    public static final String ICONS_PATH = "icons/";
    public static final String EXECUTABLES_VIEW_CONTEXT = "org.eclipse.cdt.debug.ui.executables_View_context";
    private static final String PATH_LCL = "icons/elcl16/";
    private static final String PATH_LCL_DISABLED = "icons/dlcl16/";
    private static final String PATH_LCL_18 = "icons/elcl18/";
    private static final String PATH_LCL_18_DISABLED = "icons/dlcl18/";
    public static final ImageDescriptor DESC_REFRESH_18 = ExecutablesView.create("icons/elcl18/", "refresh.png");
    public static final ImageDescriptor DESC_REFRESH_DISABLED_18 = ExecutablesView.create("icons/dlcl18/", "refresh.png");
    public static final ImageDescriptor DESC_IMPORT_18 = ExecutablesView.create("icons/elcl18/", "import.png");
    public static final ImageDescriptor DESC_IMPORT_DISABLED_18 = ExecutablesView.create("icons/dlcl18/", "import.png");
    public static final ImageDescriptor DESC_COLUMNS_18 = ExecutablesView.create("icons/elcl18/", "columns.png");
    public static final ImageDescriptor DESC_COLUMNS_DISABLED_18 = ExecutablesView.create("icons/dlcl18/", "columns.png");
    public static final ImageDescriptor DESC_REMOVE_18 = ExecutablesView.create("icons/elcl18/", "rem_co.png");
    public static final ImageDescriptor DESC_REMOVE_DISABLED_18 = ExecutablesView.create("icons/dlcl18/", "rem_co.png");
    public static final ImageDescriptor DESC_REFRESH = ExecutablesView.create("icons/elcl16/", "refresh.gif");
    public static final ImageDescriptor DESC_REFRESH_DISABLED = ExecutablesView.create("icons/dlcl16/", "refresh.gif");
    public static final ImageDescriptor DESC_IMPORT = ExecutablesView.create("icons/elcl16/", "import.gif");
    public static final ImageDescriptor DESC_IMPORT_DISABLED = ExecutablesView.create("icons/dlcl16/", "import.gif");
    public static final ImageDescriptor DESC_COLUMNS = ExecutablesView.create("icons/elcl16/", "columns.gif");
    public static final ImageDescriptor DESC_COLUMNS_DISABLED = ExecutablesView.create("icons/dlcl16/", "columns.gif");
    public static final ImageDescriptor DESC_REMOVE = ExecutablesView.create("icons/elcl16/", "rem_co.gif");
    public static final ImageDescriptor DESC_REMOVE_DISABLED = ExecutablesView.create("icons/dlcl16/", "rem_co.gif");
    public static final int COLUMN_WIDTH_PADDING = 24;
    private static final String SEPARATOR = System.getProperty("line.separator");
    private String[] columnNames = new String[]{Messages.ExecutablesView_ExeName, Messages.ExecutablesView_ExeProject, Messages.ExecutablesView_ExeLocation, Messages.ExecutablesView_ExeSize, Messages.ExecutablesView_ExeData, Messages.ExecutablesView_ExeType, Messages.ExecutablesView_SrcName, Messages.ExecutablesView_SrcLocation, Messages.ExecutablesView_SrcOrgLocation, Messages.ExecutablesView_SrcSize, Messages.ExecutablesView_SrcDate, Messages.ExecutablesView_SrcType};
    private TreeColumn[] allColumns = new TreeColumn[this.columnNames.length];
    private SourceFilesViewer sourceFilesViewer;
    private ExecutablesViewer executablesViewer;
    Action refreshAction;
    Action importAction;
    Action removeAction;
    private Action copyAction;
    private Action configureColumnsAction;
    private IMemento memento;
    private IStructuredSelection oldSelection;
    private ISelectionProvider focusedViewer;

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)ExecutablesView.makeIconURL(prefix, name));
    }

    private static URL makeIconURL(String prefix, String name) {
        String path = "$nl$/" + prefix + name;
        return FileLocator.find((Bundle)CDebugUIPlugin.getDefault().getBundle(), (IPath)new Path(path), null);
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(container, 0);
        this.executablesViewer = new ExecutablesViewer(this, (Composite)sashForm, 67586);
        this.focusedViewer = this.executablesViewer;
        this.sourceFilesViewer = new SourceFilesViewer(this, (Composite)sashForm, 2050);
        this.executablesViewer.getTree().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ExecutablesView.this.focusedViewer = (ISelectionProvider)ExecutablesView.this.executablesViewer;
            }
        });
        this.sourceFilesViewer.getTree().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ExecutablesView.this.focusedViewer = (ISelectionProvider)ExecutablesView.this.sourceFilesViewer;
            }
        });
        this.getViewSite().setSelectionProvider(new ISelectionProvider(){

            public void setSelection(ISelection selection) {
                ExecutablesView.this.getFocusedViewer().setSelection(selection);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                ExecutablesView.this.executablesViewer.removeSelectionChangedListener(listener);
                ExecutablesView.this.sourceFilesViewer.removeSelectionChangedListener(listener);
            }

            public ISelection getSelection() {
                return ExecutablesView.this.getFocusedViewer().getSelection();
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                ExecutablesView.this.executablesViewer.addSelectionChangedListener(listener);
                ExecutablesView.this.sourceFilesViewer.addSelectionChangedListener(listener);
            }
        });
        sashForm.setWeights(new int[]{1, 1});
        this.allColumns[0] = this.executablesViewer.nameColumn;
        this.allColumns[1] = this.executablesViewer.projectColumn;
        this.allColumns[2] = this.executablesViewer.locationColumn;
        this.allColumns[3] = this.executablesViewer.sizeColumn;
        this.allColumns[4] = this.executablesViewer.modifiedColumn;
        this.allColumns[5] = this.executablesViewer.typeColumn;
        this.allColumns[6] = this.sourceFilesViewer.nameColumn;
        this.allColumns[7] = this.sourceFilesViewer.locationColumn;
        this.allColumns[8] = this.sourceFilesViewer.originalLocationColumn;
        this.allColumns[9] = this.sourceFilesViewer.sizeColumn;
        this.allColumns[10] = this.sourceFilesViewer.modifiedColumn;
        this.allColumns[11] = this.sourceFilesViewer.typeColumn;
        this.readSettings();
        this.createActions();
        this.executablesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection newSelection = event.getSelection();
                if (newSelection instanceof IStructuredSelection && (ExecutablesView.this.oldSelection == null || !ExecutablesView.this.oldSelection.equals(newSelection))) {
                    ExecutablesView.this.removeAction.setEnabled(!newSelection.isEmpty());
                    Object firstElement = ((IStructuredSelection)newSelection).getFirstElement();
                    ExecutablesView.this.sourceFilesViewer.setInput(firstElement);
                    ExecutablesView.this.oldSelection = (IStructuredSelection)newSelection;
                }
            }
        });
        this.executablesViewer.packColumns();
        this.sourceFilesViewer.packColumns();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, EXECUTABLES_VIEW_CONTEXT);
    }

    protected ISelectionProvider getFocusedViewer() {
        return this.focusedViewer;
    }

    private void setVisibleColumns(String[] ids) {
        List<String> visibleNames = Arrays.asList(ids);
        int i = 0;
        while (i < this.columnNames.length) {
            this.makeColumnVisible(visibleNames.contains(this.columnNames[i]), this.allColumns[i]);
            ++i;
        }
    }

    private void makeColumnVisible(boolean visible, TreeColumn column) {
        boolean isVisible;
        boolean bl = isVisible = column.getWidth() > 0;
        if (isVisible != visible) {
            if (visible) {
                column.setResizable(true);
                column.pack();
                column.setWidth(column.getWidth() + 24);
            } else {
                column.setWidth(0);
                column.setResizable(false);
            }
        }
    }

    private String[] getVisibleColumns() {
        ArrayList<String> visibleNames = new ArrayList<String>();
        int i = 0;
        while (i < this.columnNames.length) {
            if (this.allColumns[i].getWidth() > 0) {
                visibleNames.add(this.columnNames[i]);
            }
            ++i;
        }
        return visibleNames.toArray(new String[visibleNames.size()]);
    }

    private void createActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = bars.getToolBarManager();
        this.refreshAction = this.createRefreshAction();
        toolBarManager.add((IAction)this.refreshAction);
        this.importAction = this.createImportAction();
        toolBarManager.add((IAction)this.importAction);
        this.removeAction = this.createRemoveAction();
        toolBarManager.add((IAction)this.removeAction);
        this.configureColumnsAction = this.createConfigureColumnsAction();
        toolBarManager.add((IAction)this.configureColumnsAction);
        this.copyAction = this.createCopyAction();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
    }

    private Action createCopyAction() {
        Action action = new Action("Copy"){};
        return action;
    }

    private Action createRemoveAction() {
        Action action = new Action(Messages.ExecutablesView_Remove){

            public void run() {
                ISelection selection = ExecutablesView.this.getExecutablesViewer().getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object[] selectedObjects = ((IStructuredSelection)selection).toArray();
                    ArrayList<Executable> selectedExes = new ArrayList<Executable>();
                    Object[] objectArray = selectedObjects;
                    int n = selectedObjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof Executable) {
                            selectedExes.add((Executable)object);
                        }
                        ++n2;
                    }
                    final Executable[] selectedExesArray = selectedExes.toArray(new Executable[selectedExes.size()]);
                    boolean confirm = MessageDialog.openConfirm((Shell)ExecutablesView.this.getSite().getShell(), (String)Messages.ExecutablesView_ConfirmRemoveExe, (String)Messages.ExecutablesView_ConfirmRemoveSelected);
                    if (confirm) {
                        WorkbenchJob removeJob = new WorkbenchJob(Messages.ExecutablesView_RemoveExes){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                IStatus result = ExecutablesManager.getExecutablesManager().removeExecutables(selectedExesArray, monitor);
                                if (result.getSeverity() != 0) {
                                    StringBuilder message = new StringBuilder(result.getMessage());
                                    if (result.isMultiStatus()) {
                                        IStatus[] children = result.getChildren();
                                        int i = 0;
                                        while (i < children.length && i < 6) {
                                            message.append(SEPARATOR);
                                            message.append(children[i].getMessage());
                                            ++i;
                                        }
                                    }
                                    MessageDialog.openWarning((Shell)ExecutablesView.this.getSite().getShell(), (String)Messages.ExecutablesView_RemoveExes, (String)message.toString());
                                }
                                return result;
                            }
                        };
                        removeJob.schedule();
                    }
                }
            }
        };
        action.setToolTipText(Messages.ExecutablesView_RemoveSelectedExes);
        action.setImageDescriptor(DESC_REMOVE_18);
        action.setDisabledImageDescriptor(DESC_REMOVE_DISABLED_18);
        action.setEnabled(false);
        return action;
    }

    private Action createConfigureColumnsAction() {
        ConfigureColumnsAction action = new ConfigureColumnsAction();
        action.setToolTipText(Messages.ExecutablesView_Columns);
        action.setImageDescriptor(DESC_COLUMNS_18);
        action.setDisabledImageDescriptor(DESC_COLUMNS_DISABLED_18);
        action.setEnabled(true);
        return action;
    }

    protected void importExecutables(final String[] fileNames) {
        if (fileNames.length > 0) {
            Job importJob = new Job(Messages.ExecutablesView_ImportExecutables){

                public IStatus run(IProgressMonitor monitor) {
                    ExecutablesManager.getExecutablesManager().importExecutables(fileNames, monitor);
                    return Status.OK_STATUS;
                }
            };
            importJob.schedule();
        }
    }

    private Action createImportAction() {
        Action action = new Action(Messages.ExecutablesView_Import){

            public void run() {
                FileDialog dialog = new FileDialog(ExecutablesView.this.getViewSite().getShell(), 0);
                dialog.setText(Messages.ExecutablesView_SelectExeFile);
                String res = dialog.open();
                if (res != null) {
                    if (Platform.getOS().equals("macosx") && res.endsWith(".app")) {
                        Path macPath = new Path(res);
                        res = String.valueOf(res) + "/Contents/MacOS/" + macPath.lastSegment();
                        res = res.substring(0, res.length() - 4);
                    }
                    ExecutablesView.this.importExecutables(new String[]{res});
                }
            }
        };
        action.setToolTipText(Messages.ExecutablesView_ImportExe);
        action.setImageDescriptor(DESC_IMPORT_18);
        action.setDisabledImageDescriptor(DESC_IMPORT_DISABLED_18);
        action.setEnabled(true);
        return action;
    }

    private Action createRefreshAction() {
        Action action = new Action(Messages.ExecutablesView_Refresh){

            public void run() {
                ExecutablesManager.getExecutablesManager().refresh(null);
                ExecutablesView.this.sourceFilesViewer.restartCanceledExecutableParse();
            }
        };
        action.setToolTipText(Messages.ExecutablesView_RefreshList);
        action.setImageDescriptor(DESC_REFRESH_18);
        action.setDisabledImageDescriptor(DESC_REFRESH_DISABLED_18);
        action.setEnabled(true);
        return action;
    }

    public void setFocus() {
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"EXECUTABLESVIEW") : memento;
        super.init(site, memento);
    }

    private Preferences getViewPreferences() {
        return CDebugUIPlugin.getDefault().getPluginPreferences();
    }

    private void readSettings() {
        Preferences prefs = this.getViewPreferences();
        this.getExecutablesViewer().restoreColumnSettings(prefs);
        this.getSourceFilesViewer().restoreColumnSettings(prefs);
    }

    private void writeSettings() {
        Preferences prefs = this.getViewPreferences();
        this.getExecutablesViewer().saveColumnSettings(prefs);
        this.getSourceFilesViewer().saveColumnSettings(prefs);
    }

    public void saveState(IMemento memento) {
        if (this.memento == null || memento == null) {
            return;
        }
        memento.putMemento(this.memento);
        this.writeSettings();
    }

    public SourceFilesViewer getSourceFilesViewer() {
        return this.sourceFilesViewer;
    }

    public ExecutablesViewer getExecutablesViewer() {
        return this.executablesViewer;
    }

    public void dispose() {
        super.dispose();
    }

    public class ConfigureColumnsAction
    extends Action {
        public static final String CONFIGURE_COLUMNS_DIALOG = "org.eclipse.cdt.debug.ui.configure_columns_dialog_context";
        public static final String CONFIGURE_COLUMNS_ACTION = "org.eclipse.cdt.debug.ui.configure_columns_action_context";

        public ConfigureColumnsAction() {
            this.setText(Messages.ExecutablesView_ConfigureColumns);
            this.setId(String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".ConfigureColumnsAction");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, CONFIGURE_COLUMNS_ACTION);
        }

        public void run() {
            ListSelectionDialog dialog = new ListSelectionDialog(ExecutablesView.this.getExecutablesViewer().getTree().getShell(), (Object)this, (IStructuredContentProvider)new ColumnContentProvider(), (ILabelProvider)new ColumnLabelProvider(), Messages.ExecutablesView_SelectColumns);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, CONFIGURE_COLUMNS_DIALOG);
            String[] visibleColumns = ExecutablesView.this.getVisibleColumns();
            ArrayList<String> initialSelection = new ArrayList<String>(visibleColumns.length);
            int i = 0;
            while (i < visibleColumns.length) {
                initialSelection.add(visibleColumns[i]);
                ++i;
            }
            dialog.setTitle(Messages.ExecutablesView_ConfigureColumns);
            dialog.setInitialElementSelections(initialSelection);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                String[] ids = new String[result.length];
                System.arraycopy(result, 0, ids, 0, result.length);
                ExecutablesView.this.setVisibleColumns(ids);
            }
        }

        class ColumnContentProvider
        implements IStructuredContentProvider {
            ColumnContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                return ExecutablesView.this.columnNames;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        class ColumnLabelProvider
        extends LabelProvider {
            ColumnLabelProvider() {
            }

            public String getText(Object element) {
                return (String)element;
            }
        }
    }
}

