/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.HttpsUtility;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteSearchParser;
import org.eclipse.help.internal.base.util.ProxyUtil;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.util.URLCoder;

public class RemoteSearchManager {
    private static final String PATH_SEARCH = "/search";
    private static final String PARAM_PHRASE = "phrase";
    private static final String PARAM_LANG = "lang";
    private static final String PROTOCOL_HTTP = "http";

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        block24: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (int)100);
            PreferenceFileHandler prefHandler = new PreferenceFileHandler();
            String[] host = prefHandler.getHostEntries();
            String[] port = prefHandler.getPortEntries();
            String[] path = prefHandler.getPathEntries();
            String[] protocols = prefHandler.getProtocolEntries();
            String[] isEnabled = prefHandler.isEnabled();
            try {
                if (!RemoteHelp.isEnabled()) break block24;
                int numICs = host.length;
                int i = 0;
                while (i < numICs) {
                    block25: {
                        if (isEnabled[i].equals("true")) {
                            String msg;
                            InputStream in = null;
                            try {
                                URL url;
                                if (protocols[i].equals(PROTOCOL_HTTP)) {
                                    url = new URL(PROTOCOL_HTTP, host[i], new Integer(port[i]), String.valueOf(path[i]) + PATH_SEARCH + '?' + PARAM_PHRASE + '=' + URLCoder.encode((String)searchQuery.getSearchWord()) + '&' + PARAM_LANG + '=' + searchQuery.getLocale());
                                    in = ProxyUtil.getStream(url);
                                } else {
                                    url = HttpsUtility.getHttpsURL(protocols[i], host[i], port[i], String.valueOf(path[i]) + PATH_SEARCH + '?' + PARAM_PHRASE + '=' + URLCoder.encode((String)searchQuery.getSearchWord()) + '&' + PARAM_LANG + '=' + searchQuery.getLocale());
                                    in = HttpsUtility.getHttpsStream(url);
                                }
                                RemoteSearchParser parser = new RemoteSearchParser();
                                List<SearchHit> hits = parser.parse(in, (IProgressMonitor)subMonitor.split(100));
                                collector.addHits(hits, null);
                            }
                            catch (IOException e) {
                                msg = "I/O error while trying to contact the remote help server";
                                HelpBasePlugin.logError(msg, e);
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block25;
                            }
                            catch (Throwable t) {
                                try {
                                    msg = "Internal error while reading search results from remote server";
                                    HelpBasePlugin.logError(msg, t);
                                    break block25;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                            if (in == null) break block25;
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    ++i;
                }
            }
            finally {
                pm.done();
            }
        }
    }
}

