/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.List;
import java.util.Vector;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DefaultASTVisitor;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InferredType;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.UndefinedLiteral;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveryScannerData;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObjectToIntArray;

class ASTRecoveryPropagator
extends DefaultASTVisitor {
    private static final int NOTHING = -1;
    HashtableOfObjectToIntArray endingTokens = new HashtableOfObjectToIntArray();
    private CategorizedProblem[] problems;
    private boolean[] usedOrIrrelevantProblems;
    private RecoveryScannerData data;
    private int blockDepth;
    private int lastEnd;
    private int[] insertedTokensKind;
    private int[] insertedTokensPosition;
    private boolean[] insertedTokensFlagged;
    private boolean[] removedTokensFlagged;
    private boolean[] replacedTokensFlagged;
    private Vector stack;

    ASTRecoveryPropagator(CategorizedProblem[] problems, RecoveryScannerData data) {
        this.endingTokens.put(AnonymousClassDeclaration.class, new int[]{56});
        this.endingTokens.put(ArrayAccess.class, new int[]{54});
        this.endingTokens.put(ArrayCreation.class, new int[]{-1, 54});
        this.endingTokens.put(ArrayInitializer.class, new int[]{54});
        this.endingTokens.put(ArrayType.class, new int[]{54});
        this.endingTokens.put(Block.class, new int[]{56});
        this.endingTokens.put(BooleanLiteral.class, new int[]{36, 40});
        this.endingTokens.put(BreakStatement.class, new int[]{24});
        this.endingTokens.put(CharacterLiteral.class, new int[]{34});
        this.endingTokens.put(RegularExpressionLiteral.class, new int[]{45});
        this.endingTokens.put(ClassInstanceCreation.class, new int[]{56, 52});
        this.endingTokens.put(ConstructorInvocation.class, new int[]{24});
        this.endingTokens.put(ContinueStatement.class, new int[]{24});
        this.endingTokens.put(DoStatement.class, new int[]{52});
        this.endingTokens.put(EmptyStatement.class, new int[]{24});
        this.endingTokens.put(ExpressionStatement.class, new int[]{24});
        this.endingTokens.put(FieldDeclaration.class, new int[]{24});
        this.endingTokens.put(ImportDeclaration.class, new int[]{24});
        this.endingTokens.put(Initializer.class, new int[]{56});
        this.endingTokens.put(FunctionDeclaration.class, new int[]{-1, 24});
        this.endingTokens.put(FunctionInvocation.class, new int[]{52});
        this.endingTokens.put(NullLiteral.class, new int[]{38});
        this.endingTokens.put(UndefinedLiteral.class, new int[]{41});
        this.endingTokens.put(NumberLiteral.class, new int[]{33, 42, 43, 44});
        this.endingTokens.put(PackageDeclaration.class, new int[]{24});
        this.endingTokens.put(ParenthesizedExpression.class, new int[]{52});
        this.endingTokens.put(PostfixExpression.class, new int[]{3, 4});
        this.endingTokens.put(PrimitiveType.class, new int[]{90, 112, 91, 103, 106, 99, 89, 94, 49});
        this.endingTokens.put(ReturnStatement.class, new int[]{24});
        this.endingTokens.put(SimpleName.class, new int[]{32});
        this.endingTokens.put(SingleVariableDeclaration.class, new int[]{24});
        this.endingTokens.put(StringLiteral.class, new int[]{35});
        this.endingTokens.put(SuperConstructorInvocation.class, new int[]{24});
        this.endingTokens.put(SuperMethodInvocation.class, new int[]{52});
        this.endingTokens.put(SwitchCase.class, new int[]{53});
        this.endingTokens.put(SwitchStatement.class, new int[]{56});
        this.endingTokens.put(ThisExpression.class, new int[]{39});
        this.endingTokens.put(ThrowStatement.class, new int[]{24});
        this.endingTokens.put(TypeDeclaration.class, new int[]{56});
        this.endingTokens.put(TypeLiteral.class, new int[]{92});
        this.endingTokens.put(VariableDeclarationStatement.class, new int[]{24});
        this.blockDepth = 0;
        this.stack = new Vector();
        this.problems = problems;
        this.usedOrIrrelevantProblems = new boolean[problems.length];
        this.data = data;
        if (this.data != null) {
            int length = 0;
            int i = 0;
            while (i < data.insertedTokensPtr + 1) {
                length += data.insertedTokens[i].length;
                ++i;
            }
            this.insertedTokensKind = new int[length];
            this.insertedTokensPosition = new int[length];
            this.insertedTokensFlagged = new boolean[length];
            int tokenCount = 0;
            int i2 = 0;
            while (i2 < data.insertedTokensPtr + 1) {
                int j = 0;
                while (j < data.insertedTokens[i2].length) {
                    this.insertedTokensKind[tokenCount] = data.insertedTokens[i2][j];
                    this.insertedTokensPosition[tokenCount] = data.insertedTokensPosition[i2];
                    ++tokenCount;
                    ++j;
                }
                ++i2;
            }
            if (data.removedTokensPtr != -1) {
                this.removedTokensFlagged = new boolean[data.removedTokensPtr + 1];
            }
            if (data.replacedTokensPtr != -1) {
                this.replacedTokensFlagged = new boolean[data.replacedTokensPtr + 1];
            }
        }
    }

    public void endVisit(Block node) {
        --this.blockDepth;
        if (this.blockDepth <= 0) {
            this.flagNodeWithInsertedTokens();
        }
        super.endVisit(node);
    }

    public boolean visit(Block node) {
        boolean visitChildren = super.visit(node);
        ++this.blockDepth;
        return visitChildren;
    }

    protected boolean visitNode(ASTNode node) {
        if (this.blockDepth > 0) {
            int i;
            if (node instanceof InferredType) {
                return true;
            }
            int start = node.getStartPosition();
            int end = start + node.getLength() - 1;
            if (this.insertedTokensFlagged != null) {
                i = 0;
                while (i < this.insertedTokensFlagged.length) {
                    if (this.insertedTokensPosition[i] >= start && this.insertedTokensPosition[i] <= end) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.removedTokensFlagged != null) {
                i = 0;
                while (i <= this.data.removedTokensPtr) {
                    if (this.data.removedTokensStart[i] >= start && this.data.removedTokensEnd[i] <= end) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.replacedTokensFlagged != null) {
                i = 0;
                while (i <= this.data.replacedTokensPtr) {
                    if (this.data.replacedTokensStart[i] >= start && this.data.replacedTokensEnd[i] <= end) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    protected void endVisitNode(ASTNode node) {
        int start = node.getStartPosition();
        int end = start + node.getLength() - 1;
        if (this.blockDepth < 1) {
            if (this.markIncludedProblems(start, end)) {
                node.setFlags(node.getFlags() | 8);
            }
        } else {
            int i;
            this.markIncludedProblems(start, end);
            if (this.insertedTokensFlagged != null) {
                if (this.lastEnd != end) {
                    this.flagNodeWithInsertedTokens();
                }
                this.stack.add(node);
            }
            if (this.removedTokensFlagged != null) {
                i = 0;
                while (i <= this.data.removedTokensPtr) {
                    if (!this.removedTokensFlagged[i] && this.data.removedTokensStart[i] >= start && this.data.removedTokensEnd[i] <= end) {
                        node.setFlags(node.getFlags() | 8);
                        this.removedTokensFlagged[i] = true;
                    }
                    ++i;
                }
            }
            if (this.replacedTokensFlagged != null) {
                i = 0;
                while (i <= this.data.replacedTokensPtr) {
                    if (!this.replacedTokensFlagged[i] && this.data.replacedTokensStart[i] >= start && this.data.replacedTokensEnd[i] <= end) {
                        node.setFlags(node.getFlags() | 8);
                        this.replacedTokensFlagged[i] = true;
                    }
                    ++i;
                }
            }
        }
        this.lastEnd = end;
    }

    private void flagNodeWithInsertedTokens() {
        if (this.insertedTokensKind != null && this.insertedTokensKind.length > 0) {
            int s = this.stack.size();
            int i = s - 1;
            while (i > -1) {
                this.flagNodesWithInsertedTokensAtEnd((ASTNode)this.stack.get(i));
                --i;
            }
            i = 0;
            while (i < s) {
                this.flagNodesWithInsertedTokensInside((ASTNode)this.stack.get(i));
                ++i;
            }
            this.stack = new Vector();
        }
    }

    private boolean flagNodesWithInsertedTokensAtEnd(ASTNode node) {
        int[] expectedEndingToken = this.endingTokens.get(node.getClass());
        if (expectedEndingToken != null) {
            int start = node.getStartPosition();
            int end = start + node.getLength() - 1;
            boolean flagParent = false;
            int i = this.insertedTokensKind.length - 1;
            block0: while (i > -1) {
                if (!this.insertedTokensFlagged[i] && this.insertedTokensPosition[i] == end) {
                    this.insertedTokensFlagged[i] = true;
                    int j = 0;
                    while (j < expectedEndingToken.length) {
                        if (expectedEndingToken[j] == this.insertedTokensKind[i]) {
                            node.setFlags(node.getFlags() | 8);
                            break block0;
                        }
                        ++j;
                    }
                    flagParent = true;
                }
                --i;
            }
            if (flagParent) {
                ASTNode parent = node.getParent();
                while (parent != null) {
                    parent.setFlags(node.getFlags() | 8);
                    parent = parent.getStartPosition() + parent.getLength() - 1 != end ? null : parent.getParent();
                }
            }
        }
        return true;
    }

    private boolean flagNodesWithInsertedTokensInside(ASTNode node) {
        int start = node.getStartPosition();
        int end = start + node.getLength() - 1;
        int i = 0;
        while (i < this.insertedTokensKind.length) {
            if (!this.insertedTokensFlagged[i] && start <= this.insertedTokensPosition[i] && this.insertedTokensPosition[i] < end) {
                node.setFlags(node.getFlags() | 8);
                this.insertedTokensFlagged[i] = true;
            }
            ++i;
        }
        return true;
    }

    private boolean markIncludedProblems(int start, int end) {
        boolean foundProblems = false;
        int i = 0;
        int max = this.problems.length;
        while (i < max) {
            block6: {
                CategorizedProblem problem = this.problems[i];
                if (!this.usedOrIrrelevantProblems[i]) {
                    switch (problem.getID()) {
                        case 0x600000CC: 
                        case 1610612941: 
                        case 1610612945: 
                        case 1610612946: 
                        case 0x600000E6: 
                        case 1610612967: 
                        case 1610612968: 
                        case 1610612969: 
                        case 1610612970: 
                        case 1610612971: 
                        case 1610612972: 
                        case 1610612973: 
                        case 0x600000EE: 
                        case 1610612975: 
                        case 0x600000F0: 
                        case 1610612977: 
                        case 1610612978: 
                        case 1610612986: 
                        case 1610612987: 
                        case 1610612988: 
                        case 1610612989: 
                        case 1610612990: 
                        case 0x600000FF: 
                        case 0x60000100: 
                        case 0x60000101: 
                        case 1610612994: 
                        case 1610612995: 
                        case 1610612996: 
                        case 0x60000106: {
                            break;
                        }
                        default: {
                            this.usedOrIrrelevantProblems[i] = true;
                            break block6;
                        }
                    }
                    int problemStart = problem.getSourceStart();
                    int problemEnd = problem.getSourceEnd();
                    if (start <= problemStart && problemStart <= end || start <= problemEnd && problemEnd <= end) {
                        this.usedOrIrrelevantProblems[i] = true;
                        foundProblems = true;
                    }
                }
            }
            ++i;
        }
        return foundProblems;
    }

    public void endVisit(ExpressionStatement node) {
        SimpleName simpleName;
        Assignment assignment;
        Expression rightHandSide;
        this.endVisitNode(node);
        if ((node.getFlags() & 8) == 0) {
            return;
        }
        Expression expression = node.getExpression();
        if (expression.getNodeType() == 7 && (rightHandSide = (assignment = (Assignment)expression).getRightHandSide()).getNodeType() == 42 && CharOperation.equals(RecoveryScanner.FAKE_IDENTIFIER, (simpleName = (SimpleName)rightHandSide).getIdentifier().toCharArray())) {
            Expression expression2 = assignment.getLeftHandSide();
            expression2.setParent(null, null);
            expression2.setFlags(expression2.getFlags() | 8);
            node.setExpression(expression2);
        }
    }

    public void endVisit(VariableDeclarationStatement node) {
        this.endVisitNode(node);
        List fragments = node.fragments();
        int i = 0;
        int max = fragments.size();
        while (i < max) {
            SimpleName simpleName;
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
            Expression expression = fragment.getInitializer();
            if (expression != null && (expression.getFlags() & 8) != 0 && expression.getNodeType() == 42 && CharOperation.equals(RecoveryScanner.FAKE_IDENTIFIER, (simpleName = (SimpleName)expression).getIdentifier().toCharArray())) {
                fragment.setInitializer(null);
                fragment.setFlags(node.getFlags() | 8);
            }
            ++i;
        }
    }
}

