/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IJsDocFieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class JavadocFieldReference
extends FieldReference
implements IJsDocFieldReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;
    public MethodBinding methodBinding;

    public JavadocFieldReference(char[] source, long pos) {
        super(source, pos);
        this.bits |= 0x8000;
    }

    protected TypeBinding internalResolveType(Scope scope) {
        FieldBinding fieldBinding;
        this.constant = Constant.NotAConstant;
        this.receiverType = this.receiver == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.receiver.resolveType((ClassScope)scope) : this.receiver.resolveType((BlockScope)scope));
        if (this.receiverType == null) {
            return null;
        }
        if (this.receiver != null && this.receiver.isThis() && scope.classScope() == null) {
            return null;
        }
        Binding binding = fieldBinding = this.receiver != null && this.receiver.isThis() ? scope.classScope().getBinding(this.token, this.bits & 0xF, this, true) : scope.getField(this.receiverType, this.token, this);
        if (!fieldBinding.isValidBinding()) {
            switch (fieldBinding.problemId()) {
                case 5: 
                case 6: 
                case 7: {
                    FieldBinding closestMatch = ((ProblemFieldBinding)fieldBinding).closestMatch;
                    if (closestMatch == null) break;
                    fieldBinding = closestMatch;
                }
            }
        }
        if (!fieldBinding.isValidBinding() || !(fieldBinding instanceof FieldBinding)) {
            if (this.receiverType instanceof ReferenceBinding) {
                ReferenceBinding refBinding = (ReferenceBinding)this.receiverType;
                MethodBinding[] methodBindings = refBinding.getMethods(this.token);
                if (methodBindings == null) {
                    scope.problemReporter().javadocInvalidField(this.sourceStart, this.sourceEnd, fieldBinding, this.receiverType, scope.getDeclarationModifiers());
                } else {
                    switch (methodBindings.length) {
                        case 0: {
                            scope.problemReporter().javadocInvalidField(this.sourceStart, this.sourceEnd, fieldBinding, this.receiverType, scope.getDeclarationModifiers());
                            break;
                        }
                        case 1: {
                            this.methodBinding = methodBindings[0];
                        }
                    }
                }
            }
            return null;
        }
        this.binding = fieldBinding;
        if (this.isFieldUseDeprecated(this.binding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().javadocDeprecatedField(this.binding, this, scope.getDeclarationModifiers());
        }
        this.resolvedType = this.binding.type;
        return this.resolvedType;
    }

    public boolean isSuperAccess() {
        return (this.bits & 0x4000) != 0;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.receiver != null) {
            this.receiver.printExpression(0, output);
        }
        output.append('#').append(this.token);
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.receiver != null) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope) && this.receiver != null) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 56;
    }
}

