/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.io.File;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;

public class CompilationUnitBinding
extends SourceTypeBinding {
    CompilationUnitScope compilationUnitScope;
    private char[] shortName;
    char[] path;

    public CompilationUnitBinding(CompilationUnitScope scope, PackageBinding fPackage, char[] path) {
        this(scope, fPackage, path, null);
    }

    public CompilationUnitBinding(CompilationUnitScope scope, PackageBinding fPackage, char[] path, ReferenceBinding superType) {
        super(new char[][]{scope.referenceContext.getFileName()}, fPackage, scope);
        this.compilationUnitScope = scope;
        this.memberTypes = Binding.NO_MEMBER_TYPES;
        this.sourceName = this.fileName;
        this.setShortName(this.fileName);
        this.path = path;
        this.setSuperBinding(superType);
    }

    private void setShortName(char[] fileName) {
        int i = fileName.length - 1;
        while (i >= 0) {
            if (fileName[i] == File.separatorChar || fileName[i] == '/') {
                this.shortName = new char[fileName.length - 1 - i];
                System.arraycopy(fileName, i + 1, this.shortName, 0, this.shortName.length);
                return;
            }
            --i;
        }
        this.shortName = fileName;
    }

    public int kind() {
        return 8192;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('X', this.constantPoolName(), ';');
        return this.signature;
    }

    public AbstractMethodDeclaration sourceMethod(MethodBinding binding) {
        if (this.compilationUnitScope == null) {
            return null;
        }
        ProgramElement[] statements = this.compilationUnitScope.referenceContext.statements;
        int i = 0;
        while (i < statements.length) {
            if (statements[i] instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)statements[i]).getBinding() == binding) {
                return (AbstractMethodDeclaration)statements[i];
            }
            if (statements[i] instanceof Assignment && ((Assignment)statements[i]).expression instanceof FunctionExpression) {
                FunctionExpression functionExpression = (FunctionExpression)((Assignment)statements[i]).expression;
                if (functionExpression.methodDeclaration != null && functionExpression.methodDeclaration.getBinding() == binding) {
                    return functionExpression.methodDeclaration;
                }
            }
            ++i;
        }
        class MethodFinder
        extends ASTVisitor {
            MethodBinding binding;
            MethodDeclaration method;

            MethodFinder(MethodBinding binding) {
                this.binding = binding;
            }

            public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
                if (methodDeclaration.getBinding() == this.binding) {
                    this.method = methodDeclaration;
                    return false;
                }
                return true;
            }

            public boolean visit(InferredType inferredType, BlockScope scope) {
                return false;
            }

            public boolean visit(Javadoc javadoc, BlockScope scope) {
                return false;
            }

            public boolean visit(Javadoc javadoc, ClassScope scope) {
                return false;
            }

            public boolean visit(PostfixExpression postfixExpression, BlockScope scope) {
                return false;
            }

            public boolean visit(PrefixExpression prefixExpression, BlockScope scope) {
                return false;
            }

            public boolean visit(ThisReference thisReference, BlockScope scope) {
                return false;
            }

            public boolean visit(ThisReference thisReference, ClassScope scope) {
                return false;
            }
        }
        MethodFinder visitor = new MethodFinder(binding);
        this.compilationUnitScope.referenceContext.traverse(visitor, this.compilationUnitScope, true);
        return visitor.method;
    }

    public char[] qualifiedSourceName() {
        return CharOperation.concatWith(this.compoundName, '.');
    }

    public char[] qualifiedPackageName() {
        return this.path;
    }

    public void cleanup() {
        super.cleanup();
        if (this.methods != null) {
            int i = 0;
            while (i < this.methods.length) {
                this.methods[i].cleanup();
                ++i;
            }
        }
        this.compilationUnitScope = null;
    }
}

