/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JSDScopeUtil;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.search.IRestrictedAccessBindingRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;

public class DocumentContextFragmentRoot
extends PackageFragmentRoot {
    public static final boolean HACK_DOJO = true;
    private final String UNCOMPRESSED_DOJO = "dojo.js.uncompressed.js";
    private final String DOJO_COMPRESSED = "dojo.js";
    private String[] includedFiles;
    private IFile fRelativeFile;
    private IResource absolutePath;
    private IPath webContext;
    private IIncludePathEntry rawClassPathEntry;
    private static final boolean DEBUG = false;
    private static int instances = 0;
    private IJavaScriptUnit[] workingCopies;
    private String[] fSystemFiles;
    private RestrictedDocumentBinding importPolice;
    private static final IPath EMPTY_PATH = new Path("");

    public String[] getProjectSystemFiles() {
        if (this.fSystemFiles != null) {
            return this.fSystemFiles;
        }
        IJavaScriptProject javaProject = this.getJavaScriptProject();
        int lastGood = 0;
        IPackageFragmentRoot[] projectRoots = null;
        try {
            projectRoots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < projectRoots.length) {
                if (projectRoots[i].isLanguageRuntime()) {
                    projectRoots[lastGood++] = projectRoots[i];
                } else if (projectRoots[i].getRawIncludepathEntry().getEntryKind() == 3) {
                    projectRoots[lastGood++] = projectRoots[i];
                }
                ++i;
            }
        }
        catch (JavaScriptModelException ex) {
            projectRoots = new IPackageFragmentRoot[]{};
        }
        this.fSystemFiles = new String[lastGood];
        int i = 0;
        while (i < this.fSystemFiles.length) {
            this.fSystemFiles[i] = projectRoots[i].getPath().toString().intern();
            ++i;
        }
        return this.fSystemFiles;
    }

    public void classpathChange() {
        this.fSystemFiles = null;
    }

    public DocumentContextFragmentRoot(IJavaScriptProject project, IFile resourceRelativeFile, IPath resourceAbsolutePath, IPath webContext, IIncludePathEntry rawClassPath) {
        super((IResource)resourceRelativeFile, (JavaProject)project);
        this.fRelativeFile = resourceRelativeFile;
        this.absolutePath = ((IContainer)project.getResource()).findMember(resourceAbsolutePath);
        this.webContext = webContext;
        this.rawClassPathEntry = rawClassPath;
    }

    public void finalize() {
    }

    public IIncludePathEntry getRawIncludepathEntry() throws JavaScriptModelException {
        if (this.rawClassPathEntry != null) {
            return this.rawClassPathEntry;
        }
        return super.getRawIncludepathEntry();
    }

    protected RestrictedDocumentBinding getRestrictedAccessRequestor() {
        if (this.importPolice == null) {
            this.importPolice = new RestrictedDocumentBinding();
        }
        this.importPolice.reset();
        return this.importPolice;
    }

    public DocumentContextFragmentRoot(IJavaScriptProject project, IFile resourceRelativeFile, IPath resourceAbsolutePath, IPath webContext) {
        this(project, resourceRelativeFile, resourceAbsolutePath, webContext, null);
    }

    public DocumentContextFragmentRoot(IJavaScriptProject project, IFile resourceRelativeFile) {
        this(project, resourceRelativeFile, (IPath)new Path(""), (IPath)new Path(""));
    }

    public void setIncludedFiles2(String[] fileNames) {
        ArrayList<String> newImports = new ArrayList<String>();
        int i = 0;
        while (i < fileNames.length) {
            File importFile = this.isValidImport(fileNames[i]);
            if (importFile != null) {
                IPath importPath = this.resolveChildPath(fileNames[i]);
                newImports.add(importPath.toString());
            }
            ++i;
        }
        boolean equals = this.includedFiles != null && newImports.size() == this.includedFiles.length;
        int i2 = 0;
        while (equals && i2 < newImports.size()) {
            if (((String)newImports.get(i2)).compareTo(this.includedFiles[i2]) != 0) {
                equals = false;
            }
            ++i2;
        }
        if (equals) {
            return;
        }
        IIncludePathEntry[] current = new IIncludePathEntry[]{};
        IJavaScriptProject javaProject = this.getJavaScriptProject();
        try {
            current = javaProject.getRawIncludepath();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
        int i3 = 0;
        while (i3 < current.length) {
            JsGlobalScopeContainerInitializer init = JSDScopeUtil.getContainerInitializer(current[i3].getPath());
            int k = 0;
            while (k < fileNames.length) {
                String[] newEntries = init.resolvedLibraryImport(fileNames[k]);
                if (newEntries != null && newEntries.length > 0) {
                    newImports.removeAll(Arrays.asList(newEntries));
                    newImports.addAll(Arrays.asList(newEntries));
                }
                ++k;
            }
            ++i3;
        }
        this.includedFiles = newImports.toArray(new String[newImports.size()]);
        this.updateClasspathIfNeeded();
        this.dojoHack();
    }

    public void setIncludedFiles(String[] fileNames) {
        String[] newImports = new String[fileNames.length];
        int arrayLength = 0;
        int i = 0;
        while (i < fileNames.length) {
            File importFile = this.isValidImport(fileNames[i]);
            if (importFile != null || fileNames[i].equals("*")) {
                if (fileNames[i].equals("*")) {
                    newImports[arrayLength++] = fileNames[i];
                } else {
                    IPath importPath = this.resolveChildPath(fileNames[i]);
                    newImports[arrayLength++] = importPath.toString();
                }
            }
            ++i;
        }
        boolean equals = this.includedFiles != null && arrayLength == this.includedFiles.length;
        int i2 = 0;
        while (equals && i2 < arrayLength) {
            if (newImports[i2].compareTo(this.includedFiles[i2]) != 0) {
                equals = false;
            }
            ++i2;
        }
        if (equals) {
            return;
        }
        this.includedFiles = new String[arrayLength];
        System.arraycopy(newImports, 0, this.includedFiles, 0, arrayLength);
        this.dojoHack();
        this.updateClasspathIfNeeded();
    }

    private void dojoHack() {
        int i = 0;
        while (i < this.includedFiles.length) {
            String newIncludeString;
            File djUncom;
            String includeString = this.includedFiles[i];
            int dojoIndex = includeString.toLowerCase().indexOf("dojo.js");
            if (includeString != null && dojoIndex >= 0 && (djUncom = this.isValidImport(newIncludeString = String.valueOf(includeString.substring(0, dojoIndex)) + "dojo.js.uncompressed.js" + includeString.substring(dojoIndex + "dojo.js".length(), includeString.length()))) != null && djUncom.exists()) {
                this.includedFiles[i] = newIncludeString;
            }
            ++i;
        }
    }

    private void updateClasspathIfNeeded() {
        ArrayList<IIncludePathEntry> newEntriesList = new ArrayList<IIncludePathEntry>();
        IJavaScriptProject javaProject = this.getJavaScriptProject();
        IResource myResource = this.getResource();
        IContainer folder = (IContainer)myResource;
        int i = 0;
        while (i < this.includedFiles.length) {
            IResource theFile = folder.findMember(this.includedFiles[i]);
            if (theFile != null && !javaProject.isOnIncludepath(theFile)) {
                IIncludePathEntry entry = JavaScriptCore.newLibraryEntry(theFile.getLocation().makeAbsolute(), null, null, new IAccessRule[0], new IIncludePathAttribute[]{IIncludePathAttribute.HIDE}, true);
                newEntriesList.add(entry);
            }
            ++i;
        }
        IIncludePathEntry[] current = new IIncludePathEntry[]{};
        try {
            current = javaProject.getRawIncludepath();
        }
        catch (JavaScriptModelException theFile) {
            // empty catch block
        }
        IIncludePathEntry[] newCpEntries = new IIncludePathEntry[newEntriesList.size() + current.length];
        System.arraycopy(current, 0, newCpEntries, 0, current.length);
        int newPtr = 0;
        int i2 = current.length;
        while (i2 < newCpEntries.length) {
            newCpEntries[i2] = (IIncludePathEntry)newEntriesList.get(newPtr++);
            ++i2;
        }
        try {
            javaProject.setRawIncludepath(newCpEntries, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
    }

    public IPath resolveChildPath(String childPathString) {
        if (this.getResource() == null) {
            return null;
        }
        if (childPathString == null) {
            return null;
        }
        if (childPathString.length() == 0) {
            return new Path("");
        }
        Path resolvedPath = null;
        switch (childPathString.charAt(0)) {
            default: {
                resolvedPath = new Path(childPathString);
                IResource member = ((IContainer)this.getResource()).findMember((IPath)resolvedPath);
                if (member != null && member.exists()) break;
            }
            case '/': 
            case '\\': {
                Path childPath = new Path(childPathString);
                IPath newPath = childPath.removeFirstSegments(childPath.matchingFirstSegments(this.webContext));
                IResource member = ((IContainer)this.getResource()).findMember(newPath);
                resolvedPath = newPath;
                if (member != null && member.exists()) break;
            }
            case '.': {
                IPath relative = null;
                try {
                    relative = this.fRelativeFile.getFullPath().removeLastSegments(1);
                }
                catch (Exception ex) {
                    return null;
                }
                IPath relRes = this.getResource().getFullPath();
                if (!relRes.isPrefixOf(relative)) break;
                IPath amended = relative.removeFirstSegments(relRes.matchingFirstSegments(relative));
                resolvedPath = amended.append(childPathString);
            }
        }
        return resolvedPath;
    }

    public IPath getPath() {
        if (this.fRelativeFile != null) {
            return this.fRelativeFile.getFullPath().removeLastSegments(1);
        }
        return super.getPath();
    }

    public boolean equals(Object o) {
        boolean equalRelativeFileAndIncludedFileLengths;
        if (!(o instanceof DocumentContextFragmentRoot)) {
            return false;
        }
        DocumentContextFragmentRoot other = (DocumentContextFragmentRoot)o;
        boolean bl = equalRelativeFileAndIncludedFileLengths = this.fRelativeFile != null && this.fRelativeFile.equals((Object)other.fRelativeFile) && this.includedFiles != null && other.includedFiles != null && this.includedFiles.length == other.includedFiles.length;
        if (!equalRelativeFileAndIncludedFileLengths) {
            return false;
        }
        int i = 0;
        while (i < this.includedFiles.length) {
            if (!this.includedFiles[i].equals(other.includedFiles[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getElementName() {
        if (this.fRelativeFile != null) {
            return this.fRelativeFile.getName();
        }
        return super.getElementName();
    }

    public int hashCode() {
        return this.fRelativeFile != null ? this.fRelativeFile.hashCode() : super.hashCode();
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean resourceExists() {
        return true;
    }

    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaScriptModelException {
        SearchableEnvironment env = super.newSearchableNameEnvironment(owner);
        int includeMask = 15;
        env.nameLookup.setRestrictedAccessRequestor(this.getRestrictedAccessRequestor());
        ((JavaSearchScope)env.searchScope).add((JavaProject)this.getJavaScriptProject(), includeMask, new HashSet(2));
        return env;
    }

    public NameLookup newNameLookup(IJavaScriptUnit[] workingCopies) throws JavaScriptModelException {
        this.workingCopies = workingCopies;
        NameLookup lookup = super.newNameLookup(this.workingCopies);
        lookup.setRestrictedAccessRequestor(this.getRestrictedAccessRequestor());
        return lookup;
    }

    public NameLookup newNameLookup(WorkingCopyOwner owner) throws JavaScriptModelException {
        NameLookup lookup = super.newNameLookup(owner);
        lookup.setRestrictedAccessRequestor(this.getRestrictedAccessRequestor());
        return lookup;
    }

    public File isValidImport(String importName) {
        IPath filePath = this.resolveChildPath(importName);
        if (filePath == null) {
            return null;
        }
        File file = filePath.toFile();
        if (file.isFile()) {
            return file;
        }
        IFile resolved = null;
        try {
            resolved = ((IContainer)this.getResource()).getFile((IPath)new Path(file.getPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resolved == null || !resolved.exists()) {
            return null;
        }
        if (!(importName.charAt(0) != '\\' && importName.charAt(0) != '/' || !EMPTY_PATH.equals((Object)this.webContext) && resolved.getFullPath().matchingFirstSegments(this.webContext) != 0)) {
            return null;
        }
        IPath resolvedLocation = resolved.getLocation();
        return resolvedLocation == null ? null : new File(resolved.getLocation().toString());
    }

    public int getKind() throws JavaScriptModelException {
        return 1;
    }

    public String toString() {
        StringBuffer me = new StringBuffer("Relative to: " + this.fRelativeFile.getName() + "\n");
        me.append("Absolute to: " + this.webContext + "\n");
        me.append("Included File\t\t\tLast Moddified\n");
        int i = 0;
        while (i < this.includedFiles.length) {
            me.append(String.valueOf(this.includedFiles[i]) + "\n");
            ++i;
        }
        return me.toString();
    }

    public IResource getResource() {
        return this.absolutePath;
    }

    class RestrictedDocumentBinding
    implements IRestrictedAccessBindingRequestor {
        private ArrayList foundPaths = new ArrayList();
        private String exclude;
        private boolean shown;

        RestrictedDocumentBinding() {
        }

        public void reset() {
            this.foundPaths.clear();
            this.shown = false;
        }

        public boolean acceptBinding(int type, int modifiers, char[] packageName, char[] simpleTypeName, String path, AccessRestriction access) {
            if (path != null && this.exclude != null && path.compareTo(this.exclude) == 0) {
                return false;
            }
            int i = 0;
            while (DocumentContextFragmentRoot.this.workingCopies != null && i < DocumentContextFragmentRoot.this.workingCopies.length) {
                if (DocumentContextFragmentRoot.this.workingCopies[i].getPath().toString().equals(path)) {
                    return false;
                }
                ++i;
            }
            this.foundPaths.add(path);
            return true;
        }

        public String getFoundPath() {
            return this.foundPaths.size() > 0 ? (String)this.foundPaths.get(0) : null;
        }

        public ArrayList getFoundPaths() {
            return this.foundPaths;
        }

        public void setExcludePath(String excludePath) {
            this.exclude = excludePath;
        }
    }
}

