/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JarEntryDirectory;
import org.eclipse.wst.jsdt.internal.core.JarEntryFile;
import org.eclipse.wst.jsdt.internal.core.JarEntryResource;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.JarPackageFragmentRootInfo;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MetadataFile;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class JarPackageFragment
extends PackageFragment {
    protected JarPackageFragment(PackageFragmentRoot root, String[] names) {
        super(root, names);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        JarPackageFragmentRoot root = (JarPackageFragmentRoot)this.getParent();
        JarPackageFragmentRootInfo parentInfo = (JarPackageFragmentRootInfo)root.getElementInfo();
        ArrayList[] entries = (ArrayList[])parentInfo.rawPackageInfo.get(this.names);
        if (entries == null) {
            throw this.newNotPresentException();
        }
        JarPackageFragmentInfo fragInfo = (JarPackageFragmentInfo)info;
        fragInfo.setChildren(this.computeChildren(entries[0]));
        fragInfo.setNonJavaResources(this.computeNonJavaResources(entries[1]));
        newElements.put(this, fragInfo);
        return true;
    }

    private IJavaScriptElement[] computeChildren(ArrayList names) {
        int size = names.size();
        IJavaScriptElement[] children = new IJavaScriptElement[size];
        int i = 0;
        while (i < size) {
            String path = (String)names.get(i);
            children[i] = new ClassFile(this, path);
            ++i;
        }
        return children;
    }

    private Object[] computeNonJavaResources(ArrayList entryNames) {
        int length = entryNames.size();
        if (length == 0) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        HashMap<IPath, JarEntryResource> jarEntries = new HashMap<IPath, JarEntryResource>();
        HashMap<IPath, ArrayList<IPath>> childrenMap = new HashMap<IPath, ArrayList<IPath>>();
        ArrayList<JarEntryResource> topJarEntries = new ArrayList<JarEntryResource>();
        int i = 0;
        while (i < length) {
            Path filePath;
            IPath childPath;
            String resName = (String)entryNames.get(i);
            if (!Util.isJavaLikeFileName(resName) && !jarEntries.containsKey(childPath = (filePath = new Path(resName)).removeFirstSegments(this.names.length))) {
                JarEntryFile file = new JarEntryFile(filePath.lastSegment());
                jarEntries.put(childPath, file);
                if (childPath.segmentCount() == 1) {
                    file.setParent(this);
                    topJarEntries.add(file);
                } else {
                    IPath parentPath = childPath.removeLastSegments(1);
                    while (parentPath.segmentCount() > 0) {
                        ArrayList<IPath> parentChildren = (ArrayList<IPath>)childrenMap.get(parentPath);
                        if (parentChildren == null) {
                            JarEntryDirectory dir = new JarEntryDirectory(parentPath.lastSegment());
                            jarEntries.put(parentPath, dir);
                            parentChildren = new ArrayList<IPath>();
                            childrenMap.put(parentPath, parentChildren);
                            parentChildren.add(childPath);
                            if (parentPath.segmentCount() == 1) {
                                topJarEntries.add(dir);
                                break;
                            }
                            childPath = parentPath;
                            parentPath = childPath.removeLastSegments(1);
                            continue;
                        }
                        parentChildren.add(childPath);
                        break;
                    }
                }
            }
            ++i;
        }
        for (Map.Entry entry : childrenMap.entrySet()) {
            IPath entryPath = (IPath)entry.getKey();
            ArrayList entryValue = (ArrayList)entry.getValue();
            JarEntryDirectory jarEntryDirectory = (JarEntryDirectory)jarEntries.get(entryPath);
            int size = entryValue.size();
            IJarEntryResource[] children = new IJarEntryResource[size];
            int i2 = 0;
            while (i2 < size) {
                JarEntryResource child = (JarEntryResource)jarEntries.get(entryValue.get(i2));
                child.setParent(jarEntryDirectory);
                children[i2] = child;
                ++i2;
            }
            jarEntryDirectory.setChildren(children);
            if (entryPath.segmentCount() != 1) continue;
            jarEntryDirectory.setParent(this);
        }
        return topJarEntries.toArray(new Object[topJarEntries.size()]);
    }

    public boolean containsJavaResources() throws JavaScriptModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    public IJavaScriptUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        throw new JavaScriptModelException(new JavaModelStatus(976, this));
    }

    protected Object createElementInfo() {
        return new JarPackageFragmentInfo();
    }

    public IClassFile[] getClassFiles() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    public IClassFile getClassFile(String classFileName) {
        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(classFileName) && !Util.isMetadataFileName(classFileName)) {
            throw new IllegalArgumentException(Messages.element_invalidClassFileName);
        }
        String filename = classFileName;
        return !Util.isMetadataFileName(classFileName) ? new ClassFile(this, filename) : new MetadataFile(this, filename);
    }

    public IJavaScriptUnit[] getCompilationUnits() {
        return NO_COMPILATION_UNITS;
    }

    public IResource getCorrespondingResource() {
        return null;
    }

    public Object[] getNonJavaResources() throws JavaScriptModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonJavaResources() throws JavaScriptModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).getNonJavaResources();
    }
}

