/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public abstract class MultiOperation
extends JavaModelOperation {
    protected Map insertBeforeElements = new HashMap(1);
    protected Map newParents;
    protected Map renamings;
    protected String[] renamingsList = null;

    protected MultiOperation(IJavaScriptElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    protected MultiOperation(IJavaScriptElement[] elementsToProcess, IJavaScriptElement[] parentElements, boolean force) {
        super(elementsToProcess, parentElements, force);
        this.newParents = new HashMap(elementsToProcess.length);
        if (elementsToProcess.length == parentElements.length) {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.newParents.put(elementsToProcess[i], parentElements[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < elementsToProcess.length) {
                this.newParents.put(elementsToProcess[i], parentElements[0]);
                ++i;
            }
        }
    }

    protected void error(int code, IJavaScriptElement element) throws JavaScriptModelException {
        throw new JavaScriptModelException(new JavaModelStatus(code, element));
    }

    protected void executeOperation() throws JavaScriptModelException {
        this.processElements();
    }

    protected IJavaScriptElement getDestinationParent(IJavaScriptElement child) {
        return (IJavaScriptElement)this.newParents.get(child);
    }

    protected abstract String getMainTaskName();

    protected String getNewNameFor(IJavaScriptElement element) throws JavaScriptModelException {
        String newName = null;
        if (this.renamings != null) {
            newName = (String)this.renamings.get(element);
        }
        if (newName == null && element instanceof IFunction && ((IFunction)element).isConstructor()) {
            newName = this.getDestinationParent(element).getElementName();
        }
        return newName;
    }

    private void initializeRenamings() {
        if (this.renamingsList != null && this.renamingsList.length == this.elementsToProcess.length) {
            this.renamings = new HashMap(this.renamingsList.length);
            int i = 0;
            while (i < this.renamingsList.length) {
                if (this.renamingsList[i] != null) {
                    this.renamings.put(this.elementsToProcess[i], this.renamingsList[i]);
                }
                ++i;
            }
        }
    }

    protected boolean isMove() {
        return false;
    }

    protected boolean isRename() {
        return false;
    }

    protected abstract void processElement(IJavaScriptElement var1) throws JavaScriptModelException;

    protected void processElements() throws JavaScriptModelException {
        try {
            this.beginTask(this.getMainTaskName(), this.elementsToProcess.length);
            IJavaScriptModelStatus[] errors = new IJavaScriptModelStatus[3];
            int errorsCounter = 0;
            int i = 0;
            while (i < this.elementsToProcess.length) {
                block13: {
                    try {
                        try {
                            this.verify(this.elementsToProcess[i]);
                            this.processElement(this.elementsToProcess[i]);
                        }
                        catch (JavaScriptModelException jme) {
                            if (errorsCounter == errors.length) {
                                IJavaScriptModelStatus[] iJavaScriptModelStatusArray = errors;
                                errors = new IJavaScriptModelStatus[errorsCounter * 2];
                                System.arraycopy(iJavaScriptModelStatusArray, 0, errors, 0, errorsCounter);
                            }
                            errors[errorsCounter++] = jme.getJavaScriptModelStatus();
                            this.worked(1);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        this.worked(1);
                        throw throwable;
                    }
                    this.worked(1);
                }
                ++i;
            }
            if (errorsCounter == 1) {
                throw new JavaScriptModelException(errors[0]);
            }
            if (errorsCounter > 1) {
                if (errorsCounter != errors.length) {
                    IJavaScriptModelStatus[] iJavaScriptModelStatusArray = errors;
                    errors = new IJavaScriptModelStatus[errorsCounter];
                    System.arraycopy(iJavaScriptModelStatusArray, 0, errors, 0, errorsCounter);
                }
                throw new JavaScriptModelException(JavaModelStatus.newMultiStatus(errors));
            }
        }
        finally {
            this.done();
        }
    }

    public void setInsertBefore(IJavaScriptElement modifiedElement, IJavaScriptElement newSibling) {
        this.insertBeforeElements.put(modifiedElement, newSibling);
    }

    public void setRenamings(String[] renamingsList) {
        this.renamingsList = renamingsList;
        this.initializeRenamings();
    }

    protected abstract void verify(IJavaScriptElement var1) throws JavaScriptModelException;

    protected void verifyDestination(IJavaScriptElement element, IJavaScriptElement destination) throws JavaScriptModelException {
        if (destination == null || !destination.exists()) {
            this.error(969, destination);
        }
        int destType = destination.getElementType();
        switch (element.getElementType()) {
            case 13: {
                if (destType == 5) break;
                this.error(978, element);
                break;
            }
            case 7: {
                if (destType == 5 || destType == 7) break;
                this.error(978, element);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                if ((destType == 7 || destType == 5) && !(destination instanceof BinaryType)) break;
                this.error(978, element);
                break;
            }
            case 5: {
                if (destType != 4) {
                    this.error(978, element);
                    break;
                }
                CompilationUnit cu = (CompilationUnit)element;
                if (!this.isMove() || !cu.isWorkingCopy() || cu.isPrimary()) break;
                this.error(967, element);
                break;
            }
            case 4: {
                IPackageFragment fragment = (IPackageFragment)element;
                IJavaScriptElement parent = fragment.getParent();
                if (parent.isReadOnly()) {
                    this.error(976, element);
                    break;
                }
                if (destType == 3) break;
                this.error(978, element);
                break;
            }
            default: {
                this.error(967, element);
            }
        }
    }

    protected void verifyRenaming(IJavaScriptElement element) throws JavaScriptModelException {
        String newName = this.getNewNameFor(element);
        boolean isValid = true;
        IJavaScriptProject project = element.getJavaScriptProject();
        String sourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String complianceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        switch (element.getElementType()) {
            case 4: {
                if (((IPackageFragment)element).isDefaultPackage()) {
                    throw new JavaScriptModelException(new JavaModelStatus(977, element));
                }
                isValid = JavaScriptConventions.validatePackageName(newName, sourceLevel, complianceLevel).getSeverity() != 4;
                break;
            }
            case 5: {
                isValid = JavaScriptConventions.validateCompilationUnitName(newName, sourceLevel, complianceLevel).getSeverity() != 4;
                break;
            }
            case 10: {
                isValid = false;
                break;
            }
            default: {
                boolean bl = isValid = JavaScriptConventions.validateIdentifier(newName, sourceLevel, complianceLevel).getSeverity() != 4;
            }
        }
        if (!isValid) {
            throw new JavaScriptModelException(new JavaModelStatus(983, element, newName));
        }
    }

    protected void verifySibling(IJavaScriptElement element, IJavaScriptElement destination) throws JavaScriptModelException {
        IJavaScriptElement insertBeforeElement = (IJavaScriptElement)this.insertBeforeElements.get(element);
        if (!(insertBeforeElement == null || insertBeforeElement.exists() && insertBeforeElement.getParent().equals(destination))) {
            this.error(993, insertBeforeElement);
        }
    }
}

