/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.wst.jsdt.internal.core.builder.IncrementalImageBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.JavaBuilder;
import org.eclipse.wst.jsdt.internal.core.builder.SourceFile;
import org.eclipse.wst.jsdt.internal.core.builder.StringSet;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class BatchImageBuilder
extends AbstractImageBuilder {
    IncrementalImageBuilder incrementalBuilder;
    ArrayList secondaryTypes;
    StringSet typeLocatorsWithUndefinedTypes;

    protected BatchImageBuilder(JavaBuilder javaBuilder, boolean buildStarting) {
        super(javaBuilder, buildStarting, null);
        this.nameEnvironment.isIncrementalBuild = false;
        this.incrementalBuilder = null;
        this.secondaryTypes = null;
        this.typeLocatorsWithUndefinedTypes = null;
    }

    public void build() {
        if (JavaBuilder.DEBUG) {
            System.out.println("FULL build");
        }
        try {
            try {
                JavaBuilder.removeProblemsAndTasksFor((IResource)this.javaBuilder.currentProject);
                this.notifier.updateProgressDelta(0.05f);
                this.notifier.subTask(Messages.build_analyzingSources);
                ArrayList sourceFiles = new ArrayList(33);
                this.addAllSourceFiles(sourceFiles);
                this.notifier.updateProgressDelta(0.1f);
                if (sourceFiles.size() > 0) {
                    SourceFile[] allSourceFiles = new SourceFile[sourceFiles.size()];
                    sourceFiles.toArray(allSourceFiles);
                    this.notifier.setProgressPerCompilationUnit(0.75f / (float)allSourceFiles.length);
                    this.workQueue.addAll(allSourceFiles);
                    this.compile(allSourceFiles);
                    if (this.typeLocatorsWithUndefinedTypes != null && this.secondaryTypes != null && !this.secondaryTypes.isEmpty()) {
                        this.rebuildTypesAffectedBySecondaryTypes();
                    }
                    if (this.incrementalBuilder != null) {
                        this.incrementalBuilder.buildAfterBatchBuild();
                    }
                }
                if (this.javaBuilder.javaProject.hasCycleMarker()) {
                    this.javaBuilder.mustPropagateStructuralChanges();
                }
            }
            catch (CoreException e) {
                throw this.internalException(e);
            }
        }
        finally {
            this.cleanUp();
        }
    }

    protected void cleanUp() {
        this.incrementalBuilder = null;
        this.secondaryTypes = null;
        this.typeLocatorsWithUndefinedTypes = null;
        super.cleanUp();
    }

    protected void compile(SourceFile[] units, SourceFile[] additionalUnits, boolean compilingFirstGroup) {
        if (additionalUnits != null && this.secondaryTypes == null) {
            this.secondaryTypes = new ArrayList(7);
        }
        super.compile(units, additionalUnits, compilingFirstGroup);
    }

    protected IResource findOriginalResource(IPath partialPath) {
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            IFile originalResource;
            ClasspathMultiDirectory sourceLocation = this.sourceLocations[i];
            if (sourceLocation.hasIndependentOutputFolder && (originalResource = sourceLocation.sourceFolder.getFile(partialPath)).exists()) {
                return originalResource;
            }
            ++i;
        }
        return null;
    }

    protected void rebuildTypesAffectedBySecondaryTypes() {
        if (this.incrementalBuilder == null) {
            this.incrementalBuilder = new IncrementalImageBuilder(this);
        }
        int i = this.secondaryTypes.size();
        while (--i >= 0) {
            char[] secondaryTypeName = (char[])this.secondaryTypes.get(i);
            Path path = new Path(null, new String(secondaryTypeName));
            this.incrementalBuilder.addDependentsOf((IPath)path, false);
        }
        this.incrementalBuilder.addAffectedSourceFiles(this.incrementalBuilder.qualifiedStrings, this.incrementalBuilder.simpleStrings, this.typeLocatorsWithUndefinedTypes);
    }

    protected void storeProblemsFor(SourceFile sourceFile, CategorizedProblem[] problems) throws CoreException {
        if (sourceFile == null || problems == null || problems.length == 0) {
            return;
        }
        int i = problems.length;
        while (--i >= 0) {
            CategorizedProblem problem = problems[i];
            if (problem == null || problem.getID() != 0x1000002) continue;
            if (this.typeLocatorsWithUndefinedTypes == null) {
                this.typeLocatorsWithUndefinedTypes = new StringSet(3);
            }
            this.typeLocatorsWithUndefinedTypes.add(sourceFile.typeLocator());
            break;
        }
        super.storeProblemsFor(sourceFile, problems);
    }

    public String toString() {
        return "batch image builder for:\n\tnew state: " + this.newState;
    }
}

